/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import java.io.Serializable;
import prpobjects.uruobj;
import shared.Format;
import shared.m;
import shared.uncaughtexception;
import uru.Bytedeque;
import uru.context;

public class Pageid
extends uruobj
implements Serializable {
    private static final long serialVersionUID = -4399754547712612873L;
    public static final int kStateInvalid = 0;
    public static final int kStateNormal = 1;
    public static final int kStateVirtual = 2;
    private int type;
    private int prefix;
    private int pagenum;

    public Pageid(context c) {
        Integer newpagenum;
        int shift;
        if (c.readversion == 6) {
            shift = 16;
        } else if (c.readversion == 3 || c.readversion == 4 || c.readversion == 7) {
            shift = 8;
        } else {
            throw new uncaughtexception("unhandled");
        }
        int rawdata = c.in.readInt();
        if (rawdata == -1) {
            this.type = 0;
        } else if (rawdata == 0) {
            this.type = 2;
        } else {
            int cleandata;
            this.type = 1;
            if ((rawdata & Integer.MIN_VALUE) != 0) {
                cleandata = rawdata - (shift == 16 ? -16777215 : -65535);
                this.prefix = cleandata >>> shift;
                this.pagenum = cleandata - (this.prefix << shift);
                this.prefix = -this.prefix;
            } else {
                cleandata = rawdata - 33;
                this.prefix = cleandata >>> shift;
                this.pagenum = cleandata - (this.prefix << shift);
            }
        }
        if (shift == 16) {
            this.pagenum = (this.pagenum & 0x8000) != 0 ? this.pagenum | 0xFFFF0000 : this.pagenum;
        } else {
            int n = this.pagenum = (this.pagenum & 0x80) != 0 ? this.pagenum | 0xFFFFFF00 : this.pagenum;
        }
        if (c.sequencePrefix != null) {
            this.prefix = c.sequencePrefix;
        }
        if (c.pagenumMap != null && (newpagenum = c.pagenumMap.get(this.getPageNumber())) != null) {
            this.setPagenum(newpagenum);
        }
    }

    public int getPageNumber() {
        return this.pagenum;
    }

    public void setPagenum(int val) {
        this.pagenum = val;
    }

    private Pageid() {
    }

    public static Pageid createFromPrefixPagenum(int prefix, int pagenum) {
        if (pagenum < -2) {
            m.err("Unhandled pagenum: investigate now!");
        }
        Pageid r = new Pageid();
        r.type = 1;
        r.prefix = prefix;
        r.pagenum = pagenum;
        return r;
    }

    public int getSequencePrefix() {
        return this.prefix;
    }

    public void setSequencePrefix(int val) {
        this.prefix = val;
    }

    public void compile(Bytedeque deque) {
        if (this.type == 0) {
            deque.writeInt(-1);
        } else if (this.type == 2) {
            deque.writeInt(0);
        } else {
            int smallpagenum;
            int _pagenum;
            int shift;
            if (deque.format == Format.moul) {
                shift = 16;
            } else if (deque.format == Format.pots || deque.format == Format.crowthistle || deque.format == Format.hexisle) {
                shift = 8;
            } else {
                throw new uncaughtexception("unhandled");
            }
            int _prefix = this.prefix;
            if (shift == 8) {
                if (_prefix < 0) {
                    for (_pagenum = this.pagenum; _pagenum >= 256; _pagenum -= 256) {
                        --_prefix;
                    }
                } else {
                    while (_pagenum >= 256) {
                        ++_prefix;
                        _pagenum -= 256;
                    }
                }
            }
            if (shift == 8 && _pagenum < -10) {
                m.throwUncaughtException("unsure");
            }
            int n = smallpagenum = shift == 16 ? _pagenum & 0xFFFF : _pagenum & 0xFF;
            if (_prefix < 0) {
                int val = smallpagenum - (_prefix << shift) + (shift == 16 ? -16777215 : -65535);
                deque.writeInt(val);
            } else {
                int val = smallpagenum + (_prefix << shift) + 33;
                deque.writeInt(val);
            }
        }
    }

    public String toString() {
        return Integer.toString(this.prefix) + ":" + Integer.toString(this.pagenum);
    }

    public String toString2() {
        return "Prefix=" + Integer.toString(this.prefix) + ", Pagenum=" + Integer.toString(this.pagenum);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Pageid)) {
            return false;
        }
        Pageid o2 = (Pageid)o;
        if (this.type != o2.type) {
            return false;
        }
        if (this.prefix != o2.prefix) {
            return false;
        }
        return this.pagenum == o2.pagenum;
    }

    public int hashCode() {
        return this.prefix + this.pagenum << 16;
    }

    public Pageid deepClone() {
        Pageid result = new Pageid();
        result.type = this.type;
        result.prefix = this.prefix;
        result.pagenum = this.pagenum;
        return result;
    }
}

