/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.util.ArrayList;
import moulserver.SuperManager;
import parsers.sdlparser;
import prpobjects.PrpTaggedSizedObject;
import prpobjects.Rgb8;
import prpobjects.Uruobjectdesc;
import prpobjects.Urustring;
import prpobjects.uruobj;
import shared.FixedLengthString;
import shared.IBytestream;
import shared.Quat;
import shared.Timestamp;
import shared.Vertex;
import shared.b;
import shared.m;
import shared.nested;
import shared.uncaughtexception;
import uru.Bytedeque;
import uru.context;

public class SdlBinary
extends uruobj {
    public static final int kVolatile = 1;
    public static final int kHasUoid = 1;
    public static final int kHasNotificationInfo = 2;
    public static final int kHasTimeStamp = 4;
    public static final int kSameAsDefault = 8;
    public static final int kHasDirtyFlag = 16;
    public static final int kWantTimeStamp = 32;
    public static final byte kNone = -1;
    public static final byte kInt = 0;
    public static final byte kFloat = 1;
    public static final byte kBool = 2;
    public static final byte kString = 3;
    public static final byte kKey = 4;
    public static final byte kStateDescriptor = 5;
    public static final byte kCreatable = 6;
    public static final byte kDouble = 7;
    public static final byte kTime = 8;
    public static final byte kByte = 9;
    public static final byte kShort = 10;
    public static final byte kAgeTimeOfDay = 11;
    public static final byte kVector3 = 50;
    public static final byte kPoint3 = 51;
    public static final byte kRGB = 52;
    public static final byte kRGBA = 53;
    public static final byte kQuaternion = 54;
    public static final byte kRGB8 = 55;
    public static final byte kRGBA8 = 56;
    short flag;
    Urustring name;
    short ver;
    plStateDataRecord statedata;

    public SdlBinary(context c) {
        this.flag = c.readShort();
        if ((this.flag & 0x8000) == 0) {
            m.throwUncaughtException("unhandled");
        }
        this.name = new Urustring(c);
        this.ver = c.readShort();
        int version = b.Int16ToInt32(this.ver);
        if ((this.flag & 1) != 0) {
            m.throwUncaughtException("unhandled");
        }
        sdlparser.Statedesc sd = SuperManager.getAgesInfo().getStatedesc(this.name.toString(), version);
        this.statedata = new plStateDataRecord(c, sd);
    }

    public void compile(Bytedeque c) {
        c.writeShort(this.flag);
        if ((this.flag & 0x8000) == 0) {
            m.throwUncaughtException("unhandled");
        }
        this.name.compile(c);
        c.writeShort(this.ver);
        int version = b.Int16ToInt32(this.ver);
        if ((this.flag & 1) != 0) {
            m.throwUncaughtException("unhandled");
        }
        sdlparser.Statedesc sd = SuperManager.getAgesInfo().getStatedesc(this.name.toString(), version);
        this.statedata.compile(c, sd);
    }

    public void update(SdlBinary sdl2) {
        this.mergeSimple(this.statedata.simpleVars, sdl2.statedata.simpleVars);
        this.mergeStruct(this.statedata.compoundVars, sdl2.statedata.compoundVars);
    }

    private void mergeSimple(plSimpleStateVariable[] current, plSimpleStateVariable[] update) {
        int length = current.length;
        for (int i = 0; i < length; ++i) {
            if (update[i] == null || update[i] == null || (update[i].simpleVarContents & 0x10) == 0) continue;
            current[i] = update[i];
        }
    }

    private void mergeStruct(plSDStateVariable[] current, plSDStateVariable[] update) {
        int length = current.length;
        for (int i = 0; i < length; ++i) {
            if (update[i] == null) continue;
            if (current[i] == null) {
                current[i] = update[i];
                continue;
            }
            if (current[i].countVars() != update[i].countVars()) {
                m.warn("should we do something different?");
            }
            current[i] = update[i];
        }
    }

    static int readSmallest(IBytestream c, int totalvarcount) {
        if (totalvarcount < 256) {
            return b.ByteToInt32(c.readByte());
        }
        if (totalvarcount < 65536) {
            return b.Int16ToInt32(c.readShort());
        }
        return c.readInt();
    }

    static void writeSmallest(Bytedeque c, int totalvarcount, int val) {
        if (totalvarcount < 256) {
            c.writeByte((byte)val);
        } else if (totalvarcount < 65536) {
            c.writeShort((short)val);
        } else {
            c.writeInt(val);
        }
    }

    public static abstract class plStateVariable {
        byte contents;
        byte xu1;
        Urustring hintString;

        public plStateVariable(context c) {
            this.contents = c.readByte();
            if ((this.contents & 2) != 0) {
                this.xu1 = c.readByte();
                this.hintString = new Urustring(c);
            }
        }

        public void compile(Bytedeque c, sdlparser.Varline varinfo) {
            c.writeByte(this.contents);
            if ((this.contents & 2) != 0) {
                c.writeByte(this.xu1);
                this.hintString.compile(c);
            }
        }
    }

    public static class plSDStateVariable
    extends plStateVariable {
        byte u1;
        plStateDataRecord[] vars;

        public plSDStateVariable(context c, sdlparser.Varline varinfo) {
            super(c);
            String statedescName = ((sdlparser.TypeStatedesc)varinfo.type).typestr;
            sdlparser.Statedesc sd = SuperManager.getAgesInfo().getNewestStatedesc(statedescName);
            this.u1 = c.readByte();
            int totalvarcount = varinfo.isVariableLength() ? c.readInt() : varinfo.getCount();
            int count = SdlBinary.readSmallest(c.in, totalvarcount);
            boolean isAllVars = count == totalvarcount;
            this.vars = new plStateDataRecord[totalvarcount];
            for (int i = 0; i < count; ++i) {
                int index = isAllVars ? i : SdlBinary.readSmallest(c.in, totalvarcount) - 1;
                this.vars[index] = new plStateDataRecord(c, sd);
            }
        }

        public int countVars() {
            int count = 0;
            for (plStateDataRecord sd : this.vars) {
                if (sd == null) continue;
                ++count;
            }
            return count;
        }

        public void compile(Bytedeque c, sdlparser.Varline varinfo) {
            super.compile(c, varinfo);
            String statedescName = ((sdlparser.TypeStatedesc)varinfo.type).typestr;
            sdlparser.Statedesc sd = SuperManager.getAgesInfo().getNewestStatedesc(statedescName);
            c.writeByte(this.u1);
            int totalvarcount = this.vars.length;
            if (varinfo.isVariableLength()) {
                c.writeInt(totalvarcount);
            }
            int count = 0;
            for (int i = 0; i < this.vars.length; ++i) {
                if (this.vars[i] == null) continue;
                ++count;
            }
            SdlBinary.writeSmallest(c, totalvarcount, count);
            boolean isAllVars = count == totalvarcount;
            for (int index = 0; index < this.vars.length; ++index) {
                this.vars[index].compile(c, sd);
            }
        }
    }

    public static class plSimpleStateVariable
    extends plStateVariable {
        byte simpleVarContents;
        Timestamp timestamp;
        Object[] vals;

        public plSimpleStateVariable(context c, sdlparser.Varline varinfo) {
            super(c);
            this.simpleVarContents = c.readByte();
            if ((this.simpleVarContents & 4) != 0) {
                this.timestamp = new Timestamp(c.in);
            }
            if ((this.simpleVarContents & 8) == 0) {
                int count;
                if (varinfo.isVariableLength()) {
                    count = c.readInt();
                    if (count > 9999) {
                        m.throwUncaughtException("out of range");
                    }
                } else {
                    count = varinfo.getCount();
                }
                this.vals = new Object[count];
                try {
                    block18: for (int i = 0; i < count; ++i) {
                        switch (varinfo.type.type) {
                            case 0: {
                                this.vals[i] = c.readInt();
                                continue block18;
                            }
                            case 9: {
                                this.vals[i] = c.readByte();
                                continue block18;
                            }
                            case 2: {
                                this.vals[i] = c.readByte();
                                continue block18;
                            }
                            case 1: {
                                this.vals[i] = Float.valueOf(c.readFloat());
                                continue block18;
                            }
                            case 6: {
                                this.vals[i] = new PrpTaggedSizedObject(c);
                                continue block18;
                            }
                            case 8: {
                                this.vals[i] = new Timestamp(c.in);
                                continue block18;
                            }
                            case 3: {
                                this.vals[i] = new FixedLengthString(c.in, 32);
                                continue block18;
                            }
                            case 10: {
                                this.vals[i] = c.readShort();
                                continue block18;
                            }
                            case 4: {
                                this.vals[i] = new Uruobjectdesc(c);
                                continue block18;
                            }
                            case 51: {
                                this.vals[i] = new Vertex(c.in);
                                continue block18;
                            }
                            case 55: {
                                this.vals[i] = new Rgb8(c);
                                continue block18;
                            }
                            case 11: {
                                this.vals[i] = new Object();
                                continue block18;
                            }
                            case 54: {
                                this.vals[i] = new Quat(c);
                                continue block18;
                            }
                            case 50: {
                                this.vals[i] = new Vertex(c.in);
                                continue block18;
                            }
                            default: {
                                throw new uncaughtexception("unimplemented1");
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    throw new nested(e2);
                }
            } else {
                this.toDefault(varinfo);
            }
        }

        public void compile(Bytedeque c, sdlparser.Varline varinfo) {
            super.compile(c, varinfo);
            c.writeByte(this.simpleVarContents);
            if ((this.simpleVarContents & 4) != 0) {
                this.timestamp.compile(c);
            }
            int count = this.vals.length;
            if ((this.simpleVarContents & 8) == 0) {
                if (varinfo.isVariableLength()) {
                    c.writeInt(count);
                    if (count > 9999) {
                        m.throwUncaughtException("out of range");
                    }
                }
                try {
                    block18: for (int i = 0; i < this.vals.length; ++i) {
                        switch (varinfo.type.type) {
                            case 0: {
                                c.writeInt((Integer)this.vals[i]);
                                continue block18;
                            }
                            case 9: {
                                c.writeByte((Byte)this.vals[i]);
                                continue block18;
                            }
                            case 2: {
                                c.writeByte((Byte)this.vals[i]);
                                continue block18;
                            }
                            case 1: {
                                c.writeFloat(((Float)this.vals[i]).floatValue());
                                continue block18;
                            }
                            case 6: {
                                ((PrpTaggedSizedObject)this.vals[i]).compile(c);
                                continue block18;
                            }
                            case 8: {
                                ((Timestamp)this.vals[i]).compile(c);
                                continue block18;
                            }
                            case 3: {
                                ((FixedLengthString)this.vals[i]).compile(c);
                                continue block18;
                            }
                            case 10: {
                                c.writeShort((Short)this.vals[i]);
                                continue block18;
                            }
                            case 4: {
                                ((Uruobjectdesc)this.vals[i]).compile(c);
                                continue block18;
                            }
                            case 51: {
                                ((Vertex)this.vals[i]).compile(c);
                                continue block18;
                            }
                            case 55: {
                                ((Rgb8)this.vals[i]).compile(c);
                                continue block18;
                            }
                            case 11: {
                                continue block18;
                            }
                            case 54: {
                                ((Quat)this.vals[i]).compile(c);
                                continue block18;
                            }
                            case 50: {
                                ((Vertex)this.vals[i]).compile(c);
                                continue block18;
                            }
                            default: {
                                throw new uncaughtexception("unimplemented2");
                            }
                        }
                    }
                }
                catch (Exception e2) {
                    throw new nested(e2);
                }
            }
        }

        public void toDefault(sdlparser.Varline varinfo) {
            sdlparser.Value defval = varinfo.getDefault();
            Object def = defval == null ? null : defval.getValue();
            this.vals = new Object[varinfo.getCount()];
            block10: for (int i = 0; i < varinfo.getCount(); ++i) {
                switch (varinfo.type.type) {
                    case 0: {
                        if (def == null) {
                            this.vals[i] = 0;
                            continue block10;
                        }
                        this.vals[i] = (Integer)def;
                        continue block10;
                    }
                    case 9: {
                        if (def == null) {
                            this.vals[i] = (byte)0;
                            continue block10;
                        }
                        this.vals[i] = ((Integer)def).byteValue();
                        continue block10;
                    }
                    case 2: {
                        if (def == null) {
                            this.vals[i] = (byte)0;
                            continue block10;
                        }
                        this.vals[i] = ((Integer)def).byteValue();
                        continue block10;
                    }
                    case 1: {
                        if (def == null) {
                            this.vals[i] = Float.valueOf(0.0f);
                            continue block10;
                        }
                        if (def.getClass() == Float.class) {
                            this.vals[i] = (Float)def;
                            continue block10;
                        }
                        if (def.getClass() == Integer.class) {
                            this.vals[i] = Float.valueOf(((Integer)def).intValue());
                            continue block10;
                        }
                        m.throwUncaughtException("unexpected");
                        continue block10;
                    }
                    case 4: {
                        continue block10;
                    }
                    case 54: {
                        if (def == null) {
                            this.vals[i] = new Quat(0.0f, 0.0f, 0.0f, 0.0f);
                            continue block10;
                        }
                        ArrayList quatvals = (ArrayList)def;
                        float w = ((sdlparser.Value)quatvals.get(0)).AsFloat();
                        float x = ((sdlparser.Value)quatvals.get(1)).AsFloat();
                        float y = ((sdlparser.Value)quatvals.get(2)).AsFloat();
                        float z = ((sdlparser.Value)quatvals.get(3)).AsFloat();
                        this.vals[i] = new Quat(w, x, y, z);
                        if (quatvals.size() <= 4) continue block10;
                        throw new uncaughtexception("unexpected");
                    }
                    case 50: {
                        if (def == null) {
                            this.vals[i] = new Vertex(0.0f, 0.0f, 0.0f);
                            continue block10;
                        }
                        ArrayList tupvals = (ArrayList)def;
                        float x = ((sdlparser.Value)tupvals.get(0)).AsFloat();
                        float y = ((sdlparser.Value)tupvals.get(1)).AsFloat();
                        float z = ((sdlparser.Value)tupvals.get(2)).AsFloat();
                        this.vals[i] = new Vertex(x, y, z);
                        if (tupvals.size() <= 3) continue block10;
                        throw new uncaughtexception("unexpected");
                    }
                    case 3: {
                        if (def == null) {
                            this.vals[i] = new FixedLengthString("", 32);
                            continue block10;
                        }
                        this.vals[i] = new FixedLengthString((String)def, 32);
                        continue block10;
                    }
                    default: {
                        boolean dummy = false;
                        throw new uncaughtexception("unimplemented3");
                    }
                }
            }
            boolean dummy = false;
        }
    }

    public static class plStateDataRecord {
        short flags;
        byte ioversion;
        plSimpleStateVariable[] simpleVars;
        plSDStateVariable[] compoundVars;

        public plStateDataRecord(context c, sdlparser.Statedesc sd) {
            sdlparser.Varline varinfo;
            int index;
            int i;
            int totalvarcount;
            int varcount;
            this.flags = c.readShort();
            this.ioversion = c.readByte();
            if (this.ioversion != 6) {
                m.throwUncaughtException("unexpected");
            }
            boolean isAllVars = (varcount = SdlBinary.readSmallest(c.in, totalvarcount = sd.getSimpleVarCount())) == totalvarcount;
            this.simpleVars = new plSimpleStateVariable[totalvarcount];
            for (i = 0; i < varcount; ++i) {
                index = isAllVars ? i : SdlBinary.readSmallest(c.in, totalvarcount);
                varinfo = sd.getSimpleVar(index);
                try {
                    if (varinfo.type.isStatedesc()) {
                        m.throwUncaughtException("unexpected");
                        continue;
                    }
                    this.simpleVars[index] = new plSimpleStateVariable(c, varinfo);
                    continue;
                }
                catch (Exception e2) {
                    throw new nested(e2);
                }
            }
            totalvarcount = sd.getStatedescVarCount();
            varcount = SdlBinary.readSmallest(c.in, totalvarcount);
            this.compoundVars = new plSDStateVariable[totalvarcount];
            isAllVars = varcount == totalvarcount;
            for (i = 0; i < varcount; ++i) {
                index = isAllVars ? i : SdlBinary.readSmallest(c.in, totalvarcount);
                varinfo = sd.getStatedescVar(index);
                try {
                    if (varinfo.type.isStatedesc()) {
                        this.compoundVars[index] = new plSDStateVariable(c, varinfo);
                        continue;
                    }
                    m.throwUncaughtException("unexpected");
                    continue;
                }
                catch (Exception e3) {
                    throw new nested(e3);
                }
            }
        }

        public void compile(Bytedeque c, sdlparser.Statedesc sd) {
            sdlparser.Varline varinfo;
            int index;
            int i;
            c.writeShort(this.flags);
            c.writeByte(this.ioversion);
            if (this.ioversion != 6) {
                m.throwUncaughtException("unexpected");
            }
            int totalvarcount = sd.getSimpleVarCount();
            int varcount = 0;
            for (i = 0; i < this.simpleVars.length; ++i) {
                if (this.simpleVars[i] == null) continue;
                ++varcount;
            }
            SdlBinary.writeSmallest(c, totalvarcount, varcount);
            boolean isAllVars = varcount == totalvarcount;
            for (index = 0; index < totalvarcount; ++index) {
                if (this.simpleVars[index] == null) continue;
                if (!isAllVars) {
                    SdlBinary.writeSmallest(c, totalvarcount, index);
                }
                varinfo = sd.getSimpleVar(index);
                this.simpleVars[index].compile(c, varinfo);
            }
            totalvarcount = sd.getStatedescVarCount();
            varcount = 0;
            for (i = 0; i < this.compoundVars.length; ++i) {
                if (this.compoundVars[i] == null) continue;
                ++varcount;
            }
            SdlBinary.writeSmallest(c, totalvarcount, varcount);
            isAllVars = varcount == totalvarcount;
            for (index = 0; index < totalvarcount; ++index) {
                if (this.compoundVars[index] == null) continue;
                if (!isAllVars) {
                    SdlBinary.writeSmallest(c, totalvarcount, index);
                }
                varinfo = sd.getStatedescVar(index);
                this.compoundVars[index].compile(c, varinfo);
            }
        }
    }
}

