/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.internal.core.UpdateCore;

public class URLEntryModel
extends ModelObject {
    private String annotation;
    private String localizedAnnotation;
    private String urlString;
    private URL url;
    private int type = 0;
    private URL bundleURL;
    private URL base;
    private boolean resolved = false;

    public String getAnnotation() {
        this.delayedResolve();
        if (this.localizedAnnotation != null) {
            return this.localizedAnnotation;
        }
        return this.annotation;
    }

    public String getAnnotationNonLocalized() {
        return this.annotation;
    }

    public String getURLString() {
        this.delayedResolve();
        return this.urlString;
    }

    public URL getURL() {
        this.delayedResolve();
        return this.url;
    }

    public void setAnnotation(String annotation) {
        this.assertIsWriteable();
        this.annotation = annotation;
        this.localizedAnnotation = null;
    }

    public void setURLString(String urlString) {
        this.assertIsWriteable();
        this.urlString = urlString;
        this.url = null;
    }

    public void resolve(URL base, URL bundleURL) throws MalformedURLException {
        this.base = base;
        this.bundleURL = bundleURL;
    }

    private void delayedResolve() {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        this.localizedAnnotation = this.resolveNLString(this.bundleURL, this.annotation);
        try {
            this.url = this.resolveURL(this.base, this.bundleURL, this.urlString);
        }
        catch (MalformedURLException e) {
            UpdateCore.warn("", e);
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int i) {
        this.type = i;
    }
}

