/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.AddUnimplementedConstructorsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.IVisibilityChangeListener;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;

public class AddUnimplementedConstructorsAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String DIALOG_TITLE = ActionMessages.getString("AddUnimplementedConstructorsAction.error.title");
    static /* synthetic */ Class class$org$eclipse$jface$text$IRewriteTarget;

    public AddUnimplementedConstructorsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("AddUnimplementedConstructorsAction.label"));
        this.setDescription(ActionMessages.getString("AddUnimplementedConstructorsAction.description"));
        this.setToolTipText(ActionMessages.getString("AddUnimplementedConstructorsAction.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.add_unimplemented_constructors_action_context");
    }

    public AddUnimplementedConstructorsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type = (IType)selection.getFirstElement();
            return type.getCompilationUnit() != null && type.isClass() && !type.isLocal();
        }
        return selection.size() == 1 && selection.getFirstElement() instanceof ICompilationUnit;
    }

    public void run(IStructuredSelection selection) {
        Shell shell = this.getShell();
        try {
            IType type = this.getSelectedType(selection);
            if (type == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.getString("AddUnimplementedConstructorsAction.not_applicable"));
                return;
            }
            if (type == null) {
                MessageDialog.openError((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.getString("AddUnimplementedConstructorsAction.error.type_removed_in_editor"));
                return;
            }
            this.run(shell, type, false);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, shell, this.getDialogTitle(), null);
        }
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void run(ITextSelection selection) {
        Shell shell = this.getShell();
        if (!ActionUtil.isProcessable(shell, this.fEditor)) {
            return;
        }
        try {
            IType type = SelectionConverter.getTypeAtOffset(this.fEditor);
            if (type != null) {
                this.run(shell, type, true);
            } else {
                MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.getString("AddUnimplementedConstructorsAction.not_applicable"));
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), this.getDialogTitle(), null);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), null);
        }
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Shell shell, IType type, boolean activatedFromEditor) throws CoreException {
        if (!ElementValidator.check((IJavaElement)type, this.getShell(), this.getDialogTitle(), activatedFromEditor)) {
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), type)) {
            return;
        }
        Object[] constructorMethods = StubUtility.getOverridableConstructors(type);
        if (constructorMethods.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.getString("AddUnimplementedConstructorsAction.error.nothing_found"));
            return;
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        AddUnimplementedConstructorsContentProvider contentProvider = new AddUnimplementedConstructorsContentProvider((IMethod[])constructorMethods);
        AddUnimplementedConstructorsDialog dialog = new AddUnimplementedConstructorsDialog(shell, (ILabelProvider)labelProvider, contentProvider, this.fEditor, type);
        dialog.setCommentString(ActionMessages.getString("SourceActionDialog.createConstructorComment"));
        dialog.setTitle(ActionMessages.getString("AddUnimplementedConstructorsAction.dialog.title"));
        dialog.setInitialSelections(constructorMethods);
        dialog.setContainerMode(true);
        dialog.setSorter(new JavaElementSorter());
        dialog.setSize(60, 18);
        dialog.setInput(new Object());
        dialog.setMessage(ActionMessages.getString("AddUnimplementedConstructorsAction.dialog.label"));
        dialog.setValidator(AddUnimplementedConstructorsAction.createValidator(constructorMethods.length));
        IMethod[] selected = null;
        int dialogResult = dialog.open();
        if (dialogResult == 0) {
            IRewriteTarget target;
            Object[] checkedElements = dialog.getResult();
            if (checkedElements == null) {
                return;
            }
            ArrayList<Object> result = new ArrayList<Object>(checkedElements.length);
            for (int i = 0; i < checkedElements.length; ++i) {
                Object curr = checkedElements[i];
                if (!(curr instanceof IMethod)) continue;
                result.add(curr);
            }
            selected = result.toArray(new IMethod[result.size()]);
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
            settings.createComments = dialog.getGenerateComment();
            IEditorPart editor = EditorUtility.openInEditor(type);
            IJavaElement elementPosition = dialog.getElementPosition();
            IRewriteTarget iRewriteTarget = editor != null ? (IRewriteTarget)editor.getAdapter(class$org$eclipse$jface$text$IRewriteTarget == null ? (class$org$eclipse$jface$text$IRewriteTarget = AddUnimplementedConstructorsAction.class$("org.eclipse.jface.text.IRewriteTarget")) : class$org$eclipse$jface$text$IRewriteTarget) : (target = null);
            if (target != null) {
                target.beginCompoundChange();
            }
            try {
                AddUnimplementedConstructorsOperation op = new AddUnimplementedConstructorsOperation(type, settings, selected, false, elementPosition);
                op.setVisibility(dialog.getVisibilityModifier());
                op.setOmitSuper(dialog.isOmitSuper());
                Object context = JavaPlugin.getActiveWorkbenchWindow();
                if (context == null) {
                    context = new BusyIndicatorRunnableContext();
                }
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
                IMethod[] res = op.getCreatedMethods();
                if (res == null || res.length == 0) {
                    MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.getString("AddUnimplementedConstructorsAction.error.nothing_found"));
                } else if (editor != null) {
                    JavaModelUtil.reconcile(res[0].getCompilationUnit());
                    EditorUtility.revealInEditor(editor, (IJavaElement)res[0]);
                }
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, shell, this.getDialogTitle(), null);
            }
            catch (InterruptedException e) {
            }
            finally {
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
    }

    private static ISelectionStatusValidator createValidator(int entries) {
        AddUnimplementedConstructorsValidator validator = new AddUnimplementedConstructorsValidator(entries);
        return validator;
    }

    private IType getSelectedType(IStructuredSelection selection) throws JavaModelException {
        ICompilationUnit cu;
        IType type;
        Object[] elements = selection.toArray();
        if (elements.length == 1 && elements[0] instanceof IType) {
            IType type2 = (IType)elements[0];
            if (type2.getCompilationUnit() != null && type2.isClass()) {
                return type2;
            }
        } else if (elements[0] instanceof ICompilationUnit && (type = (cu = (ICompilationUnit)elements[0]).findPrimaryType()) != null && !type.isInterface()) {
            return type;
        }
        return null;
    }

    private String getDialogTitle() {
        return DIALOG_TITLE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AddUnimplementedConstructorsDialog
    extends SourceActionDialog {
        private boolean fOmitSuper;
        private int fWidth = 60;
        private int fHeight = 18;
        private IDialogSettings fAddConstructorsSettings;
        private final String SETTINGS_SECTION = "AddUnimplementedConstructorsDialog";
        private final String OMIT_SUPER = "OmitCallToSuper";

        public AddUnimplementedConstructorsDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, CompilationUnitEditor editor, IType type) throws JavaModelException {
            super(parent, labelProvider, contentProvider, editor, type, true);
            IDialogSettings dialogSettings = JavaPlugin.getDefault().getDialogSettings();
            this.fAddConstructorsSettings = dialogSettings.getSection("AddUnimplementedConstructorsDialog");
            if (this.fAddConstructorsSettings == null) {
                this.fAddConstructorsSettings = dialogSettings.addNewSection("AddUnimplementedConstructorsDialog");
                this.fAddConstructorsSettings.put("OmitCallToSuper", false);
            }
            this.fOmitSuper = this.fAddConstructorsSettings.getBoolean("OmitCallToSuper");
        }

        protected Composite createEntryPtCombo(Composite composite) {
            Composite entryComposite = super.createEntryPtCombo(composite);
            this.addVisibilityAndModifiersChoices(entryComposite);
            return entryComposite;
        }

        protected Composite createVisibilityControlAndModifiers(Composite parent, IVisibilityChangeListener visibilityChangeListener, int[] availableVisibilities, int correctVisibility) {
            Composite visibilityComposite = this.createVisibilityControl(parent, visibilityChangeListener, availableVisibilities, correctVisibility);
            return visibilityComposite;
        }

        public boolean isOmitSuper() {
            return this.fOmitSuper;
        }

        public void setOmitSuper(boolean omitSuper) {
            if (this.fOmitSuper != omitSuper) {
                this.fOmitSuper = omitSuper;
                this.fAddConstructorsSettings.put("OmitCallToSuper", omitSuper);
            }
        }

        private Composite createOmitSuper(Composite composite) {
            Composite omitSuperComposite = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            omitSuperComposite.setLayout((Layout)layout);
            omitSuperComposite.setFont(composite.getFont());
            Button omitSuperButton = new Button(omitSuperComposite, 32);
            omitSuperButton.setText(ActionMessages.getString("AddUnimplementedConstructorsDialog.omit.super"));
            omitSuperButton.setLayoutData((Object)new GridData(256));
            omitSuperButton.addSelectionListener(new SelectionListener(this){
                private final /* synthetic */ AddUnimplementedConstructorsDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = ((Button)e.widget).getSelection();
                    this.this$0.setOmitSuper(isSelected);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            omitSuperButton.setSelection(this.isOmitSuper());
            GridData gd = new GridData(256);
            gd.horizontalSpan = 2;
            omitSuperButton.setLayoutData((Object)gd);
            return omitSuperComposite;
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            GridData gd = null;
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            Label messageLabel = this.createMessageArea(composite);
            if (messageLabel != null) {
                gd = new GridData(256);
                gd.horizontalSpan = 2;
                messageLabel.setLayoutData((Object)gd);
            }
            Composite inner = new Composite(composite, 0);
            GridLayout innerLayout = new GridLayout();
            innerLayout.numColumns = 2;
            innerLayout.marginHeight = 0;
            innerLayout.marginWidth = 0;
            inner.setLayout((Layout)innerLayout);
            inner.setFont(parent.getFont());
            CheckboxTreeViewer treeViewer = this.createTreeViewer(inner);
            gd = new GridData(1808);
            gd.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
            gd.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
            treeViewer.getControl().setLayoutData((Object)gd);
            Composite buttonComposite = this.createSelectionButtons(inner);
            gd = new GridData(272);
            buttonComposite.setLayoutData((Object)gd);
            gd = new GridData(1808);
            inner.setLayoutData((Object)gd);
            Composite entryComposite = this.createEntryPtCombo(composite);
            entryComposite.setLayoutData((Object)new GridData(768));
            Composite commentComposite = this.createCommentSelection(composite);
            commentComposite.setLayoutData((Object)new GridData(768));
            Composite overrideSuperComposite = this.createOmitSuper(composite);
            overrideSuperComposite.setLayoutData((Object)new GridData(768));
            gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            AddUnimplementedConstructorsDialog.applyDialogFont((Control)composite);
            return composite;
        }
    }

    private static class AddUnimplementedConstructorsValidator
    implements ISelectionStatusValidator {
        private static int fEntries;

        AddUnimplementedConstructorsValidator(int entries) {
            fEntries = entries;
        }

        public IStatus validate(Object[] selection) {
            int count = this.countSelectedMethods(selection);
            if (count == 0) {
                return new StatusInfo(4, "");
            }
            String message = ActionMessages.getFormattedString("AddUnimplementedConstructorsAction.methods_selected", new Object[]{String.valueOf(count), String.valueOf(fEntries)});
            return new StatusInfo(1, message);
        }

        private int countSelectedMethods(Object[] selection) {
            int count = 0;
            for (int i = 0; i < selection.length; ++i) {
                if (!(selection[i] instanceof IMethod)) continue;
                ++count;
            }
            return count;
        }
    }

    private static class AddUnimplementedConstructorsContentProvider
    implements ITreeContentProvider {
        private IMethod[] fMethodsList;
        private static final Object[] EMPTY = new Object[0];

        public AddUnimplementedConstructorsContentProvider(IMethod[] methodList) {
            this.fMethodsList = methodList;
        }

        public Object[] getChildren(Object parentElement) {
            return EMPTY;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.fMethodsList;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

