/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class DeletePackageFragmentRootChange
extends AbstractDeleteChange {
    private final String fHandle;
    private final IPackageFragmentRootManipulationQuery fUpdateClasspathQuery;

    public DeletePackageFragmentRootChange(IPackageFragmentRoot root, IPackageFragmentRootManipulationQuery updateClasspathQuery) {
        Assert.isNotNull(root);
        Assert.isTrue(!root.isExternal());
        this.fHandle = root.getHandleIdentifier();
        this.fUpdateClasspathQuery = updateClasspathQuery;
    }

    public String getName() {
        String[] keys = new String[]{this.getRoot().getElementName()};
        return RefactoringCoreMessages.getFormattedString("DeletePackageFragmentRootChange.delete", keys);
    }

    public Object getModifiedElement() {
        return this.getRoot();
    }

    private IPackageFragmentRoot getRoot() {
        return (IPackageFragmentRoot)JavaCore.create((String)this.fHandle);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return super.isValid(pm, false, true);
    }

    protected void doDelete(IProgressMonitor pm) throws CoreException {
        if (!this.confirmDeleteIfReferenced()) {
            return;
        }
        int resourceUpdateFlags = 2;
        int jCoreUpdateFlags = 6;
        this.getRoot().delete(resourceUpdateFlags, jCoreUpdateFlags, pm);
    }

    private boolean confirmDeleteIfReferenced() throws JavaModelException {
        if (!this.getRoot().isArchive()) {
            return true;
        }
        if (this.fUpdateClasspathQuery == null) {
            return true;
        }
        IJavaProject[] referencingProjects = JavaElementUtil.getReferencingProjects(this.getRoot());
        if (referencingProjects.length == 0) {
            return true;
        }
        return this.fUpdateClasspathQuery.confirmManipulation(this.getRoot(), referencingProjects);
    }
}

