/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.DependencyExtentSearchResultCollector;
import org.eclipse.pde.internal.ui.search.PluginJavaSearchUtil;

public class DependencyExtentSearchOperation
implements IWorkspaceRunnable,
IRunnableWithProgress {
    private static final String KEY_DEPENDENCY = "DependencyExtent.singular";
    private static final String KEY_DEPENDENCIES = "DependencyExtent.plural";
    private static final String KEY_SEARCHING = "DependencyExtent.searching";
    IPluginImport object;
    IProject parentProject;
    IPluginBase[] models = new IPluginBase[0];
    IPackageFragment[] packageFragments = new IPackageFragment[0];
    DependencyExtentSearchResultCollector resultCollector;

    public DependencyExtentSearchOperation(IPluginImport object) {
        this.object = object;
        this.parentProject = object.getModel().getUnderlyingResource().getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) {
        this.resultCollector = new DependencyExtentSearchResultCollector(this, monitor);
        try {
            HashSet set = new HashSet();
            PluginJavaSearchUtil.collectAllPrerequisites(PDECore.getDefault().findPlugin(this.object.getId()), set);
            this.models = set.toArray(new IPluginBase[set.size()]);
            if (this.parentProject.hasNature("org.eclipse.jdt.core.javanature")) {
                this.packageFragments = PluginJavaSearchUtil.collectPackageFragments(this.models, this.parentProject);
            }
            monitor.setTaskName(PDEPlugin.getResourceString(KEY_SEARCHING));
            monitor.beginTask("", this.packageFragments.length + 1);
            this.resultCollector.searchStarted();
            this.findExtensionPoints(monitor);
            if (this.packageFragments.length > 0) {
                this.doJavaSearch(monitor);
            }
        }
        catch (CoreException e) {
            PDEPlugin.log(e.getStatus());
        }
        finally {
            this.resultCollector.done();
        }
    }

    private void findExtensionPoints(IProgressMonitor monitor) {
        HashSet<String> ids = new HashSet<String>();
        IPluginExtension[] extensions = this.object.getPluginBase().getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            IPluginExtensionPoint point;
            if (!ids.add(extensions[i].getPoint()) || (point = this.getExtensionPoint(extensions[i].getPoint())) == null) continue;
            this.resultCollector.accept(point);
        }
        monitor.worked(1);
    }

    private IPluginExtensionPoint getExtensionPoint(String targetId) {
        for (int i = 0; i < this.models.length; ++i) {
            IPluginExtensionPoint[] extPoints = this.models[i].getExtensionPoints();
            for (int j = 0; j < extPoints.length; ++j) {
                if (!extPoints[j].getFullId().equals(targetId)) continue;
                return extPoints[j];
            }
        }
        return null;
    }

    private void doJavaSearch(IProgressMonitor monitor) throws JavaModelException {
        SearchEngine searchEngine = new SearchEngine();
        IJavaSearchScope scope = this.getSearchScope();
        for (int i = 0; i < this.packageFragments.length; ++i) {
            IPackageFragment packageFragment = this.packageFragments[i];
            if (!packageFragment.hasSubpackages()) {
                SearchResultCollector collector = new SearchResultCollector(monitor);
                searchEngine.search(PDEPlugin.getWorkspace(), SearchEngine.createSearchPattern((String)(packageFragment.getElementName() + ".*"), (int)0, (int)2, (boolean)true), scope, (IJavaSearchResultCollector)collector);
                IJavaElement[] enclosingElements = collector.getResult();
                if (enclosingElements.length > 0) {
                    this.searchForTypes(packageFragment, searchEngine, SearchEngine.createJavaSearchScope((IJavaElement[])enclosingElements), monitor);
                }
            } else {
                this.searchForTypes(packageFragment, searchEngine, scope, monitor);
            }
            monitor.worked(1);
        }
    }

    private void searchForTypes(IPackageFragment fragment, SearchEngine searchEngine, IJavaSearchScope scope, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] children = fragment.getChildren();
        for (int i = 0; i < children.length; ++i) {
            IJavaElement child = children[i];
            IType[] types = new IType[]{};
            if (child instanceof IClassFile) {
                types = new IType[]{((IClassFile)child).getType()};
            } else if (child instanceof ICompilationUnit) {
                types = ((ICompilationUnit)child).getAllTypes();
            }
            for (int j = 0; j < types.length; ++j) {
                SearchResultCollector collector = new SearchResultCollector(monitor);
                searchEngine.search(PDEPlugin.getWorkspace(), SearchEngine.createSearchPattern((IJavaElement)types[j], (int)2), scope, (IJavaSearchResultCollector)collector);
                if (collector.getResult().length <= 0) continue;
                this.resultCollector.accept(types[j]);
            }
        }
    }

    private IJavaSearchScope getSearchScope() throws JavaModelException {
        IPackageFragmentRoot[] roots = JavaCore.create((IProject)this.parentProject).getPackageFragmentRoots();
        ArrayList<IPackageFragmentRoot> filteredRoots = new ArrayList<IPackageFragmentRoot>();
        for (int i = 0; i < roots.length; ++i) {
            if (roots[i].getResource() == null || !roots[i].getResource().getProject().equals(this.parentProject)) continue;
            filteredRoots.add(roots[i]);
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])filteredRoots.toArray(new IJavaElement[filteredRoots.size()]));
    }

    public String getPluralLabel() {
        return this.object.getId() + " - {0} " + PDEPlugin.getResourceString(KEY_DEPENDENCIES);
    }

    public String getSingularLabel() {
        return this.object.getId() + " - 1 " + PDEPlugin.getResourceString(KEY_DEPENDENCY);
    }

    public IProject getProject() {
        return this.parentProject;
    }

    class SearchResultCollector
    implements IJavaSearchResultCollector {
        protected IProgressMonitor monitor;
        HashSet result = new HashSet();

        public SearchResultCollector(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) throws CoreException {
            if (accuracy == 0) {
                this.result.add(enclosingElement.getAncestor(4));
            }
        }

        public void aboutToStart() {
        }

        public void done() {
        }

        public IProgressMonitor getProgressMonitor() {
            return this.monitor;
        }

        public IJavaElement[] getResult() {
            return this.result.toArray(new IJavaElement[this.result.size()]);
        }
    }
}

