/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.isite.ISiteObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.site.BaseNewDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FeaturePropertiesDialog
extends BaseNewDialog {
    private Text fURLText;
    private Text fIdText;
    private Text fVersionText;
    private Text fLabelText;
    private Text fTypeText;
    private Text fOSText;
    private Text fWSText;
    private Text fNLText;
    private Text fArchText;
    private Button fIsPatch;

    public FeaturePropertiesDialog(Shell shell, ISiteModel siteModel, ISiteFeature siteObject) {
        super(shell, siteModel, (ISiteObject)siteObject);
    }

    protected String getDialogTitle() {
        return PDEPlugin.getResourceString("FeaturePropertiesDialog.title");
    }

    protected String getHelpId() {
        return null;
    }

    protected void createEntries(Composite container) {
        ISiteFeature feature = (ISiteFeature)this.getSiteObject();
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("FeaturePropertiesDialog.url"));
        this.fURLText = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        this.fURLText.setLayoutData((Object)gd);
        this.setIfDefined(this.fURLText, feature.getURL());
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("FeaturePropertiesDialog.id"));
        this.fIdText = new Text(container, 2052);
        this.fIdText.setLayoutData((Object)new GridData(768));
        this.fIdText.setEnabled(false);
        this.setIfDefined(this.fIdText, feature.getId());
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("FeaturePropertiesDialog.version"));
        this.fVersionText = new Text(container, 2052);
        this.fVersionText.setLayoutData((Object)new GridData(768));
        this.fVersionText.setEnabled(false);
        this.setIfDefined(this.fVersionText, feature.getVersion());
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("FeaturePropertiesDialog.label"));
        this.fLabelText = new Text(container, 2052);
        this.fLabelText.setLayoutData((Object)new GridData(768));
        this.setIfDefined(this.fLabelText, feature.getLabel());
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("FeaturePropertiesDialog.type"));
        this.fTypeText = new Text(container, 2052);
        this.fTypeText.setLayoutData((Object)new GridData(768));
        this.setIfDefined(this.fTypeText, feature.getType());
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("FeaturePropertiesDialog.os"));
        this.fOSText = new Text(container, 2052);
        this.fOSText.setLayoutData((Object)new GridData(768));
        this.setIfDefined(this.fOSText, feature.getOS());
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("FeaturePropertiesDialog.ws"));
        this.fWSText = new Text(container, 2052);
        this.fWSText.setLayoutData((Object)new GridData(768));
        this.setIfDefined(this.fWSText, feature.getWS());
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("FeaturePropertiesDialog.nl"));
        this.fNLText = new Text(container, 2052);
        this.fNLText.setLayoutData((Object)new GridData(768));
        this.setIfDefined(this.fNLText, feature.getNL());
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("FeaturePropertiesDialog.arch"));
        this.fArchText = new Text(container, 2052);
        this.fArchText.setLayoutData((Object)new GridData(768));
        this.setIfDefined(this.fArchText, feature.getArch());
        this.fIsPatch = new Button(container, 32);
        this.fIsPatch.setText(PDEPlugin.getResourceString("FeaturePropertiesDialog.patch"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fIsPatch.setLayoutData((Object)gd);
        this.fIsPatch.setSelection(feature.isPatch());
    }

    protected void hookListeners(ModifyListener listener) {
        this.fURLText.addModifyListener(listener);
    }

    protected void dialogChanged() {
        IStatus status = this.fURLText.getText().trim().length() == 0 ? this.createErrorStatus(this.getEmptyErrorMessage()) : this.getOKStatus();
        this.updateStatus(status);
    }

    protected String getEmptyErrorMessage() {
        return PDEPlugin.getResourceString("FeaturePropertiesDialog.requiredURL");
    }

    protected void execute() {
        try {
            ISiteFeature feature = (ISiteFeature)this.getSiteObject();
            feature.setIsPatch(this.fIsPatch.getSelection());
            feature.setURL(this.fURLText.getText().trim());
            String text = this.fLabelText.getText().trim();
            feature.setLabel(text.length() == 0 ? null : text);
            text = this.fTypeText.getText().trim();
            feature.setType(text.length() == 0 ? null : text);
            text = this.fOSText.getText().trim();
            feature.setOS(text.length() == 0 ? null : text);
            text = this.fWSText.getText().trim();
            feature.setWS(text.length() == 0 ? null : text);
            text = this.fNLText.getText().trim();
            feature.setNL(text.length() == 0 ? null : text);
            text = this.fArchText.getText().trim();
            feature.setArch(text.length() == 0 ? null : text);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }
}

