/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.internal.dependencies.Dependency;
import org.eclipse.core.internal.dependencies.Element;
import org.eclipse.core.internal.dependencies.ElementSet;
import org.eclipse.core.internal.dependencies.IElementSetVisitor;

public class ResolutionVisitor
implements IElementSetVisitor {
    private int order;

    public ResolutionVisitor(int order) {
        this.order = order;
    }

    public Collection getAncestors(ElementSet elementSet) {
        return elementSet.getRequired();
    }

    public Collection getDescendants(ElementSet elementSet) {
        return elementSet.getRequiring();
    }

    public int getOrder() {
        return this.order;
    }

    public void update(ElementSet elementSet) {
        if (elementSet.getRequired().isEmpty()) {
            elementSet.setResolved(elementSet.getSelected());
            return;
        }
        HashSet<Element> resolved = new HashSet<Element>();
        Iterator elementsIter = elementSet.getSelected().iterator();
        while (elementsIter.hasNext()) {
            Element element = (Element)elementsIter.next();
            Dependency[] dependencies = element.getDependencies();
            boolean versionResolved = true;
            for (int i = 0; i < dependencies.length; ++i) {
                ElementSet requiredNode = elementSet.getSystem().getElementSet(dependencies[i].getRequiredObjectId());
                ArrayList requiredNodeResolvedVersions = new ArrayList(requiredNode.getResolved());
                Object highestRequiredVersionId = null;
                Iterator requiredNodeResolvedVersionsIter = requiredNodeResolvedVersions.iterator();
                while (requiredNodeResolvedVersionsIter.hasNext()) {
                    Element requiredResolvedVersion = (Element)requiredNodeResolvedVersionsIter.next();
                    if (!dependencies[i].getMatchRule().isSatisfied(dependencies[i].getUserObject(), requiredResolvedVersion.getVersionId()) || highestRequiredVersionId != null && elementSet.getSystem().compare(requiredResolvedVersion.getVersionId(), highestRequiredVersionId) <= 0) continue;
                    highestRequiredVersionId = requiredResolvedVersion.getVersionId();
                }
                if (highestRequiredVersionId == null && !dependencies[i].isOptional()) {
                    versionResolved = false;
                    break;
                }
                elementSet.resolveDependency(dependencies[i], highestRequiredVersionId);
            }
            if (!versionResolved) continue;
            resolved.add(element);
        }
        elementSet.setResolved(resolved);
    }
}

