/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.codemanipulation.AddDelegateMethodsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;

public class AddDelegateMethodsAction
extends SelectionDispatchAction {
    private static final String DIALOG_TITLE = ActionMessages.getString("AddDelegateMethodsAction.error.title");
    private CompilationUnitEditor fEditor;
    static /* synthetic */ Class class$org$eclipse$jface$text$IRewriteTarget;

    public AddDelegateMethodsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("AddDelegateMethodsAction.label"));
        this.setDescription(ActionMessages.getString("AddDelegateMethodsAction.description"));
        this.setToolTipText(ActionMessages.getString("AddDelegateMethodsAction.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.add_delegate_methods_action");
    }

    public AddDelegateMethodsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(editor) != null);
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (this.getSelectedFields(selection) != null) {
            return true;
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type = (IType)selection.getFirstElement();
            return type.getCompilationUnit() != null && type.isClass() && !type.isLocal();
        }
        return selection.size() == 1 && selection.getFirstElement() instanceof ICompilationUnit;
    }

    public void run(IStructuredSelection selection) {
        try {
            IField[] selectedFields = this.getSelectedFields(selection);
            if (AddDelegateMethodsAction.canRunOn(selectedFields)) {
                this.run(selectedFields[0].getDeclaringType(), selectedFields, false);
                return;
            }
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IType) {
                this.run((IType)firstElement, new IField[0], false);
            } else if (firstElement instanceof ICompilationUnit) {
                this.run(JavaElementUtil.getMainType((ICompilationUnit)firstElement), new IField[0], false);
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.getString("AddDelegateMethodsAction.not_applicable"));
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, ActionMessages.getString("AddDelegateMethodsAction.error.actionfailed"));
        }
    }

    private static boolean canRunOn(IType type) throws JavaModelException {
        if (type == null || type.getCompilationUnit() == null || type.isInterface()) {
            return false;
        }
        return AddDelegateMethodsAction.canRunOn(type.getFields());
    }

    private static boolean canRunOn(IField[] fields) throws JavaModelException {
        if (fields == null) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < fields.length; ++i) {
            if (AddDelegateMethodsAction.hasPrimitiveType(fields[i]) && !AddDelegateMethodsAction.isArray(fields[i])) continue;
            ++count;
        }
        return count > 0;
    }

    private IField[] getSelectedFields(IStructuredSelection selection) {
        List elements = selection.toList();
        int nElements = elements.size();
        if (nElements > 0) {
            IField[] res = new IField[nElements];
            ICompilationUnit cu = null;
            for (int i = 0; i < nElements; ++i) {
                IField fld;
                block7: {
                    Object curr = elements.get(i);
                    if (curr instanceof IField) {
                        fld = (IField)curr;
                        if (i == 0 ? (cu = fld.getCompilationUnit()) == null : !cu.equals(fld.getCompilationUnit())) {
                            return null;
                        }
                        try {
                            if (fld.getDeclaringType().isInterface()) {
                                return null;
                            }
                            break block7;
                        }
                        catch (JavaModelException e) {
                            JavaPlugin.log(e);
                            return null;
                        }
                    }
                    return null;
                }
                res[i] = fld;
            }
            return res;
        }
        return null;
    }

    private void run(IType type, IField[] preselected, boolean editor) throws CoreException {
        if (!ElementValidator.check((IJavaElement)type, this.getShell(), DIALOG_TITLE, editor)) {
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), type)) {
            return;
        }
        if (!AddDelegateMethodsAction.canRunOn(type)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.getString("AddDelegateMethodsAction.not_applicable"));
            return;
        }
        this.showUI(type, preselected);
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void run(ITextSelection selection) {
        try {
            IType type;
            if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
                return;
            }
            IJavaElement[] elements = SelectionConverter.codeResolve(this.fEditor);
            if (elements.length == 1 && elements[0] instanceof IField) {
                IField field = (IField)elements[0];
                this.run(field.getDeclaringType(), new IField[]{field}, true);
                return;
            }
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null && (type = (IType)element.getAncestor(7)) != null && type.getFields().length > 0) {
                this.run(type, new IField[0], true);
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)DIALOG_TITLE, (String)ActionMessages.getString("AddDelegateMethodsAction.not_applicable"));
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), DIALOG_TITLE, ActionMessages.getString("AddDelegateMethodsAction.error.actionfailed"));
        }
    }

    private static ISelectionStatusValidator createValidator(int entries) {
        AddDelegateMethodsActionStatusValidator validator = new AddDelegateMethodsActionStatusValidator(entries);
        return validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showUI(IType type, IField[] preselected) {
        block12: {
            try {
                AddDelegateMethodsContentProvider provider = new AddDelegateMethodsContentProvider(type);
                Methods2FieldLabelProvider methodLabel = new Methods2FieldLabelProvider();
                SourceActionDialog dialog = new SourceActionDialog(this.getShell(), methodLabel, provider, this.fEditor, type, false);
                dialog.setValidator(AddDelegateMethodsAction.createValidator(provider.getNumEntries()));
                Methods2FieldSorter sorter = new Methods2FieldSorter();
                dialog.setSorter(sorter);
                dialog.setInput(new Object());
                dialog.setContainerMode(true);
                dialog.setMessage(ActionMessages.getString("AddDelegateMethodsAction.message"));
                dialog.setTitle(ActionMessages.getString("AddDelegateMethodsAction.title"));
                Object[] elements = provider.getElements(null);
                if (elements.length > 0) {
                    sorter.sort(null, elements);
                    Object[] expand = new Object[]{elements[0]};
                    dialog.setExpandedElements(expand);
                }
                dialog.setInitialSelections(preselected);
                dialog.setSize(60, 18);
                int result = dialog.open();
                if (result != 0) break block12;
                Object[] o = dialog.getResult();
                if (o == null) {
                    return;
                }
                ArrayList<Object> methods = new ArrayList<Object>(o.length);
                for (int i = 0; i < o.length; ++i) {
                    if (!(o[i] instanceof AddDelegateMethodsOperation.Methods2Field)) continue;
                    methods.add(o[i]);
                }
                IEditorPart part = EditorUtility.openInEditor(type);
                IRewriteTarget target = (IRewriteTarget)part.getAdapter(class$org$eclipse$jface$text$IRewriteTarget == null ? (class$org$eclipse$jface$text$IRewriteTarget = AddDelegateMethodsAction.class$("org.eclipse.jface.text.IRewriteTarget")) : class$org$eclipse$jface$text$IRewriteTarget);
                IMethod[] createdMethods = null;
                try {
                    if (target != null) {
                        target.beginCompoundChange();
                    }
                    IJavaElement elementPosition = dialog.getElementPosition();
                    CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
                    settings.createComments = dialog.getGenerateComment();
                    createdMethods = this.processResults(methods, type, elementPosition, settings);
                }
                finally {
                    if (target != null) {
                        target.endCompoundChange();
                    }
                }
                if (createdMethods != null && createdMethods.length > 0) {
                    JavaModelUtil.reconcile(type.getCompilationUnit());
                    EditorUtility.revealInEditor(part, (IJavaElement)createdMethods[0]);
                }
            }
            catch (CoreException e) {
                ExceptionHandler.handle(e, DIALOG_TITLE, ActionMessages.getString("AddDelegateMethodsAction.error.actionfailed"));
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, DIALOG_TITLE, ActionMessages.getString("AddDelegateMethodsAction.error.actionfailed"));
            }
        }
    }

    private IMethod[] processResults(List list, IType type, IJavaElement elementPosition, CodeGenerationSettings settings) throws InvocationTargetException {
        if (list.size() == 0) {
            return null;
        }
        AddDelegateMethodsOperation op = new AddDelegateMethodsOperation(list, settings, type, elementPosition);
        Object context = JavaPlugin.getActiveWorkbenchWindow();
        if (context == null) {
            context = new BusyIndicatorRunnableContext();
        }
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
        }
        catch (InterruptedException e) {
            return null;
        }
        return op.getCreatedMethods();
    }

    private static IMethod[] resolveMethodsHierarchy(IType type) throws JavaModelException {
        HashMap map = new HashMap();
        IType[] superTypes = JavaModelUtil.getAllSuperTypes(type, (IProgressMonitor)new NullProgressMonitor());
        AddDelegateMethodsAction.addMethodsToMapping(map, type);
        for (int i = 0; i < superTypes.length; ++i) {
            AddDelegateMethodsAction.addMethodsToMapping(map, superTypes[i]);
        }
        return map.values().toArray(new IMethod[map.values().size()]);
    }

    private static void addMethodsToMapping(Map map, IType type) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            map.put(AddDelegateMethodsAction.createSignatureKey(methods[i]), methods[i]);
        }
    }

    private static IMethod[] resolveFinalMethods(IType type) throws JavaModelException {
        if (type.isInterface()) {
            type = AddDelegateMethodsAction.getJavaLangObject(type.getJavaProject());
        }
        IMethod[] methods = AddDelegateMethodsAction.resolveMethodsHierarchy(type);
        ArrayList<IMethod> list = new ArrayList<IMethod>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            boolean isFinal = Flags.isFinal((int)methods[i].getFlags());
            if (!isFinal) continue;
            list.add(methods[i]);
        }
        return list.toArray(new IMethod[list.size()]);
    }

    private static String createSignatureKey(IMethod method) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(method.getElementName());
        String[] args = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            String signature;
            if (AddDelegateMethodsAction.isUnresolved(args[i])) {
                int acount = Signature.getArrayCount((String)args[i]);
                if (acount > 0) {
                    String arg = args[i];
                    int index = arg.lastIndexOf(91);
                    arg = arg.substring(index + 1);
                    signature = Signature.toString((String)arg);
                } else {
                    signature = Signature.toString((String)args[i]);
                }
                String[][] fqn = method.getDeclaringType().resolveType(signature);
                if (fqn == null) continue;
                buffer.append(fqn[0][0]).append('.').append(fqn[0][1]);
                for (int j = 0; j < acount; ++j) {
                    buffer.append("[]");
                }
                continue;
            }
            signature = Signature.toString((String)args[i]);
            buffer.append(signature);
        }
        return buffer.toString();
    }

    private static boolean isUnresolved(String signature) {
        boolean primitive;
        boolean flag = false;
        char c = Signature.getElementType((String)signature).charAt(0);
        boolean bl = primitive = c != 'L' && c != 'Q';
        if (primitive) {
            return flag;
        }
        int acount = Signature.getArrayCount((String)signature);
        if (acount > 0) {
            int index = signature.lastIndexOf(91);
            c = signature.charAt(index + 1);
        } else {
            c = signature.charAt(0);
        }
        switch (c) {
            case 'L': {
                flag = false;
                break;
            }
            case 'Q': {
                flag = true;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return flag;
    }

    private static boolean hasPrimitiveType(IField field) throws JavaModelException {
        String signature = field.getTypeSignature();
        char first = Signature.getElementType((String)signature).charAt(0);
        return first != 'L' && first != 'Q';
    }

    private static IType resolveTypeOfField(IField field) throws JavaModelException {
        boolean isPrimitive = AddDelegateMethodsAction.hasPrimitiveType(field);
        boolean isArray = AddDelegateMethodsAction.isArray(field);
        if (!isPrimitive && !isArray) {
            String typeName = JavaModelUtil.getResolvedTypeName(field.getTypeSignature(), field.getDeclaringType());
            return typeName != null ? field.getJavaProject().findType(typeName) : null;
        }
        if (isArray) {
            return AddDelegateMethodsAction.getJavaLangObject(field.getJavaProject());
        }
        return null;
    }

    private static IType getJavaLangObject(IJavaProject project) throws JavaModelException {
        return JavaModelUtil.findType(project, "java.lang.Object");
    }

    private static boolean isArray(IField field) throws JavaModelException {
        return Signature.getArrayCount((String)field.getTypeSignature()) > 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Methods2FieldSorter
    extends ViewerSorter {
        JavaElementSorter fSorter = new JavaElementSorter();

        private Methods2FieldSorter() {
        }

        public int category(Object element) {
            if (element instanceof AddDelegateMethodsOperation.Methods2Field) {
                element = ((AddDelegateMethodsOperation.Methods2Field)element).method;
            }
            return this.fSorter.category(element);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof AddDelegateMethodsOperation.Methods2Field) {
                e1 = ((AddDelegateMethodsOperation.Methods2Field)e1).method;
            }
            if (e2 instanceof AddDelegateMethodsOperation.Methods2Field) {
                e2 = ((AddDelegateMethodsOperation.Methods2Field)e2).method;
            }
            return this.fSorter.compare(viewer, e1, e2);
        }

        public Collator getCollator() {
            return this.fSorter.getCollator();
        }
    }

    private static class Methods2FieldLabelProvider
    implements ILabelProvider {
        JavaElementLabelProvider fMethodLabel = new JavaElementLabelProvider();

        public Methods2FieldLabelProvider() {
            this.fMethodLabel.turnOn(32);
        }

        public Image getImage(Object element) {
            if (element instanceof AddDelegateMethodsOperation.Methods2Field) {
                AddDelegateMethodsOperation.Methods2Field wrapper = (AddDelegateMethodsOperation.Methods2Field)element;
                return this.fMethodLabel.getImage(wrapper.method);
            }
            if (element instanceof IJavaElement) {
                return this.fMethodLabel.getImage(element);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof AddDelegateMethodsOperation.Methods2Field) {
                AddDelegateMethodsOperation.Methods2Field wrapper = (AddDelegateMethodsOperation.Methods2Field)element;
                return this.fMethodLabel.getText(wrapper.method);
            }
            if (element instanceof IJavaElement) {
                return this.fMethodLabel.getText(element);
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
            this.fMethodLabel.addListener(listener);
        }

        public void dispose() {
            this.fMethodLabel.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.fMethodLabel.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.fMethodLabel.removeListener(listener);
        }
    }

    private static class AddDelegateMethodsContentProvider
    implements ITreeContentProvider {
        private Map fTreeMap = null;
        private Map fFieldMap = null;
        private Map fFilter = new HashMap();
        private int fNumEntries;

        AddDelegateMethodsContentProvider(IType type) throws JavaModelException {
            this.fTreeMap = new TreeMap();
            this.fFieldMap = new HashMap();
            this.fNumEntries = this.buildModel(type);
        }

        public int getNumEntries() {
            return this.fNumEntries;
        }

        private int buildModel(IType type) throws JavaModelException {
            int i;
            int numEntries = 0;
            IField[] fields = type.getFields();
            IMethod[] finMeths = AddDelegateMethodsAction.resolveFinalMethods(type);
            for (int i2 = 0; i2 < finMeths.length; ++i2) {
                this.fFilter.put(AddDelegateMethodsAction.createSignatureKey(finMeths[i2]), finMeths[i2]);
            }
            IMethod[] filter = type.getMethods();
            for (i = 0; i < filter.length; ++i) {
                this.fFilter.put(AddDelegateMethodsAction.createSignatureKey(filter[i]), filter[i]);
            }
            for (i = 0; i < fields.length; ++i) {
                IType fieldType = AddDelegateMethodsAction.resolveTypeOfField(fields[i]);
                if (fieldType == null) continue;
                IMethod[] methods = AddDelegateMethodsAction.resolveMethodsHierarchy(fieldType);
                ArrayList<AddDelegateMethodsOperation.Methods2Field> accessMethods = new ArrayList<AddDelegateMethodsOperation.Methods2Field>();
                for (int j = 0; j < methods.length; ++j) {
                    boolean finalExist;
                    boolean publicField = JavaModelUtil.isVisible((IMember)methods[j], type.getPackageFragment());
                    boolean constructor = methods[j].isConstructor();
                    boolean bl = finalExist = this.fFilter.get(AddDelegateMethodsAction.createSignatureKey(methods[j])) != null;
                    if (!publicField || constructor || finalExist) continue;
                    accessMethods.add(new AddDelegateMethodsOperation.Methods2Field(methods[j], fields[i]));
                    ++numEntries;
                }
                Object[] m = accessMethods.toArray();
                AddDelegateMethodsOperation.Methods2Field[] mf = new AddDelegateMethodsOperation.Methods2Field[m.length];
                for (int j = 0; j < m.length; ++j) {
                    mf[j] = (AddDelegateMethodsOperation.Methods2Field)m[j];
                }
                this.fTreeMap.put(fields[i].getElementName(), mf);
                this.fFieldMap.put(fields[i].getElementName(), fields[i]);
            }
            return numEntries;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IField) {
                return (Object[])this.fTreeMap.get(((IField)parentElement).getElementName());
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IField;
        }

        public Object[] getElements(Object inputElement) {
            Object[] o = this.fTreeMap.keySet().toArray();
            Object[] fields = new Object[o.length];
            for (int i = 0; i < o.length; ++i) {
                fields[i] = this.fFieldMap.get(o[i]);
            }
            return fields;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class AddDelegateMethodsActionStatusValidator
    implements ISelectionStatusValidator {
        private static int fEntries;

        AddDelegateMethodsActionStatusValidator(int entries) {
            fEntries = entries;
        }

        public IStatus validate(Object[] selection) {
            StatusInfo state = new StatusInfo();
            if (selection != null && selection.length > 0) {
                HashSet<Object> map = new HashSet<Object>(selection.length);
                int count = 0;
                for (int i = 0; i < selection.length; ++i) {
                    Object key = selection[i];
                    if (selection[i] instanceof AddDelegateMethodsOperation.Methods2Field) {
                        ++count;
                        try {
                            key = AddDelegateMethodsAction.createSignatureKey(((AddDelegateMethodsOperation.Methods2Field)selection[i]).method);
                        }
                        catch (JavaModelException e) {
                            return new StatusInfo(4, e.toString());
                        }
                    }
                    if (!map.add(key)) {
                        state = new StatusInfo(4, ActionMessages.getString("AddDelegateMethodsAction.duplicate_methods"));
                        break;
                    }
                    String message = ActionMessages.getFormattedString("AddDelegateMethodsAction.selectioninfo.more", new Object[]{String.valueOf(count), String.valueOf(fEntries)});
                    state = new StatusInfo(1, message);
                }
            } else {
                return new StatusInfo(4, "");
            }
            return state;
        }
    }
}

