/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui;

import java.text.Collator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JavaElementSorter
extends ViewerSorter {
    private static final int PROJECTS = 1;
    private static final int PACKAGEFRAGMENTROOTS = 2;
    private static final int PACKAGEFRAGMENT = 3;
    private static final int COMPILATIONUNITS = 4;
    private static final int CLASSFILES = 5;
    private static final int RESOURCEFOLDERS = 7;
    private static final int RESOURCES = 8;
    private static final int STORAGE = 9;
    private static final int PACKAGE_DECL = 10;
    private static final int IMPORT_CONTAINER = 11;
    private static final int IMPORT_DECLARATION = 12;
    private static final int MEMBERSOFFSET = 15;
    private static final int JAVAELEMENTS = 50;
    private static final int OTHERS = 51;
    private MembersOrderPreferenceCache fMemberOrderCache = JavaPlugin.getDefault().getMemberOrderPreferenceCache();
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public JavaElementSorter() {
        super(null);
    }

    public boolean isSorterProperty(Object element, Object property) {
        return true;
    }

    public int category(Object element) {
        if (element instanceof IJavaElement) {
            block27: {
                try {
                    IJavaElement je = (IJavaElement)element;
                    switch (je.getElementType()) {
                        case 9: {
                            IMethod method = (IMethod)je;
                            if (method.isConstructor()) {
                                return this.getMemberCategory(1);
                            }
                            int flags = method.getFlags();
                            if (Flags.isStatic((int)flags)) {
                                return this.getMemberCategory(7);
                            }
                            return this.getMemberCategory(2);
                        }
                        case 8: {
                            int flags = ((IField)je).getFlags();
                            if (Flags.isStatic((int)flags)) {
                                return this.getMemberCategory(5);
                            }
                            return this.getMemberCategory(3);
                        }
                        case 10: {
                            int flags = ((IInitializer)je).getFlags();
                            if (Flags.isStatic((int)flags)) {
                                return this.getMemberCategory(6);
                            }
                            return this.getMemberCategory(4);
                        }
                        case 7: {
                            return this.getMemberCategory(0);
                        }
                        case 11: {
                            return 10;
                        }
                        case 12: {
                            return 11;
                        }
                        case 13: {
                            return 12;
                        }
                        case 4: {
                            IPackageFragment pack = (IPackageFragment)je;
                            if (pack.getParent().getResource() instanceof IProject) {
                                return 2;
                            }
                            return 3;
                        }
                        case 3: {
                            return 2;
                        }
                        case 2: {
                            return 1;
                        }
                        case 6: {
                            return 5;
                        }
                        case 5: {
                            return 4;
                        }
                    }
                }
                catch (JavaModelException e) {
                    if (e.isDoesNotExist()) break block27;
                    JavaPlugin.log(e);
                }
            }
            return 50;
        }
        if (element instanceof IFile) {
            return 8;
        }
        if (element instanceof IProject) {
            return 1;
        }
        if (element instanceof IContainer) {
            return 7;
        }
        if (element instanceof IStorage) {
            return 9;
        }
        if (element instanceof ClassPathContainer) {
            return 2;
        }
        return 51;
    }

    private int getMemberCategory(int kind) {
        int offset = this.fMemberOrderCache.getCategoryIndex(kind);
        return offset + 15;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cmp;
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (cat1 == 1) {
            IWorkbenchAdapter a1 = (IWorkbenchAdapter)((IAdaptable)e1).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = JavaElementSorter.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
            IWorkbenchAdapter a2 = (IWorkbenchAdapter)((IAdaptable)e2).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = JavaElementSorter.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
            return this.getCollator().compare(a1.getLabel(e1), a2.getLabel(e2));
        }
        if (cat1 == 2) {
            int p2;
            int p1;
            IPackageFragmentRoot root1 = this.getPackageFragmentRoot(e1);
            IPackageFragmentRoot root2 = this.getPackageFragmentRoot(e2);
            if (root1 == null) {
                if (root2 == null) {
                    return 0;
                }
                return 1;
            }
            if (root2 == null) {
                return -1;
            }
            if (!root1.getPath().equals(root2.getPath()) && (p1 = this.getClassPathIndex(root1)) != (p2 = this.getClassPathIndex(root2))) {
                return p1 - p2;
            }
            e1 = root1;
            e2 = root2;
        }
        if (cat1 == 1 || cat1 == 8 || cat1 == 7 || cat1 == 9 || cat1 == 51) {
            return this.compareWithLabelProvider(viewer, e1, e2);
        }
        if (e1 instanceof IMember && this.fMemberOrderCache.isSortByVisibility()) {
            try {
                int flags1 = JdtFlags.getVisibilityCode((IMember)e1);
                int flags2 = JdtFlags.getVisibilityCode((IMember)e2);
                int vis = this.fMemberOrderCache.getVisibilityIndex(flags1) - this.fMemberOrderCache.getVisibilityIndex(flags2);
                if (vis != 0) {
                    return vis;
                }
            }
            catch (JavaModelException ignore) {
                // empty catch block
            }
        }
        String name1 = ((IJavaElement)e1).getElementName();
        String name2 = ((IJavaElement)e2).getElementName();
        if (e1 instanceof IType) {
            if (name1.length() == 0) {
                if (name2.length() == 0) {
                    try {
                        return this.getCollator().compare(((IType)e1).getSuperclassName(), ((IType)e2).getSuperclassName());
                    }
                    catch (JavaModelException e) {
                        return 0;
                    }
                }
                return 1;
            }
            if (name2.length() == 0) {
                return -1;
            }
        }
        if ((cmp = this.getCollator().compare(name1, name2)) != 0) {
            return cmp;
        }
        if (e1 instanceof IMethod) {
            String[] params1 = ((IMethod)e1).getParameterTypes();
            String[] params2 = ((IMethod)e2).getParameterTypes();
            int len = Math.min(params1.length, params2.length);
            for (int i = 0; i < len; ++i) {
                cmp = this.getCollator().compare(Signature.toString((String)params1[i]), Signature.toString((String)params2[i]));
                if (cmp == 0) continue;
                return cmp;
            }
            return params1.length - params2.length;
        }
        return 0;
    }

    private IPackageFragmentRoot getPackageFragmentRoot(Object element) {
        if (element instanceof ClassPathContainer) {
            ClassPathContainer cp = (ClassPathContainer)element;
            Object[] roots = cp.getPackageFragmentRoots();
            if (roots.length > 0) {
                return (IPackageFragmentRoot)roots[0];
            }
            return null;
        }
        return JavaModelUtil.getPackageFragmentRoot((IJavaElement)element);
    }

    private int compareWithLabelProvider(Viewer viewer, Object e1, Object e2) {
        IBaseLabelProvider prov;
        if ((viewer == null || !(viewer instanceof ContentViewer)) && (prov = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            ILabelProvider lprov = (ILabelProvider)prov;
            String name1 = lprov.getText(e1);
            String name2 = lprov.getText(e2);
            if (name1 != null && name2 != null) {
                return this.getCollator().compare(name1, name2);
            }
        }
        return 0;
    }

    private int getClassPathIndex(IPackageFragmentRoot root) {
        try {
            IPath rootPath = root.getPath();
            IPackageFragmentRoot[] roots = root.getJavaProject().getPackageFragmentRoots();
            for (int i = 0; i < roots.length; ++i) {
                if (!roots[i].getPath().equals(rootPath)) continue;
                return i;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return Integer.MAX_VALUE;
    }

    public final Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance();
        }
        return this.collator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

