/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling.engine;

import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import org.eclipse.jdt.internal.ui.text.spelling.engine.AbstractSpellDictionary;

public class PersistentSpellDictionary
extends AbstractSpellDictionary {
    private final URL fLocation;

    public PersistentSpellDictionary(URL url) {
        this.fLocation = url;
    }

    public boolean acceptsWords() {
        return true;
    }

    public void addWord(String word) {
        if (!this.isCorrect(word)) {
            this.hashWord(word);
            try {
                FileWriter writer = new FileWriter(this.fLocation.getPath(), true);
                writer.write(word);
                writer.write("\n");
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected final URL getURL() {
        return this.fLocation;
    }
}

