/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ConstructorFromSuperclassProposal
extends LinkedCorrectionProposal {
    private TypeDeclaration fTypeNode;
    private IMethodBinding fSuperConstructor;

    public ConstructorFromSuperclassProposal(ICompilationUnit cu, TypeDeclaration typeNode, IMethodBinding superConstructor, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.fTypeNode = typeNode;
        this.fSuperConstructor = superConstructor;
    }

    public Image getImage() {
        return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new JavaElementImageDescriptor(JavaPluginImages.DESC_MISC_PUBLIC, 512, JavaElementImageProvider.SMALL_SIZE));
    }

    public String getDisplayString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.fTypeNode.getName().getIdentifier());
        buf.append('(');
        if (this.fSuperConstructor != null) {
            ITypeBinding[] paramTypes = this.fSuperConstructor.getParameterTypes();
            for (int i = 0; i < paramTypes.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(paramTypes[i].getName());
            }
        }
        buf.append(')');
        return CorrectionMessages.getFormattedString("ConstructorFromSuperclassProposal.description", buf.toString());
    }

    protected ASTRewrite getRewrite() throws CoreException {
        AST ast = this.fTypeNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        if (!settings.createComments) {
            settings = null;
        }
        MethodDeclaration newMethodDecl = this.createNewMethodDeclaration(ast, this.fSuperConstructor, rewrite, settings);
        rewrite.getListRewrite((ASTNode)this.fTypeNode, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertFirst((ASTNode)newMethodDecl, null);
        this.addLinkedRanges(rewrite, newMethodDecl);
        return rewrite;
    }

    private void addLinkedRanges(ASTRewrite rewrite, MethodDeclaration newStub) {
        List parameters = newStub.parameters();
        for (int i = 0; i < parameters.size(); ++i) {
            SingleVariableDeclaration curr = (SingleVariableDeclaration)parameters.get(i);
            String name = curr.getName().getIdentifier();
            this.addLinkedPosition(rewrite.track((ASTNode)curr.getType()), false, "arg_type_" + name);
            this.addLinkedPosition(rewrite.track((ASTNode)curr.getName()), false, "arg_name_" + name);
        }
    }

    private MethodDeclaration createNewMethodDeclaration(AST ast, IMethodBinding binding, ASTRewrite rewrite, CodeGenerationSettings commentSettings) throws CoreException {
        String string;
        String name = this.fTypeNode.getName().getIdentifier();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.setConstructor(true);
        decl.setName(ast.newSimpleName(name));
        Block body = ast.newBlock();
        decl.setBody(body);
        SuperConstructorInvocation invocation = null;
        List parameters = decl.parameters();
        String[] paramNames = this.getArgumentNames(binding);
        ITypeBinding enclosingInstance = this.getEnclosingInstance();
        if (enclosingInstance != null) {
            invocation = this.addEnclosingInstanceAccess(rewrite, parameters, paramNames, enclosingInstance);
        }
        if (binding == null) {
            decl.setModifiers(1);
        } else {
            decl.setModifiers(binding.getModifiers());
            ITypeBinding[] params = binding.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                String paramTypeName = this.getImportRewrite().addImport(params[i]);
                SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
                var.setType(ASTNodeFactory.newType(ast, paramTypeName));
                var.setName(ast.newSimpleName(paramNames[i]));
                parameters.add(var);
            }
            List thrownExceptions = decl.thrownExceptions();
            ITypeBinding[] excTypes = binding.getExceptionTypes();
            for (int i = 0; i < excTypes.length; ++i) {
                String excTypeName = this.getImportRewrite().addImport(excTypes[i]);
                thrownExceptions.add(ASTNodeFactory.newName(ast, excTypeName));
            }
            if (invocation == null) {
                invocation = ast.newSuperConstructorInvocation();
            }
            List arguments = invocation.arguments();
            for (int i = 0; i < paramNames.length; ++i) {
                SimpleName argument = ast.newSimpleName(paramNames[i]);
                arguments.add(argument);
                this.addLinkedPosition(rewrite.track((ASTNode)argument), false, "arg_name_" + paramNames[i]);
            }
        }
        String bodyStatement = invocation == null ? "" : ASTNodes.asFormattedString((ASTNode)invocation, 0, String.valueOf('\n'));
        String placeHolder = CodeGeneration.getMethodBodyContent(this.getCompilationUnit(), name, name, true, bodyStatement, String.valueOf('\n'));
        if (placeHolder != null) {
            ASTNode todoNode = rewrite.createStringPlaceholder(placeHolder, 41);
            body.statements().add(todoNode);
        }
        if (commentSettings != null && (string = CodeGeneration.getMethodComment(this.getCompilationUnit(), name, decl, null, String.valueOf('\n'))) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    private SuperConstructorInvocation addEnclosingInstanceAccess(ASTRewrite rewrite, List parameters, String[] paramNames, ITypeBinding enclosingInstance) throws CoreException {
        AST ast = rewrite.getAST();
        SuperConstructorInvocation invocation = ast.newSuperConstructorInvocation();
        String paramTypeName = this.getImportRewrite().addImport(enclosingInstance);
        SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
        var.setType(ASTNodeFactory.newType(ast, paramTypeName));
        String[] enclosingArgNames = StubUtility.getArgumentNameSuggestions(this.getCompilationUnit().getJavaProject(), enclosingInstance.getName(), 0, paramNames);
        String firstName = enclosingArgNames[0];
        var.setName(ast.newSimpleName(firstName));
        parameters.add(var);
        SimpleName enclosing = ast.newSimpleName(firstName);
        invocation.setExpression((Expression)enclosing);
        String key = "arg_name_" + firstName;
        this.addLinkedPosition(rewrite.track((ASTNode)enclosing), false, key);
        for (int i = 0; i < enclosingArgNames.length; ++i) {
            this.addLinkedPositionProposal(key, enclosingArgNames[i], null);
        }
        return invocation;
    }

    private ITypeBinding getEnclosingInstance() {
        ITypeBinding currBinding = this.fTypeNode.resolveBinding();
        if (currBinding == null || Modifier.isStatic((int)currBinding.getModifiers())) {
            return null;
        }
        ITypeBinding superBinding = currBinding.getSuperclass();
        if (superBinding == null || superBinding.getDeclaringClass() == null || Modifier.isStatic((int)superBinding.getModifiers())) {
            return null;
        }
        ITypeBinding enclosing = superBinding.getDeclaringClass();
        while (currBinding != null) {
            if (Bindings.isSuperType(enclosing, currBinding)) {
                return null;
            }
            if (Modifier.isStatic((int)currBinding.getModifiers())) {
                return null;
            }
            currBinding = currBinding.getDeclaringClass();
        }
        return enclosing;
    }

    private String[] getArgumentNames(IMethodBinding binding) {
        if (binding == null) {
            return new String[0];
        }
        int nParams = binding.getParameterTypes().length;
        if (nParams > 0) {
            try {
                IJavaProject project = this.getCompilationUnit().getJavaProject();
                IMethod method = Bindings.findMethod(binding, project);
                if (method != null) {
                    return StubUtility.suggestArgumentNames(project, method.getParameterNames());
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        String[] names = new String[nParams];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "arg" + i;
        }
        return names;
    }
}

