/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.search.GotoMarkerAction;
import org.eclipse.jdt.internal.ui.search.GroupByKeyComputer;
import org.eclipse.jdt.internal.ui.search.JavaSearchOperation;
import org.eclipse.jdt.internal.ui.search.JavaSearchResultLabelProvider;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.internal.ui.search.SearchViewActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.ui.IActionGroupFactory;
import org.eclipse.search.ui.IGroupByKeyComputer;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionGroup;

public class JavaSearchResultCollector
implements IJavaSearchResultCollector {
    private static final String MATCH = SearchMessages.getString("SearchResultCollector.match");
    private static final String MATCHES = SearchMessages.getString("SearchResultCollector.matches");
    private static final String DONE = SearchMessages.getString("SearchResultCollector.done");
    private static final Boolean POTENTIAL_MATCH_VALUE = new Boolean(true);
    private static final String POTENTIAL_MATCH_DIALOG_ID = "Search.PotentialMatchDialog";
    private IProgressMonitor fMonitor;
    private ISearchResultView fView;
    private JavaSearchOperation fOperation;
    private int fMatchCount = 0;
    private int fPotentialMatchCount = 0;
    private long fLastUpdateTime;
    private Integer[] fMessageFormatArgs = new Integer[1];

    public JavaSearchResultCollector() {
        JavaPlugin.getDefault().getImageRegistry();
    }

    public void aboutToStart() {
        this.fPotentialMatchCount = 0;
        this.fView = SearchUI.getSearchResultView();
        this.fMatchCount = 0;
        this.fLastUpdateTime = 0L;
        if (this.fView != null) {
            this.fView.searchStarted((IActionGroupFactory)new ActionGroupFactory(), this.fOperation.getSingularLabel(), this.fOperation.getPluralLabelPattern(), this.fOperation.getImageDescriptor(), "org.eclipse.jdt.ui.JavaSearchPage", (ILabelProvider)new JavaSearchResultLabelProvider(), (IAction)new GotoMarkerAction(), (IGroupByKeyComputer)new GroupByKeyComputer(), (IRunnableWithProgress)this.fOperation);
        }
    }

    public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) throws CoreException {
        ICompilationUnit cu;
        if (enclosingElement == null || accuracy == 1 && SearchUI.arePotentialMatchesIgnored()) {
            return;
        }
        IMarker marker = resource.createMarker("org.eclipse.search.searchmarker");
        Object groupKey = enclosingElement;
        HashMap<String, Object> attributes = new HashMap<String, Object>(7);
        if (accuracy == 1) {
            ++this.fPotentialMatchCount;
            attributes.put("potentialMatch", POTENTIAL_MATCH_VALUE);
            groupKey = groupKey == null ? "?:null" : "?:" + enclosingElement.getHandleIdentifier();
        }
        if ((cu = SearchUtil.findCompilationUnit(enclosingElement)) != null && cu.isWorkingCopy()) {
            attributes.put("org.eclipse.jdt.internal.ui.search.isWorkingCopy", new Boolean(true));
        }
        JavaCore.addJavaElementMarkerAttributes(attributes, (IJavaElement)enclosingElement);
        attributes.put("org.eclipse.jdt.internal.ui.search.handleID", enclosingElement.getHandleIdentifier());
        attributes.put("charStart", new Integer(Math.max(start, 0)));
        attributes.put("charEnd", new Integer(Math.max(end, 0)));
        if (enclosingElement instanceof IMember && ((IMember)enclosingElement).isBinary()) {
            attributes.put("org.eclipse.ui.editorID", "org.eclipse.jdt.ui.ClassFileEditor");
        } else {
            attributes.put("org.eclipse.ui.editorID", "org.eclipse.jdt.ui.CompilationUnitEditor");
        }
        marker.setAttributes(attributes);
        if (this.fView != null) {
            this.fView.addMatch(enclosingElement.getElementName(), groupKey, resource, marker);
        }
        ++this.fMatchCount;
        if (!this.getProgressMonitor().isCanceled() && System.currentTimeMillis() - this.fLastUpdateTime > 1000L) {
            this.getProgressMonitor().subTask(this.getFormattedMatchesString(this.fMatchCount));
            this.fLastUpdateTime = System.currentTimeMillis();
        }
    }

    public void done() {
        if (!this.getProgressMonitor().isCanceled()) {
            String matchesString = this.getFormattedMatchesString(this.fMatchCount);
            this.getProgressMonitor().setTaskName(MessageFormat.format(DONE, matchesString));
        }
        if (this.fView != null) {
            if (this.fPotentialMatchCount > 0) {
                this.explainPotentialMatch(this.fPotentialMatchCount);
            }
            this.fView.searchFinished();
        }
        this.fView = null;
        this.fMonitor = null;
    }

    private void explainPotentialMatch(int potentialMatchCount) {
        final Shell shell = this.fView.getSite().getShell();
        final String title = potentialMatchCount == 1 ? new String(SearchMessages.getString("Search.potentialMatchDialog.title.foundPotentialMatch")) : new String(SearchMessages.getFormattedString("Search.potentialMatchDialog.title.foundPotentialMatches", "" + potentialMatchCount));
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                OptionalMessageDialog.open(JavaSearchResultCollector.POTENTIAL_MATCH_DIALOG_ID, shell, title, null, SearchMessages.getString("Search.potentialMatchDialog.message"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            }
        });
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fMonitor;
    }

    void setProgressMonitor(IProgressMonitor pm) {
        this.fMonitor = pm;
    }

    void setOperation(JavaSearchOperation operation) {
        this.fOperation = operation;
    }

    private String getFormattedMatchesString(int count) {
        if (this.fMatchCount == 1) {
            return MATCH;
        }
        this.fMessageFormatArgs[0] = new Integer(count);
        return MessageFormat.format(MATCHES, this.fMessageFormatArgs);
    }

    private class ActionGroupFactory
    implements IActionGroupFactory {
        private ActionGroupFactory() {
        }

        public ActionGroup createActionGroup(ISearchResultView part) {
            return new SearchViewActionGroup((IViewPart)part);
        }
    }
}

