/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CopyRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.NewNameQueries;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgCopyWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.CopyProjectAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class ReorgCopyAction
extends SelectionDispatchAction {
    public ReorgCopyAction(IWorkbenchSite site) {
        super(site);
        this.setText(ReorgMessages.getString("ReorgCopyAction.3"));
        this.setDescription(ReorgMessages.getString("ReorgCopyAction.4"));
        this.update(this.getSelection());
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.copy_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (this.canDelegateToWorkbenchAction(selection)) {
            this.setEnabled(this.createWorkbenchAction(selection).isEnabled());
            return;
        }
        try {
            List elements = selection.toList();
            IResource[] resources = ReorgUtils.getResources(elements);
            IJavaElement[] javaElements = ReorgUtils.getJavaElements(elements);
            if (elements.size() != resources.length + javaElements.length) {
                this.setEnabled(false);
            } else {
                this.setEnabled(this.canEnable(resources, javaElements));
            }
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private boolean canEnable(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
        return CopyRefactoring.isAvailable(resources, javaElements, JavaPreferencesSettings.getCodeGenerationSettings());
    }

    private CopyProjectAction createWorkbenchAction(IStructuredSelection selection) {
        CopyProjectAction action = new CopyProjectAction(this.getShell());
        action.selectionChanged(selection);
        return action;
    }

    private boolean canDelegateToWorkbenchAction(IStructuredSelection selection) {
        return ReorgUtils.containsOnlyProjects(selection.toList());
    }

    public void run(IStructuredSelection selection) {
        if (this.canDelegateToWorkbenchAction(selection)) {
            this.createWorkbenchAction(selection).run();
            return;
        }
        try {
            List elements = selection.toList();
            IResource[] resources = ReorgUtils.getResources(elements);
            IJavaElement[] javaElements = ReorgUtils.getJavaElements(elements);
            if (this.canEnable(resources, javaElements)) {
                this.startRefactoring(resources, javaElements);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), RefactoringMessages.getString("OpenRefactoringWizardAction.exception"));
        }
    }

    private void startRefactoring(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
        CopyRefactoring refactoring = this.createRefactoring(resources, javaElements);
        RefactoringWizard wizard = this.createWizard(refactoring);
        refactoring.setNewNameQueries(new NewNameQueries((Wizard)wizard));
        refactoring.setReorgQueries(new ReorgQueries((Wizard)wizard));
        new RefactoringStarter().activate(refactoring, wizard, this.getShell(), RefactoringMessages.getString("OpenRefactoringWizardAction.refactoring"), false);
    }

    private RefactoringWizard createWizard(CopyRefactoring refactoring) {
        return new ReorgCopyWizard(refactoring);
    }

    private CopyRefactoring createRefactoring(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
        return CopyRefactoring.create(resources, javaElements, JavaPreferencesSettings.getCodeGenerationSettings());
    }
}

