/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.browsing.IPackagesViewViewer;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

class PackagesViewTableViewer
extends ProblemTableViewer
implements IPackagesViewViewer {
    public PackagesViewTableViewer(Composite parent, int style) {
        super(parent, style);
    }

    public void mapElement(Object element, Widget item) {
        if (element instanceof LogicalPackage && item instanceof Item) {
            LogicalPackage cp = (LogicalPackage)((Object)element);
            IPackageFragment[] fragments = cp.getFragments();
            for (int i = 0; i < fragments.length; ++i) {
                IPackageFragment fragment = fragments[i];
                this.fResourceToItemsMapper.addToMap(fragment, (Item)item);
            }
        }
        super.mapElement(element, item);
    }

    public void unmapElement(Object element, Widget item) {
        if (element instanceof LogicalPackage && item instanceof Item) {
            LogicalPackage cp = (LogicalPackage)((Object)element);
            IPackageFragment[] fragments = cp.getFragments();
            for (int i = 0; i < fragments.length; ++i) {
                IPackageFragment fragment = fragments[i];
                this.fResourceToItemsMapper.removeFromMap(fragment, (Item)item);
            }
        }
        super.unmapElement(element, item);
    }

    protected Object[] getFilteredChildren(Object parent) {
        Object[] result = this.getRawChildren(parent);
        ArrayList<Object> list = new ArrayList<Object>();
        if (result != null) {
            Object[] toBeFiltered = new Object[1];
            for (int i = 0; i < result.length; ++i) {
                Object object = result[i];
                if (object instanceof LogicalPackage) {
                    if (!this.selectLogicalPackage((LogicalPackage)((Object)object))) continue;
                    list.add(object);
                    continue;
                }
                toBeFiltered[0] = object;
                if (this.filter(toBeFiltered).length != 1) continue;
                list.add(object);
            }
        }
        return list.toArray();
    }

    private boolean selectLogicalPackage(LogicalPackage logicalPackage) {
        return this.filter(logicalPackage.getFragments()).length > 0;
    }

    public Widget doFindItem(Object element) {
        return super.doFindItem(element);
    }

    public Widget doFindInputItem(Object element) {
        return super.doFindInputItem(element);
    }

    public List getSelectionFromWidget() {
        return super.getSelectionFromWidget();
    }

    public void doUpdateItem(Widget item, Object element, boolean fullMap) {
        super.doUpdateItem(item, element, fullMap);
    }

    public void internalRefresh(Object element) {
        super.internalRefresh(element);
    }

    public void setSelectionToWidget(List l, boolean reveal) {
        super.setSelectionToWidget(l, reveal);
    }
}

