/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.IConditionChecker;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;

public final class CopyRefactoring
extends Refactoring
implements IReorgDestinationValidator {
    private INewNameQueries fNewNameQueries;
    private IReorgQueries fReorgQueries;
    private IReorgPolicy.ICopyPolicy fCopyPolicy;

    public static boolean isAvailable(IResource[] resources, IJavaElement[] javaElements, CodeGenerationSettings settings) throws JavaModelException {
        return CopyRefactoring.isAvailable(ReorgPolicyFactory.createCopyPolicy(resources, javaElements, settings));
    }

    public static CopyRefactoring create(IResource[] resources, IJavaElement[] javaElements, CodeGenerationSettings settings) throws JavaModelException {
        IReorgPolicy.ICopyPolicy copyPolicy = ReorgPolicyFactory.createCopyPolicy(resources, javaElements, settings);
        if (!CopyRefactoring.isAvailable(copyPolicy)) {
            return null;
        }
        return new CopyRefactoring(copyPolicy);
    }

    private static boolean isAvailable(IReorgPolicy.ICopyPolicy copyPolicy) throws JavaModelException {
        return copyPolicy.canEnable();
    }

    private CopyRefactoring(IReorgPolicy.ICopyPolicy copyPolicy) {
        this.fCopyPolicy = copyPolicy;
    }

    public void setNewNameQueries(INewNameQueries newNameQueries) {
        Assert.isNotNull(newNameQueries);
        this.fNewNameQueries = newNameQueries;
    }

    public void setReorgQueries(IReorgQueries queries) {
        Assert.isNotNull(queries);
        this.fReorgQueries = queries;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(this.fCopyPolicy.getResources()))));
        IResource[] javaResources = ReorgUtils.getResources(this.fCopyPolicy.getJavaElements());
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(javaResources))));
        return result;
    }

    public Object getCommonParentForInputElements() {
        return new ParentChecker(this.fCopyPolicy.getResources(), this.fCopyPolicy.getJavaElements()).getCommonParent();
    }

    public IJavaElement[] getJavaElements() {
        return this.fCopyPolicy.getJavaElements();
    }

    public IResource[] getResources() {
        return this.fCopyPolicy.getResources();
    }

    public RefactoringStatus setDestination(IJavaElement destination) throws JavaModelException {
        return this.fCopyPolicy.setDestination(destination);
    }

    public RefactoringStatus setDestination(IResource destination) throws JavaModelException {
        return this.fCopyPolicy.setDestination(destination);
    }

    public boolean canChildrenBeDestinations(IJavaElement javaElement) {
        return this.fCopyPolicy.canChildrenBeDestinations(javaElement);
    }

    public boolean canChildrenBeDestinations(IResource resource) {
        return this.fCopyPolicy.canChildrenBeDestinations(resource);
    }

    public boolean canElementBeDestination(IJavaElement javaElement) {
        return this.fCopyPolicy.canElementBeDestination(javaElement);
    }

    public boolean canElementBeDestination(IResource resource) {
        return this.fCopyPolicy.canElementBeDestination(resource);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        Assert.isNotNull(this.fNewNameQueries, "Missing new name queries");
        Assert.isNotNull(this.fReorgQueries, "Missing reorg queries");
        pm.beginTask("", 2);
        CheckConditionsContext context = this.createCheckConditionsContext();
        RefactoringStatus result = this.fCopyPolicy.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 1), context, this.fReorgQueries);
        result.merge(context.check((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change createChange(IProgressMonitor pm) throws CoreException {
        Assert.isNotNull(this.fNewNameQueries);
        Assert.isTrue(this.fCopyPolicy.getJavaElementDestination() == null || this.fCopyPolicy.getResourceDestination() == null);
        Assert.isTrue(this.fCopyPolicy.getJavaElementDestination() != null || this.fCopyPolicy.getResourceDestination() != null);
        try {
            DynamicValidationStateChange result = new DynamicValidationStateChange(this.getName()){

                public Change perform(IProgressMonitor pm2) throws CoreException {
                    super.perform(pm2);
                    return null;
                }
            };
            Change change = this.fCopyPolicy.createChange(pm, this.fNewNameQueries);
            if (change instanceof CompositeChange) {
                CompositeChange subComposite = (CompositeChange)change;
                result.merge(subComposite);
            } else {
                result.add(change);
            }
            DynamicValidationStateChange dynamicValidationStateChange = result;
            return dynamicValidationStateChange;
        }
        finally {
            pm.done();
        }
    }

    public String getName() {
        return RefactoringCoreMessages.getString("CopyRefactoring.0");
    }

    private CheckConditionsContext createCheckConditionsContext() throws CoreException {
        CheckConditionsContext result = new CheckConditionsContext();
        ValidateEditChecker checker = new ValidateEditChecker(null);
        result.add((IConditionChecker)checker);
        return result;
    }
}

