/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl;
import org.eclipse.osgi.framework.internal.core.ServiceRegistrationImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class ServiceUse {
    protected ServiceFactory factory;
    protected Object service;
    protected BundleContextImpl context;
    protected ServiceRegistrationImpl registration;
    protected int useCount;

    protected ServiceUse(BundleContextImpl context, ServiceRegistrationImpl registration) {
        this.context = context;
        this.registration = registration;
        this.useCount = 0;
        Object service = registration.service;
        if (service instanceof ServiceFactory) {
            this.factory = (ServiceFactory)service;
            this.service = null;
        } else {
            this.factory = null;
            this.service = service;
        }
    }

    protected Object getService() {
        if (this.useCount == 0 && this.factory != null) {
            Object service;
            BundleHost factorybundle = this.registration.context.bundle;
            try {
                service = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return ServiceUse.this.factory.getService((Bundle)ServiceUse.this.context.bundle, (ServiceRegistration)ServiceUse.this.registration);
                    }
                });
            }
            catch (Throwable t) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println(this.factory + ".getService() exception: " + t.getMessage());
                    Debug.printStackTrace(t);
                }
                this.context.framework.adaptor.handleRuntimeError(t);
                BundleException be = new BundleException(Msg.formatter.getString("SERVICE_FACTORY_EXCEPTION", this.factory.getClass().getName(), "getService"), t);
                this.context.framework.publishFrameworkEvent(2, factorybundle, be);
                return null;
            }
            if (service == null) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println(this.factory + ".getService() returned null.");
                }
                BundleException be = new BundleException(Msg.formatter.getString("SERVICE_OBJECT_NULL_EXCEPTION", this.factory.getClass().getName()));
                this.context.framework.publishFrameworkEvent(2, factorybundle, be);
                return null;
            }
            String[] clazzes = this.registration.clazzes;
            int size = clazzes.length;
            PackageAdminImpl packageAdmin = this.context.framework.packageAdmin;
            for (int i = 0; i < size; ++i) {
                Class clazz = packageAdmin.loadServiceClass(clazzes[i], factorybundle);
                if (clazz == null) {
                    if (Debug.DEBUG_SERVICES) {
                        Debug.println(clazzes[i] + " class not found");
                    }
                    BundleException be = new BundleException(Msg.formatter.getString("SERVICE_CLASS_NOT_FOUND_EXCEPTION", clazzes[i]));
                    this.context.framework.publishFrameworkEvent(2, factorybundle, be);
                    return null;
                }
                if (clazz.isInstance(service)) continue;
                if (Debug.DEBUG_SERVICES) {
                    Debug.println("Service object from ServiceFactory is not an instanceof " + clazzes[i]);
                }
                BundleException be = new BundleException(Msg.formatter.getString("SERVICE_NOT_INSTANCEOF_CLASS_EXCEPTION", this.factory.getClass().getName(), clazzes[i]));
                this.context.framework.publishFrameworkEvent(2, factorybundle, be);
                return null;
            }
            this.service = service;
        }
        ++this.useCount;
        return this.service;
    }

    protected boolean ungetService() {
        if (this.useCount == 0) {
            return true;
        }
        --this.useCount;
        if (this.useCount == 0) {
            if (this.factory != null) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            ServiceUse.this.factory.ungetService((Bundle)ServiceUse.this.context.bundle, (ServiceRegistration)ServiceUse.this.registration, ServiceUse.this.service);
                            return null;
                        }
                    });
                }
                catch (Throwable t) {
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println(this.factory + ".ungetService() exception");
                        Debug.printStackTrace(t);
                    }
                    BundleHost factorybundle = this.registration.context.bundle;
                    BundleException be = new BundleException(Msg.formatter.getString("SERVICE_FACTORY_EXCEPTION", this.factory.getClass().getName(), "ungetService"), t);
                    this.context.framework.publishFrameworkEvent(2, factorybundle, be);
                }
                this.service = null;
            }
            return true;
        }
        return false;
    }

    protected void releaseService() {
        if (this.useCount > 0 && this.factory != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ServiceUse.this.factory.ungetService((Bundle)ServiceUse.this.context.bundle, (ServiceRegistration)ServiceUse.this.registration, ServiceUse.this.service);
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println(this.factory + ".ungetService() exception");
                    Debug.printStackTrace(t);
                }
                BundleHost factorybundle = this.registration.context.bundle;
                BundleException be = new BundleException(Msg.formatter.getString("SERVICE_FACTORY_EXCEPTION", this.factory.getClass().getName(), "ungetService"), t);
                this.context.framework.publishFrameworkEvent(2, factorybundle, be);
            }
            this.service = null;
        }
        this.useCount = 0;
    }
}

