/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.connect;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.VirtualMachineManagerImpl;
import org.eclipse.jdi.internal.connect.ConnectMessages;
import org.eclipse.jdi.internal.connect.ConnectorImpl;
import org.eclipse.jdi.internal.connect.SocketListeningConnectorImpl;
import org.eclipse.jdi.internal.connect.SocketTransportImpl;

public class SocketLaunchingConnectorImpl
extends ConnectorImpl
implements LaunchingConnector {
    private static final int ACCEPT_TIMEOUT = 10000;
    private String fHome;
    private String fOptions;
    private String fMain;
    private boolean fSuspend;
    private String fLauncher;

    public SocketLaunchingConnectorImpl(VirtualMachineManagerImpl virtualMachineManager) {
        super(virtualMachineManager);
        SocketTransportImpl transport = new SocketTransportImpl();
        this.setTransport(transport);
    }

    public Map defaultArguments() {
        HashMap<String, ConnectorImpl.ArgumentImpl> arguments = new HashMap<String, ConnectorImpl.ArgumentImpl>(6);
        ConnectorImpl.StringArgumentImpl strArg = new ConnectorImpl.StringArgumentImpl("home", ConnectMessages.getString("SocketLaunchingConnectorImpl.Home_directory_of_the_SDK_or_runtime_environment_used_to_launch_the_application_1"), ConnectMessages.getString("SocketLaunchingConnectorImpl.Home_2"), false);
        strArg.setValue(System.getProperty("java.home"));
        arguments.put(strArg.name(), strArg);
        strArg = new ConnectorImpl.StringArgumentImpl("options", ConnectMessages.getString("SocketLaunchingConnectorImpl.Launched_VM_options_3"), ConnectMessages.getString("SocketLaunchingConnectorImpl.Options_4"), false);
        arguments.put(strArg.name(), strArg);
        strArg = new ConnectorImpl.StringArgumentImpl("main", ConnectMessages.getString("SocketLaunchingConnectorImpl.Main_class_and_arguments,_or_if_-jar_is_an_option,_the_main_jar_file_and_arguments_5"), ConnectMessages.getString("SocketLaunchingConnectorImpl.Main_6"), true);
        arguments.put(strArg.name(), strArg);
        ConnectorImpl.BooleanArgumentImpl boolArg = new ConnectorImpl.BooleanArgumentImpl("suspend", ConnectMessages.getString("SocketLaunchingConnectorImpl.All_threads_will_be_suspended_before_execution_of_main_7"), ConnectMessages.getString("SocketLaunchingConnectorImpl.Suspend_8"), false);
        boolArg.setValue(true);
        arguments.put(boolArg.name(), boolArg);
        strArg = new ConnectorImpl.StringArgumentImpl("quote", ConnectMessages.getString("SocketLaunchingConnectorImpl.Character_used_to_combine_space-delimited_text_into_a_single_command_line_argument_9"), ConnectMessages.getString("SocketLaunchingConnectorImpl.Quote_10"), true);
        strArg.setValue("\"");
        arguments.put(strArg.name(), strArg);
        strArg = new ConnectorImpl.StringArgumentImpl("vmexec", ConnectMessages.getString("SocketLaunchingConnectorImpl.Name_of_the_Java_VM_launcher_11"), ConnectMessages.getString("SocketLaunchingConnectorImpl.Launcher_12"), true);
        strArg.setValue("java");
        arguments.put(strArg.name(), strArg);
        return arguments;
    }

    public String name() {
        return "com.sun.jdi.CommandLineLaunch";
    }

    public String description() {
        return ConnectMessages.getString("SocketLaunchingConnectorImpl.Launches_target_using_Sun_Java_VM_command_line_and_attaches_to_it_13");
    }

    private void getConnectionArguments(Map connectionArgs) throws IllegalConnectorArgumentsException {
        String attribute = "";
        try {
            attribute = "home";
            this.fHome = ((Connector.StringArgument)connectionArgs.get(attribute)).value();
            attribute = "options";
            this.fOptions = ((Connector.StringArgument)connectionArgs.get(attribute)).value();
            attribute = "main";
            this.fMain = ((Connector.StringArgument)connectionArgs.get(attribute)).value();
            attribute = "suspend";
            this.fSuspend = ((Connector.BooleanArgument)connectionArgs.get(attribute)).booleanValue();
            attribute = "quote";
            ((Connector.StringArgument)connectionArgs.get(attribute)).value();
            attribute = "vmexec";
            this.fLauncher = ((Connector.StringArgument)connectionArgs.get(attribute)).value();
        }
        catch (ClassCastException e) {
            throw new IllegalConnectorArgumentsException(ConnectMessages.getString("SocketLaunchingConnectorImpl.Connection_argument_is_not_of_the_right_type_14"), attribute);
        }
        catch (NullPointerException e) {
            throw new IllegalConnectorArgumentsException(ConnectMessages.getString("SocketLaunchingConnectorImpl.Necessary_connection_argument_is_null_15"), attribute);
        }
        catch (NumberFormatException e) {
            throw new IllegalConnectorArgumentsException(ConnectMessages.getString("SocketLaunchingConnectorImpl.Connection_argument_is_not_a_number_16"), attribute);
        }
    }

    public VirtualMachine launch(Map connectionArgs) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        VirtualMachineImpl virtualMachine;
        this.getConnectionArguments(connectionArgs);
        SocketListeningConnectorImpl listenConnector = new SocketListeningConnectorImpl(this.virtualMachineManager());
        Map args = listenConnector.defaultArguments();
        ((Connector.IntegerArgument)args.get("port")).setValue(0);
        ((Connector.IntegerArgument)args.get("timeout")).setValue(10000);
        listenConnector.startListening(args);
        String slash = System.getProperty("file.separator");
        String execString = this.fHome + slash + "bin" + slash + this.fLauncher;
        execString = execString + " -Xdebug -Xnoagent -Djava.compiler=NONE";
        execString = execString + " -Xrunjdwp:transport=dt_socket,address=localhost:" + listenConnector.listeningPort() + ",server=n,suspend=" + (this.fSuspend ? "y" : "n");
        if (this.fOptions != null) {
            execString = execString + " " + this.fOptions;
        }
        execString = execString + " " + this.fMain;
        Process proc = Runtime.getRuntime().exec(execString);
        try {
            virtualMachine = (VirtualMachineImpl)listenConnector.accept(args);
        }
        catch (InterruptedIOException e) {
            proc.destroy();
            String message = MessageFormat.format(ConnectMessages.getString("SocketLaunchingConnectorImpl.VM_did_not_connect_within_given_time__{0}_ms_1"), ((Connector.IntegerArgument)args.get("timeout")).value());
            throw new VMStartException(message, proc);
        }
        virtualMachine.setLauncedProcess(proc);
        return virtualMachine;
    }
}

