/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

public class PdeJUnitPlugin
extends Plugin {
    private static PdeJUnitPlugin inst;
    private ResourceBundle resourceBundle;

    public PdeJUnitPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        inst = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.pde.internal.junit.runtime.junitresources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public static PdeJUnitPlugin getDefault() {
        return inst;
    }

    public static String getFormattedMessage(String key, String arg) {
        String text = PdeJUnitPlugin.getResourceString(key);
        return MessageFormat.format(text, arg);
    }

    public static String getFormattedMessage(String key, String[] args) {
        String text = PdeJUnitPlugin.getResourceString(key);
        return MessageFormat.format(text, args);
    }

    static IPath getInstallLocation() {
        return new Path(inst.getDescriptor().getInstallURL().getFile());
    }

    public static String getPluginId() {
        return inst.getDescriptor().getUniqueIdentifier();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = inst.getResourceBundle();
        if (bundle != null) {
            try {
                String bundleString = bundle.getString(key);
                return bundleString;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return key;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }
}

