/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class ColorUtils {
    static /* synthetic */ Class class$org$eclipse$swt$SWT;

    private static RGB process(String value) {
        try {
            Class clazz = class$org$eclipse$swt$SWT == null ? (class$org$eclipse$swt$SWT = ColorUtils.class$("org.eclipse.swt.SWT")) : class$org$eclipse$swt$SWT;
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (field.getType() != Integer.TYPE || !Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !value.equals(field.getName())) continue;
                return ColorUtils.getSystemColor(field.getInt(null));
            }
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return ColorUtils.getSystemColor(2);
    }

    public static RGB blend(RGB val1, RGB val2) {
        int red = ColorUtils.blend(val1.red, val2.red);
        int green = ColorUtils.blend(val1.green, val2.green);
        int blue = ColorUtils.blend(val1.blue, val2.blue);
        return new RGB(red, green, blue);
    }

    private static int blend(int temp1, int temp2) {
        return Math.abs(temp1 - temp2) / 2 + Math.min(temp1, temp2);
    }

    private static RGB getSystemColor(int colorId) {
        return Display.getCurrent().getSystemColor(colorId).getRGB();
    }

    public static RGB getColorValue(String rawValue) {
        if (rawValue == null) {
            return null;
        }
        if (!ColorUtils.isDirectValue(rawValue = rawValue.trim())) {
            return ColorUtils.process(rawValue);
        }
        return StringConverter.asRGB((String)rawValue);
    }

    public static RGB[] getColorValues(String[] rawValues) {
        RGB[] values = new RGB[rawValues.length];
        for (int i = 0; i < rawValues.length; ++i) {
            values[i] = ColorUtils.getColorValue(rawValues[i]);
        }
        return values;
    }

    private static boolean isDirectValue(String rawValue) {
        return rawValue == null ? true : rawValue.matches("\\d{1,3},\\d{1,3},\\d{1,3}");
    }

    private ColorUtils() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

