/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.util.PrefUtil;

public class StartupPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table pluginsList;
    private Workbench workbench;

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, "org.eclipse.ui.startup_preference_page_context");
        Composite composite = this.createComposite(parent);
        this.createEarlyStartupSelection(composite);
        return composite;
    }

    protected Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected void createEarlyStartupSelection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(WorkbenchMessages.getString("StartupPreferencePage.label"));
        label.setFont(parent.getFont());
        GridData data = new GridData(768);
        label.setLayoutData((Object)data);
        this.pluginsList = new Table(parent, 2848);
        data = new GridData(1808);
        this.pluginsList.setFont(parent.getFont());
        this.pluginsList.setLayoutData((Object)data);
        this.populatePluginsList();
    }

    private void populatePluginsList() {
        String[] descriptors = this.workbench.getEarlyActivatedPlugins();
        IPreferenceStore store = this.workbench.getPreferenceStore();
        String pref = store.getString("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
        if (pref == null) {
            pref = new String();
        }
        for (int i = 0; i < descriptors.length; ++i) {
            String desc = descriptors[i];
            TableItem item = new TableItem(this.pluginsList, 0);
            item.setText((String)Platform.getBundle((String)desc).getHeaders().get("Bundle-Name"));
            item.setData((Object)desc);
            String id = desc + ';';
            item.setChecked(pref.indexOf(id) < 0);
        }
    }

    public void init(IWorkbench workbench) {
        this.workbench = (Workbench)workbench;
    }

    protected void performDefaults() {
        TableItem[] items = this.pluginsList.getItems();
        for (int i = 0; i < items.length; ++i) {
            items[i].setChecked(true);
        }
    }

    public boolean performOk() {
        StringBuffer preference = new StringBuffer();
        TableItem[] items = this.pluginsList.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (items[i].getChecked()) continue;
            preference.append((String)items[i].getData());
            preference.append(';');
        }
        String pref = preference.toString();
        IPreferenceStore store = this.workbench.getPreferenceStore();
        store.putValue("PLUGINS_NOT_ACTIVATED_ON_STARTUP", pref);
        PrefUtil.savePrefs();
        return true;
    }
}

