/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.decorators.DecorationBuilder;
import org.eclipse.ui.internal.decorators.DecorationReference;
import org.eclipse.ui.internal.decorators.DecorationResult;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class DecorationScheduler {
    Map resultCache = new HashMap();
    List awaitingDecoration = new ArrayList();
    Set pendingUpdate = new HashSet();
    Object resultLock = new Object();
    Map awaitingDecorationValues = new HashMap();
    DecoratorManager decoratorManager;
    boolean shutdown = false;
    Job decorationJob;
    UIJob updateJob;

    DecorationScheduler(DecoratorManager manager) {
        this.decoratorManager = manager;
        this.createDecorationJob();
    }

    public String decorateWithText(String text, Object element, Object adaptedElement) {
        if (element == null) {
            return text;
        }
        DecorationResult decoration = (DecorationResult)this.resultCache.get(element);
        if (decoration == null) {
            this.queueForDecoration(element, adaptedElement, false, text);
            return text;
        }
        return decoration.decorateWithText(text);
    }

    synchronized void queueForDecoration(Object element, Object adaptedElement, boolean forceUpdate, String undecoratedText) {
        if (this.awaitingDecorationValues.containsKey(element)) {
            if (forceUpdate) {
                DecorationReference reference = (DecorationReference)this.awaitingDecorationValues.get(element);
                reference.setForceUpdate(forceUpdate);
            }
        } else {
            DecorationReference reference = new DecorationReference(element, adaptedElement);
            reference.setForceUpdate(forceUpdate);
            reference.setUndecoratedText(undecoratedText);
            this.awaitingDecorationValues.put(element, reference);
            this.awaitingDecoration.add(element);
            if (this.shutdown) {
                return;
            }
            if (this.decorationJob.getState() == 1) {
                this.decorationJob.wakeUp();
            }
            this.decorationJob.schedule();
        }
    }

    public Image decorateWithOverlays(Image image, Object element, Object adaptedElement) {
        if (element == null) {
            return image;
        }
        DecorationResult decoration = (DecorationResult)this.resultCache.get(element);
        if (decoration == null) {
            this.queueForDecoration(element, adaptedElement, false, null);
            return image;
        }
        return decoration.decorateWithOverlays(image, this.decoratorManager.getLightweightManager().getOverlayCache());
    }

    synchronized void decorated() {
        if (this.shutdown) {
            return;
        }
        if (this.updateJob == null) {
            this.updateJob = this.getUpdateJob();
            this.updateJob.setPriority(50);
        }
        this.updateJob.schedule(100L);
    }

    void shutdown() {
        this.shutdown = true;
    }

    synchronized DecorationReference nextElement() {
        if (this.shutdown || this.awaitingDecoration.isEmpty()) {
            return null;
        }
        Object element = this.awaitingDecoration.remove(0);
        return (DecorationReference)this.awaitingDecorationValues.remove(element);
    }

    private void createDecorationJob() {
        this.decorationJob = new Job(WorkbenchMessages.getString("DecorationScheduler.CalculationJobName")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus run(IProgressMonitor monitor) {
                DecorationReference reference;
                monitor.beginTask(WorkbenchMessages.getString("DecorationScheduler.CalculatingTask"), 100);
                monitor.worked(5);
                int workCount = 5;
                while ((reference = DecorationScheduler.this.nextElement()) != null) {
                    if (workCount < 90) {
                        monitor.worked(1);
                        ++workCount;
                    }
                    DecorationBuilder cacheResult = new DecorationBuilder();
                    monitor.subTask(reference.getSubTask());
                    Object element = reference.getElement();
                    Object adapted = reference.getAdaptedElement();
                    boolean elementIsCached = true;
                    DecorationResult adaptedResult = null;
                    Object object = DecorationScheduler.this.resultLock;
                    synchronized (object) {
                        elementIsCached = DecorationScheduler.this.resultCache.containsKey(element);
                        if (elementIsCached) {
                            DecorationScheduler.this.pendingUpdate.add(element);
                        }
                        if (adapted != null) {
                            adaptedResult = (DecorationResult)DecorationScheduler.this.resultCache.get(adapted);
                        }
                    }
                    if (!elementIsCached) {
                        if (adapted != null) {
                            if (adaptedResult == null) {
                                DecorationScheduler.this.decoratorManager.getLightweightManager().getDecorations(adapted, cacheResult, true);
                                if (cacheResult.hasValue()) {
                                    adaptedResult = cacheResult.createResult();
                                }
                            } else {
                                cacheResult.applyResult(adaptedResult);
                                adaptedResult = null;
                            }
                        }
                        DecorationScheduler.this.decoratorManager.getLightweightManager().getDecorations(element, cacheResult, false);
                        if (cacheResult.hasValue() || reference.shouldForceUpdate()) {
                            object = DecorationScheduler.this.resultLock;
                            synchronized (object) {
                                if (adaptedResult != null) {
                                    DecorationScheduler.this.resultCache.put(adapted, adaptedResult);
                                }
                                DecorationScheduler.this.resultCache.put(element, cacheResult.createResult());
                                DecorationScheduler.this.pendingUpdate.add(element);
                            }
                        }
                    }
                    if (!DecorationScheduler.this.awaitingDecoration.isEmpty()) continue;
                    DecorationScheduler.this.decorated();
                }
                monitor.worked(100 - workCount);
                monitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return DecoratorManager.FAMILY_DECORATE == family;
            }
        };
        this.decorationJob.setSystem(true);
        this.decorationJob.setPriority(50);
        this.decorationJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearResults() {
        Object object = this.resultLock;
        synchronized (object) {
            this.resultCache.clear();
        }
    }

    private WorkbenchJob getUpdateJob() {
        WorkbenchJob job = new WorkbenchJob(WorkbenchMessages.getString("DecorationScheduler.UpdateJobName")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object object = DecorationScheduler.this.resultLock;
                synchronized (object) {
                    if (DecorationScheduler.this.pendingUpdate.isEmpty()) {
                        return Status.OK_STATUS;
                    }
                    Object[] elements = DecorationScheduler.this.pendingUpdate.toArray(new Object[DecorationScheduler.this.pendingUpdate.size()]);
                    monitor.beginTask(WorkbenchMessages.getString("DecorationScheduler.UpdatingTask"), elements.length + 20);
                    DecorationScheduler.this.pendingUpdate.clear();
                    monitor.worked(15);
                    DecorationScheduler.this.decoratorManager.fireListeners(new LabelProviderChangedEvent((IBaseLabelProvider)DecorationScheduler.this.decoratorManager, elements));
                    monitor.worked(elements.length);
                    if (DecorationScheduler.this.awaitingDecoration.isEmpty()) {
                        DecorationScheduler.this.resultCache.clear();
                    }
                    monitor.worked(5);
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            public void performDone(IJobChangeEvent event) {
                if (!DecorationScheduler.this.pendingUpdate.isEmpty()) {
                    DecorationScheduler.this.decorated();
                }
            }
        };
        job.setSystem(true);
        return job;
    }

    public boolean isDecorationReady(Object element) {
        return this.resultCache.get(element) != null;
    }
}

