/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching.sourcelookup.containers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;

public class PackageFragmentRootSourceContainer
extends AbstractSourceContainer {
    private IPackageFragmentRoot fRoot;
    public static final String TYPE_ID = LaunchingPlugin.getUniqueIdentifier() + ".sourceContainer.packageFragmentRoot";

    public PackageFragmentRootSourceContainer(IPackageFragmentRoot root) {
        this.fRoot = root;
    }

    public Object[] findSourceElements(String name) throws CoreException {
        IClassFile file;
        IPackageFragment fragment;
        int index = name.lastIndexOf(46);
        String typeName = name;
        if (index >= 0) {
            typeName = typeName.substring(0, index);
        }
        typeName = typeName.replace('/', '.');
        typeName = typeName.replace('\\', '.');
        index = typeName.lastIndexOf(46);
        String packageName = "";
        if (index >= 0) {
            packageName = typeName.substring(0, index);
            typeName = typeName.substring(index + 1);
        }
        if ((fragment = this.fRoot.getPackageFragment(packageName)).exists() && (file = fragment.getClassFile(typeName + ".class")).exists()) {
            return new Object[]{file};
        }
        return EMPTY;
    }

    public String getName() {
        return this.fRoot.getElementName();
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public boolean equals(Object obj) {
        return obj instanceof PackageFragmentRootSourceContainer && ((PackageFragmentRootSourceContainer)((Object)obj)).getPackageFragmentRoot().equals(this.getPackageFragmentRoot());
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this.fRoot;
    }

    public int hashCode() {
        return this.fRoot.hashCode();
    }

    public IPath getPath() {
        return this.getPackageFragmentRoot().getPath();
    }
}

