/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfigurationActivityModel;
import org.eclipse.update.internal.model.ConfiguredSiteModel;
import org.eclipse.update.internal.model.InstallConfigurationParser;

public class InstallConfigurationModel
extends ModelObject {
    private URL bundleURL;
    private URL base;
    private boolean resolved = false;
    private boolean isCurrent;
    private URL locationURL;
    private String locationURLString;
    protected Date date;
    private String label;
    private List activities;
    private List configurationSites;
    protected boolean initialized = false;

    public ConfiguredSiteModel[] getConfigurationSitesModel() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.configurationSites == null || this.configurationSites.size() == 0) {
            return new ConfiguredSiteModel[0];
        }
        return (ConfiguredSiteModel[])this.configurationSites.toArray(this.arrayTypeFor(this.configurationSites));
    }

    public void addConfigurationSiteModel(ConfiguredSiteModel site) {
        if (this.configurationSites == null) {
            this.configurationSites = new ArrayList();
        }
        if (!this.configurationSites.contains((Object)site)) {
            this.configurationSites.add(site);
        }
    }

    public void setConfigurationSiteModel(ConfiguredSiteModel[] sites) {
        this.configurationSites = null;
        for (int i = 0; i < sites.length; ++i) {
            this.addConfigurationSiteModel(sites[i]);
        }
    }

    public boolean removeConfigurationSiteModel(ConfiguredSiteModel site) {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.configurationSites != null) {
            return this.configurationSites.remove((Object)site);
        }
        return false;
    }

    public boolean isCurrent() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.isCurrent;
    }

    public void setCurrent(boolean isCurrent) {
        this.isCurrent = isCurrent;
    }

    public ConfigurationActivityModel[] getActivityModel() {
        if (this.activities == null && !this.initialized) {
            this.initialize();
        }
        if (this.activities == null || this.activities.size() == 0) {
            return new ConfigurationActivityModel[0];
        }
        return (ConfigurationActivityModel[])this.activities.toArray(this.arrayTypeFor(this.activities));
    }

    public void addActivityModel(ConfigurationActivityModel activity) {
        if (this.activities == null) {
            this.activities = new ArrayList();
        }
        if (!this.activities.contains((Object)activity)) {
            this.activities.add(activity);
            activity.setInstallConfigurationModel(this);
        }
    }

    public Date getCreationDate() {
        if (this.date == null) {
            this.initialize();
        }
        return this.date;
    }

    public void setCreationDate(Date date) {
        this.assertIsWriteable();
        this.date = date;
    }

    public URL getURL() {
        this.delayedResolve();
        return this.locationURL;
    }

    public String getLabel() {
        if (this.label == null) {
            this.initialize();
        }
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }

    public void setLabel(String label) {
        this.assertIsWriteable();
        this.label = label;
    }

    public String getLocationURLString() {
        if (!this.initialized) {
            this.delayedResolve();
        }
        return this.locationURLString;
    }

    public void setLocationURLString(String locationURLString) {
        this.assertIsWriteable();
        this.locationURLString = locationURLString;
        this.locationURL = null;
    }

    public void resolve(URL base, URL bundleURL) throws MalformedURLException {
        this.base = base;
        this.bundleURL = bundleURL;
    }

    public long getTimeline() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        try {
            try {
                IPlatformConfiguration platformConfig = UpdateManagerUtils.sameURL(this.getURL(), ConfiguratorUtils.getCurrentPlatformConfiguration().getConfigurationLocation()) ? ConfiguratorUtils.getCurrentPlatformConfiguration() : ConfiguratorUtils.getPlatformConfiguration((URL)this.getURL());
                new InstallConfigurationParser(platformConfig, this);
            }
            catch (FileNotFoundException exception) {
                UpdateCore.warn(this.locationURLString + " does not exist, The local site is not in synch with the file system and is pointing to a file that doesn't exist.", exception);
                throw Utilities.newCoreException(Policy.bind("InstallConfiguration.ErrorDuringFileAccess", this.locationURLString), exception);
            }
            catch (IOException exception) {
                throw Utilities.newCoreException(Policy.bind("InstallConfiguration.ErrorDuringFileAccess", this.locationURLString), exception);
            }
        }
        catch (CoreException e) {
            UpdateCore.warn("Error processing configuration history:" + this.locationURL.toExternalForm(), e);
        }
        finally {
            this.initialized = true;
        }
        try {
            this.resolveListReference(this.getActivityModel(), this.base, this.bundleURL);
            this.resolveListReference(this.getConfigurationSitesModel(), this.base, this.bundleURL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void delayedResolve() {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        try {
            this.locationURL = new URL(this.locationURLString);
        }
        catch (MalformedURLException e) {
            File f = new File(this.locationURLString);
            try {
                this.locationURL = f.exists() ? f.toURL() : this.base;
            }
            catch (MalformedURLException e1) {
                this.locationURL = this.base;
            }
        }
    }

    public void resetActivities() {
        this.activities = null;
    }
}

