/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.core.IFeatureFactory;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;

public final class FeatureTypeFactory {
    private static FeatureTypeFactory inst;
    private Map factories;
    private static final String SIMPLE_EXTENSION_ID = "featureTypes";

    private FeatureTypeFactory() {
    }

    public static FeatureTypeFactory getInstance() {
        if (inst == null) {
            inst = new FeatureTypeFactory();
        }
        return inst;
    }

    public IFeatureFactory getFactory(String type) throws CoreException {
        Object instance = this.getFactories().get(type);
        if (instance == null) {
            instance = this.createFactoryFor(type);
            this.getFactories().put(type, instance);
        }
        return (IFeatureFactory)instance;
    }

    private IFeatureFactory createFactoryFor(String type) throws CoreException {
        IFeatureFactory result = null;
        String pluginID = UpdateCore.getPlugin().getBundle().getSymbolicName();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(pluginID, SIMPLE_EXTENSION_ID, type);
        if (elements == null || elements.length == 0) {
            throw Utilities.newCoreException(Policy.bind("FeatureTypeFactory.UnableToFindFeatureFactory", type), null);
        }
        IConfigurationElement element = elements[0];
        result = (IFeatureFactory)element.createExecutableExtension("class");
        return result;
    }

    private Map getFactories() {
        if (this.factories == null) {
            this.factories = new HashMap();
        }
        return this.factories;
    }
}

