/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.wizards.imports.BaseImportWizardSecondPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportOperation;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardDetailedPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardExpressPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardFirstPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class PluginImportWizard
extends Wizard
implements IImportWizard {
    private static final String STORE_SECTION = "PluginImportWizard";
    private IStructuredSelection selection;
    private PluginImportWizardFirstPage page1;
    private BaseImportWizardSecondPage page2;
    private BaseImportWizardSecondPage page3;

    public PluginImportWizard() {
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_PLUGIN_IMPORT_WIZ);
        this.setWindowTitle(PDEPlugin.getResourceString("ImportWizard.title"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        this.page1 = new PluginImportWizardFirstPage("first");
        this.addPage((IWizardPage)this.page1);
        this.page2 = new PluginImportWizardExpressPage("express", this.page1, this.selection);
        this.addPage((IWizardPage)this.page2);
        this.page3 = new PluginImportWizardDetailedPage("detailed", this.page1);
        this.addPage((IWizardPage)this.page3);
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    private IPluginModelBase[] getModelsToImport() {
        if (this.page1.getNextPage().equals((Object)this.page2)) {
            return this.page2.getModelsToImport();
        }
        return this.page3.getModelsToImport();
    }

    public boolean performFinish() {
        this.page1.storeSettings();
        ((BaseImportWizardSecondPage)this.page1.getNextPage()).storeSettings();
        try {
            IPluginModelBase[] models = this.getModelsToImport();
            IRunnableWithProgress op = PluginImportWizard.getImportOperation(this.getShell(), this.page1.getImportType(), models);
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return true;
        }
        return true;
    }

    public static IRunnableWithProgress getImportOperation(final Shell shell, final int importType, final IPluginModelBase[] models) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ReplaceQuery query = new ReplaceQuery(shell);
                    PluginImportOperation op = new PluginImportOperation(models, importType, query);
                    PDEPlugin.getWorkspace().run((IWorkspaceRunnable)op, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getMessage());
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page.equals((Object)this.page1)) {
            if (this.page1.getScanAllPlugins()) {
                return this.page3;
            }
            return this.page2;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return page.equals((Object)this.page1) ? null : this.page1;
    }

    public boolean canFinish() {
        return this.page1.getNextPage().isPageComplete();
    }

    private static class ReplaceQuery
    implements PluginImportOperation.IReplaceQuery {
        private Shell shell;
        private int yesToAll = 0;
        private int[] RETURNCODES = new int[]{2, 2, 1, 1, 0};

        public ReplaceQuery(Shell shell) {
            this.shell = shell;
        }

        public int doQuery(IProject project) {
            if (this.yesToAll != 0) {
                return this.yesToAll > 0 ? 2 : 1;
            }
            String message = PDEPlugin.getFormattedMessage("ImportWizard.messages.exists", project.getName());
            int[] result = new int[]{0};
            this.shell.getDisplay().syncExec(new Runnable(this, message, result){
                private final /* synthetic */ String val$message;
                private final /* synthetic */ int[] val$result;
                private final /* synthetic */ ReplaceQuery this$0;
                {
                    this.this$0 = this$0;
                    this.val$message = val$message;
                    this.val$result = val$result;
                }

                public void run() {
                    ReplaceDialog dialog = new ReplaceDialog(ReplaceQuery.access$000(this.this$0), this.val$message);
                    int retVal = dialog.open();
                    if (retVal >= 0) {
                        this.val$result[0] = ReplaceQuery.access$100(this.this$0)[retVal];
                        if (retVal == 1) {
                            ReplaceQuery.access$202(this.this$0, 1);
                        } else if (retVal == 3) {
                            ReplaceQuery.access$202(this.this$0, -1);
                        }
                    }
                }
            });
            return result[0];
        }

        static /* synthetic */ Shell access$000(ReplaceQuery x0) {
            return x0.shell;
        }

        static /* synthetic */ int[] access$100(ReplaceQuery x0) {
            return x0.RETURNCODES;
        }

        static /* synthetic */ int access$202(ReplaceQuery x0, int x1) {
            x0.yesToAll = x1;
            return x0.yesToAll;
        }
    }

    private static class ReplaceDialog
    extends MessageDialog {
        public ReplaceDialog(Shell parentShell, String dialogMessage) {
            super(parentShell, PDEPlugin.getResourceString("ImportWizard.messages.title"), null, dialogMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, PDEPlugin.getResourceString("ImportWizard.noToAll"), IDialogConstants.CANCEL_LABEL}, 0);
        }
    }
}

