/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class EditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    public EditorPreferencePage() {
        super(1);
        this.setPreferenceStore(PDEPlugin.getDefault().getPreferenceStore());
        this.setDescription(PDEPlugin.getResourceString("EditorPreferencePage.desc"));
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("useSourcePage", PDEPlugin.getResourceString("EditorPreferencePage.useSourcePage"), this.getFieldEditorParent()));
        this.addLabel("", 2);
        this.addLabel(PDEPlugin.getResourceString("EditorPreferencePage.colorSettings"), 2);
        this.addSourceColorFields();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Dialog.applyDialogFont((Control)this.getControl());
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.pde.doc.user.editor_preference_page");
    }

    public static boolean getUseSourcePage() {
        return PDEPlugin.getDefault().getPreferenceStore().getBoolean("useSourcePage");
    }

    private void addLabel(String text, int span) {
        Label label = new Label(this.getFieldEditorParent(), 0);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        label.setLayoutData((Object)gd);
        label.setText(text);
    }

    private void addSourceColorFields() {
        this.addField((FieldEditor)new ColorFieldEditor("editor.color.default", PDEPlugin.getResourceString("EditorPreferencePage.text"), this.getFieldEditorParent()));
        this.addField((FieldEditor)new ColorFieldEditor("editor.color.instr", PDEPlugin.getResourceString("EditorPreferencePage.proc"), this.getFieldEditorParent()));
        this.addField((FieldEditor)new ColorFieldEditor("editor.color.string", PDEPlugin.getResourceString("EditorPreferencePage.string"), this.getFieldEditorParent()));
        this.addField((FieldEditor)new ColorFieldEditor("editor.color.tag", PDEPlugin.getResourceString("EditorPreferencePage.tag"), this.getFieldEditorParent()));
        this.addField((FieldEditor)new ColorFieldEditor("editor.color.xml_comment", PDEPlugin.getResourceString("EditorPreferencePage.comment"), this.getFieldEditorParent()));
    }

    public boolean performOk() {
        PDEPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }
}

