/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.IProjectSetSerializer;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.ProjectSetContentHandler;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.UIProjectSetSerializationContext;
import org.eclipse.team.internal.ui.wizards.ImportProjectSetMainPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectSetImportWizard
extends Wizard
implements IImportWizard {
    ImportProjectSetMainPage mainPage;
    public static String lastFile;

    public ProjectSetImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Policy.bind("ProjectSetImportWizard.Project_Set_1"));
    }

    public void addPages() {
        this.mainPage = new ImportProjectSetMainPage("projectSetMainPage", Policy.bind("ProjectSetImportWizard.Import_a_Project_Set_3"), TeamUIPlugin.getImageDescriptor("wizban/import_projectset_wizban.gif"));
        this.mainPage.setFileName(lastFile);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        boolean[] result;
        block6: {
            IWorkingSet existingSet;
            final String workingSetName = this.mainPage.getWorkingSetName();
            if (workingSetName != null && (existingSet = TeamUIPlugin.getPlugin().getWorkbench().getWorkingSetManager().getWorkingSet(workingSetName)) != null && !MessageDialog.openConfirm((Shell)this.getShell(), (String)Policy.bind("ProjectSetImportWizard.workingSetExistsTitle"), (String)Policy.bind("ProjectSetImportWizard.workingSetExistsMessage", workingSetName))) {
                return false;
            }
            result = new boolean[]{false};
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(null){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void execute(IProgressMonitor monitor) throws InvocationTargetException {
                        InputStreamReader reader = null;
                        try {
                            try {
                                String filename;
                                lastFile = filename = ProjectSetImportWizard.this.mainPage.getFileName();
                                reader = new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8");
                                SAXParserFactory factory = SAXParserFactory.newInstance();
                                SAXParser parser = factory.newSAXParser();
                                ProjectSetContentHandler handler = new ProjectSetContentHandler();
                                InputSource source = new InputSource(reader);
                                parser.parse(source, (DefaultHandler)handler);
                                Map map = handler.getReferences();
                                ArrayList<IProject> newProjects = new ArrayList<IProject>();
                                if (map.size() == 0 && handler.isVersionOne()) {
                                    IProject[] projects;
                                    IProjectSetSerializer serializer = Team.getProjectSetSerializer((String)"versionOneSerializer");
                                    if (serializer != null && (projects = serializer.addToWorkspace(new String[0], filename, (Object)ProjectSetImportWizard.this.getShell(), monitor)) != null) {
                                        newProjects.addAll(Arrays.asList(projects));
                                    }
                                } else {
                                    UIProjectSetSerializationContext context = new UIProjectSetSerializationContext(ProjectSetImportWizard.this.getShell(), filename);
                                    Iterator it = map.keySet().iterator();
                                    ArrayList<TeamException> errors = new ArrayList<TeamException>();
                                    while (it.hasNext()) {
                                        try {
                                            IProject[] projects;
                                            String id = (String)it.next();
                                            List references = (List)map.get(id);
                                            RepositoryProviderType providerType = RepositoryProviderType.getProviderType((String)id);
                                            if (providerType == null) {
                                                providerType = TeamPlugin.getAliasType((String)id);
                                            }
                                            if (providerType == null) {
                                                throw new TeamException((IStatus)new Status(4, "org.eclipse.team.ui", 0, Policy.bind("ProjectSetImportWizard.0", id), null));
                                            }
                                            ProjectSetCapability serializer = providerType.getProjectSetCapability();
                                            ProjectSetCapability.ensureBackwardsCompatible((RepositoryProviderType)providerType, (ProjectSetCapability)serializer);
                                            if (serializer == null || (projects = serializer.addToWorkspace(references.toArray(new String[references.size()]), (ProjectSetSerializationContext)context, monitor)) == null) continue;
                                            newProjects.addAll(Arrays.asList(projects));
                                        }
                                        catch (TeamException e) {
                                            errors.add(e);
                                        }
                                    }
                                    if (!errors.isEmpty()) {
                                        if (errors.size() == 1) {
                                            throw (TeamException)((Object)errors.get(0));
                                        }
                                        TeamException[] exceptions = errors.toArray(new TeamException[errors.size()]);
                                        IStatus[] status = new IStatus[exceptions.length];
                                        int i = 0;
                                        while (i < exceptions.length) {
                                            status[i] = exceptions[i].getStatus();
                                            ++i;
                                        }
                                        throw new TeamException((IStatus)new MultiStatus("org.eclipse.team.ui", 0, status, Policy.bind("ProjectSetImportWizard.1"), null));
                                    }
                                }
                                if (workingSetName != null) {
                                    ProjectSetImportWizard.this.createWorkingSet(workingSetName, newProjects.toArray(new IProject[newProjects.size()]));
                                }
                                result[0] = true;
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (SAXException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (ParserConfigurationException e) {
                                throw new InvocationTargetException(e);
                            }
                            Object var19_26 = null;
                            if (reader == null) return;
                        }
                        catch (Throwable throwable) {
                            Object var19_27 = null;
                            if (reader == null) throw throwable;
                            try {
                                reader.close();
                                throw throwable;
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        try {}
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                        reader.close();
                    }
                });
            }
            catch (InterruptedException e) {
                return true;
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof TeamException) {
                    ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)((TeamException)target).getStatus());
                    return false;
                }
                if (target instanceof RuntimeException) {
                    throw (RuntimeException)target;
                }
                if (!(target instanceof Error)) break block6;
                throw (Error)target;
            }
        }
        return result[0];
    }

    void createWorkingSet(String workingSetName, IProject[] projects) {
        IWorkingSetManager manager = TeamUIPlugin.getPlugin().getWorkbench().getWorkingSetManager();
        IWorkingSet oldSet = manager.getWorkingSet(workingSetName);
        if (oldSet == null) {
            IWorkingSet newSet = manager.createWorkingSet(workingSetName, (IAdaptable[])projects);
            manager.addWorkingSet(newSet);
        } else {
            oldSet.setElements((IAdaptable[])projects);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

