/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DecoratingColorLabelProvider
extends DecoratingLabelProvider
implements IColorProvider,
IFontProvider {
    public DecoratingColorLabelProvider(ILabelProvider provider, ILabelDecorator[] decorators) {
        super(provider, (ILabelDecorator)new MultiLabelDecorator(decorators));
    }

    public Color getForeground(Object element) {
        ILabelProvider p = this.getLabelProvider();
        if (p instanceof IColorProvider) {
            return ((IColorProvider)p).getForeground(element);
        }
        return null;
    }

    public Color getBackground(Object element) {
        ILabelProvider p = this.getLabelProvider();
        if (p instanceof IColorProvider) {
            return ((IColorProvider)p).getBackground(element);
        }
        return null;
    }

    public Font getFont(Object element) {
        ILabelProvider p = this.getLabelProvider();
        if (p instanceof IFontProvider) {
            return ((IFontProvider)p).getFont(element);
        }
        return null;
    }

    static class MultiLabelDecorator
    extends LabelProvider
    implements ILabelDecorator {
        private ILabelDecorator[] decorators;

        public MultiLabelDecorator(ILabelDecorator[] decorators) {
            this.decorators = decorators;
        }

        public Image decorateImage(Image image, Object element) {
            for (int i = 0; i < this.decorators.length; ++i) {
                ILabelDecorator decorator = this.decorators[i];
                Image newImage = decorator.decorateImage(image, element);
                if (newImage == null) continue;
                image = newImage;
            }
            return image;
        }

        public String decorateText(String text, Object element) {
            for (int i = 0; i < this.decorators.length; ++i) {
                ILabelDecorator decorator = this.decorators[i];
                String newText = decorator.decorateText(text, element);
                if (newText == null) continue;
                text = newText;
            }
            return text;
        }

        public void dispose() {
            for (int i = 0; i < this.decorators.length; ++i) {
                ILabelDecorator d = this.decorators[i];
                d.dispose();
            }
        }
    }
}

