/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.ui.preferences.AbstractClasspathEntry;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.ClasspathEntry;
import org.eclipse.ant.internal.ui.preferences.GlobalClasspathEntries;
import org.eclipse.ant.internal.ui.preferences.IClasspathEntry;

public class ClasspathModel
extends AbstractClasspathEntry {
    public static final int ANT_HOME = 0;
    public static final int GLOBAL_USER = 1;
    public static final int USER = 2;
    private GlobalClasspathEntries antHomeEntry;
    private GlobalClasspathEntries userGlobalEntry;

    public Object addEntry(Object entry) {
        if (entry instanceof GlobalClasspathEntries) {
            if (!this.childEntries.contains(entry)) {
                this.childEntries.add(entry);
                return entry;
            }
            return null;
        }
        ClasspathEntry newEntry = this.createEntry(entry, null);
        Iterator entries = this.childEntries.iterator();
        while (entries.hasNext()) {
            Object element = entries.next();
            if (!(element instanceof GlobalClasspathEntries ? ((GlobalClasspathEntries)element).contains(newEntry) : element.equals(newEntry))) continue;
            return null;
        }
        this.childEntries.add(newEntry);
        return newEntry;
    }

    public Object addEntry(int entryType, Object entry) {
        GlobalClasspathEntries entryParent = null;
        switch (entryType) {
            case 0: {
                String name;
                if (this.antHomeEntry == null) {
                    name = AntPreferencesMessages.getString("ClasspathModel.2");
                    this.antHomeEntry = this.createGlobalEntry(new IAntClasspathEntry[0], name, false, true, 0);
                }
                entryParent = this.antHomeEntry;
                break;
            }
            case 1: {
                String name;
                if (this.userGlobalEntry == null) {
                    name = AntPreferencesMessages.getString("ClasspathModel.3");
                    this.userGlobalEntry = this.createGlobalEntry(new IAntClasspathEntry[0], name, true, true, 1);
                }
                entryParent = this.userGlobalEntry;
                break;
            }
        }
        ClasspathEntry newEntry = this.createEntry(entry, entryParent);
        Iterator entries = this.childEntries.iterator();
        while (entries.hasNext()) {
            Object element = entries.next();
            if (!(element instanceof GlobalClasspathEntries ? ((GlobalClasspathEntries)element).contains(newEntry) : element.equals(newEntry))) continue;
            return null;
        }
        if (entryParent != null) {
            entryParent.addEntry(newEntry);
        } else {
            this.childEntries.add(newEntry);
        }
        return newEntry;
    }

    public IAntClasspathEntry[] getEntries(int entryType) {
        switch (entryType) {
            case 0: {
                if (this.antHomeEntry == null) break;
                return this.antHomeEntry.getEntries();
            }
            case 1: {
                if (this.userGlobalEntry == null) break;
                return this.userGlobalEntry.getEntries();
            }
            case 2: {
                return this.getUserEntries();
            }
        }
        return new IAntClasspathEntry[0];
    }

    public void remove(Object entry) {
        this.childEntries.remove(entry);
        if (entry == this.userGlobalEntry) {
            this.userGlobalEntry = null;
        }
    }

    public ClasspathEntry createEntry(Object entry, IClasspathEntry entryParent) {
        if (entryParent == null) {
            entryParent = this;
        }
        return new ClasspathEntry(entry, entryParent);
    }

    public void removeAll() {
        if (this.antHomeEntry != null) {
            this.antHomeEntry.removeAll();
        }
        if (this.userGlobalEntry != null) {
            this.userGlobalEntry.removeAll();
        }
    }

    public void removeAll(int entryType) {
        switch (entryType) {
            case 0: {
                if (this.antHomeEntry == null) break;
                this.antHomeEntry.removeAll();
                break;
            }
            case 1: {
                if (this.userGlobalEntry == null) break;
                this.userGlobalEntry.removeAll();
                break;
            }
        }
    }

    public void removeAll(Object[] entries) {
        for (int i = 0; i < entries.length; ++i) {
            Object object = entries[i];
            if (object instanceof ClasspathEntry) {
                IClasspathEntry entryParent = ((ClasspathEntry)object).getParent();
                if (entryParent instanceof GlobalClasspathEntries) {
                    ((GlobalClasspathEntries)entryParent).removeEntry((ClasspathEntry)object);
                    continue;
                }
                this.remove(object);
                continue;
            }
            this.remove(object);
        }
    }

    public void setAntHomeEntries(IAntClasspathEntry[] entries) {
        if (this.antHomeEntry == null) {
            String name = AntPreferencesMessages.getString("ClasspathModel.2");
            this.antHomeEntry = this.createGlobalEntry(entries, name, false, true, 0);
        } else {
            this.antHomeEntry.removeAll();
            for (int i = 0; i < entries.length; ++i) {
                this.antHomeEntry.addEntry(new ClasspathEntry(entries[i], this.antHomeEntry));
            }
        }
    }

    private GlobalClasspathEntries createGlobalEntry(IAntClasspathEntry[] entries, String name, boolean canBeRemoved, boolean addEntry, int type) {
        GlobalClasspathEntries global = new GlobalClasspathEntries(name, this, canBeRemoved, type);
        for (int i = 0; i < entries.length; ++i) {
            global.addEntry(new ClasspathEntry(entries[i], global));
        }
        if (addEntry) {
            this.addEntry(global);
        }
        return global;
    }

    public void setGlobalEntries(IAntClasspathEntry[] entries) {
        if (this.userGlobalEntry == null) {
            String name = AntPreferencesMessages.getString("ClasspathModel.3");
            this.userGlobalEntry = this.createGlobalEntry(entries, name, true, true, 1);
        } else {
            this.userGlobalEntry.removeAll();
            for (int i = 0; i < entries.length; ++i) {
                this.userGlobalEntry.addEntry(new ClasspathEntry(entries[i], this.userGlobalEntry));
            }
        }
    }

    private IAntClasspathEntry[] getUserEntries() {
        ArrayList<IClasspathEntry> userEntries = new ArrayList<IClasspathEntry>(this.childEntries.size());
        Iterator itr = this.childEntries.iterator();
        while (itr.hasNext()) {
            IClasspathEntry element = (IClasspathEntry)itr.next();
            if (element instanceof GlobalClasspathEntries) continue;
            userEntries.add(element);
        }
        return userEntries.toArray(new IAntClasspathEntry[userEntries.size()]);
    }

    public String serializeClasspath(boolean defaultAntHome) {
        Iterator itr = this.childEntries.iterator();
        StringBuffer buff = new StringBuffer();
        while (itr.hasNext()) {
            IClasspathEntry element = (IClasspathEntry)itr.next();
            if (element instanceof GlobalClasspathEntries) {
                if (element == this.antHomeEntry) {
                    if (!defaultAntHome || !this.isSameAsDefaultAntHome()) {
                        IAntClasspathEntry[] antHomeEntries = this.antHomeEntry.getEntries();
                        for (int i = 0; i < antHomeEntries.length; ++i) {
                            IAntClasspathEntry entry = antHomeEntries[i];
                            buff.append('?');
                            buff.append(entry.toString());
                            buff.append(",");
                        }
                    } else {
                        buff.append("G");
                    }
                } else {
                    buff.append("UG");
                }
            } else {
                buff.append(element.toString());
            }
            buff.append(",");
        }
        if (buff.length() > 0) {
            return buff.substring(0, buff.length() - 1);
        }
        return "";
    }

    private boolean isSameAsDefaultAntHome() {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        IAntClasspathEntry[] defaultAntHomeEntries = prefs.getAntHomeClasspathEntries();
        IAntClasspathEntry[] antHomeEntries = this.antHomeEntry.getEntries();
        if (antHomeEntries.length != defaultAntHomeEntries.length) {
            return false;
        }
        for (int i = 0; i < antHomeEntries.length; ++i) {
            IAntClasspathEntry entry = antHomeEntries[i];
            IAntClasspathEntry defaultEntry = defaultAntHomeEntries[i];
            if (this.sameURL(entry, defaultEntry)) continue;
            return false;
        }
        return true;
    }

    private boolean sameURL(IAntClasspathEntry first, IAntClasspathEntry second) {
        if (first == null || second == null) {
            return false;
        }
        File newFile = new File(first.getEntryURL().getFile());
        File existingFile = new File(second.getEntryURL().getFile());
        return existingFile.equals(newFile);
    }

    public ClasspathModel(String serializedClasspath, boolean customAntHome) {
        StringTokenizer tokenizer = new StringTokenizer(serializedClasspath, ",");
        while (tokenizer.hasMoreTokens()) {
            String string = tokenizer.nextToken().trim();
            if (string.equals("G")) {
                IAntClasspathEntry[] antHomeEntries = new IAntClasspathEntry[]{};
                if (!customAntHome) {
                    antHomeEntries = AntCorePlugin.getPlugin().getPreferences().getAntHomeClasspathEntries();
                }
                this.setAntHomeEntries(antHomeEntries);
                continue;
            }
            if (string.equals("UG")) {
                this.setGlobalEntries(AntCorePlugin.getPlugin().getPreferences().getAdditionalClasspathEntries());
                continue;
            }
            boolean isAntHomeEntry = false;
            Object entry = null;
            if (string.charAt(0) == '*') {
                string = string.substring(1);
            }
            if (string.charAt(0) == '?') {
                string = string.substring(1);
                isAntHomeEntry = true;
            }
            try {
                entry = new URL("file:" + string);
            }
            catch (MalformedURLException e) {
                entry = string;
            }
            if (isAntHomeEntry) {
                this.addEntry(0, entry);
                continue;
            }
            this.addEntry(entry);
        }
    }

    public ClasspathModel() {
    }

    public Object[] getRemovedGlobalEntries() {
        if (this.userGlobalEntry == null) {
            String name = AntPreferencesMessages.getString("ClasspathModel.3");
            return new Object[]{this.createGlobalEntry(new IAntClasspathEntry[0], name, true, false, 1)};
        }
        return new Object[0];
    }

    public Object getAntHomeEntry() {
        return this.antHomeEntry;
    }
}

