/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.preferences.AddPropertyDialog;
import org.eclipse.ant.internal.ui.preferences.AntContentProvider;
import org.eclipse.ant.internal.ui.preferences.AntObjectLabelProvider;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.AntPropertiesFileSelectionDialog;
import org.eclipse.ant.internal.ui.preferences.IAntBlockContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AntPropertiesBlock {
    private IAntBlockContainer container;
    private Button editButton;
    private Button removeButton;
    private Button addButton;
    private Button addFileButton;
    private Button addExternalFileButton;
    private Button removeFileButton;
    private TableViewer propertyTableViewer;
    private TableViewer fileTableViewer;
    private final AntObjectLabelProvider labelProvider = new AntObjectLabelProvider();
    private IDialogSettings dialogSettings;
    private boolean tablesEnabled = true;
    private SelectionAdapter buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            if (event.widget == AntPropertiesBlock.this.addButton) {
                AntPropertiesBlock.this.addProperty();
            } else if (event.widget == AntPropertiesBlock.this.editButton) {
                AntPropertiesBlock.this.edit();
            } else if (event.widget == AntPropertiesBlock.this.removeButton) {
                AntPropertiesBlock.this.remove(AntPropertiesBlock.this.propertyTableViewer);
            } else if (event.widget == AntPropertiesBlock.this.addFileButton) {
                AntPropertiesBlock.this.addPropertyFile();
            } else if (event.widget == AntPropertiesBlock.this.addExternalFileButton) {
                AntPropertiesBlock.this.addExternalPropertyFile();
            } else if (event.widget == AntPropertiesBlock.this.removeFileButton) {
                AntPropertiesBlock.this.remove(AntPropertiesBlock.this.fileTableViewer);
            }
        }
    };
    private KeyAdapter keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent event) {
            if (event.getSource() == AntPropertiesBlock.this.propertyTableViewer) {
                if (AntPropertiesBlock.this.removeButton.isEnabled() && event.character == '\u007f' && event.stateMask == 0) {
                    AntPropertiesBlock.this.remove(AntPropertiesBlock.this.propertyTableViewer);
                }
            } else if (event.getSource() == AntPropertiesBlock.this.fileTableViewer && AntPropertiesBlock.this.removeFileButton.isEnabled() && event.character == '\u007f' && event.stateMask == 0) {
                AntPropertiesBlock.this.remove(AntPropertiesBlock.this.fileTableViewer);
            }
        }
    };
    private ISelectionChangedListener tableListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (AntPropertiesBlock.this.tablesEnabled) {
                if (event.getSource() == AntPropertiesBlock.this.propertyTableViewer) {
                    AntPropertiesBlock.this.propertyTableSelectionChanged((IStructuredSelection)event.getSelection());
                } else if (event.getSource() == AntPropertiesBlock.this.fileTableViewer) {
                    AntPropertiesBlock.this.fileTableSelectionChanged((IStructuredSelection)event.getSelection());
                }
            }
        }
    };

    public AntPropertiesBlock(IAntBlockContainer container) {
        this.container = container;
    }

    private void addPropertyFile() {
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        AntPropertiesFileSelectionDialog dialog = new AntPropertiesFileSelectionDialog(this.propertyTableViewer.getControl().getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp, Arrays.asList(this.getPropertyFiles()));
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            for (int i = 0; i < elements.length; ++i) {
                IFile file = (IFile)elements[i];
                String varExpression = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", file.getFullPath().toString());
                ((AntContentProvider)this.fileTableViewer.getContentProvider()).add(varExpression);
            }
            this.container.update();
        }
    }

    public void createControl(Composite top, String propertyLabel, String propertyFileLabel) {
        Font font = top.getFont();
        this.dialogSettings = AntUIPlugin.getDefault().getDialogSettings();
        Label label = new Label(top, 0);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label.setFont(font);
        label.setText(propertyLabel);
        this.propertyTableViewer = this.createTableViewer(top);
        this.propertyTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty() && AntPropertiesBlock.this.editButton.isEnabled()) {
                    AntPropertiesBlock.this.edit();
                }
            }
        });
        this.propertyTableViewer.getTable().addKeyListener((KeyListener)this.keyListener);
        this.createButtonGroup(top);
        label = new Label(top, 0);
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label.setFont(font);
        label.setText(propertyFileLabel);
        this.fileTableViewer = this.createTableViewer(top);
        this.fileTableViewer.getTable().addKeyListener((KeyListener)this.keyListener);
        this.createButtonGroup(top);
    }

    private void createButtonGroup(Composite top) {
        Composite buttonGroup = new Composite(top, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonGroup.setLayout((Layout)layout);
        buttonGroup.setLayoutData((Object)new GridData(1296));
        buttonGroup.setFont(top.getFont());
        this.addButtonsToButtonGroup(buttonGroup);
    }

    private TableViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 67586);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        table.setLayoutData((Object)data);
        table.setFont(parent.getFont());
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new AntContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        tableViewer.addSelectionChangedListener(this.tableListener);
        return tableViewer;
    }

    protected void addButtonsToButtonGroup(Composite parent) {
        if (this.editButton == null) {
            this.addButton = this.createPushButton(parent, AntPreferencesMessages.getString("AntPropertiesBlock.1"));
            this.editButton = this.createPushButton(parent, AntPreferencesMessages.getString("AntPropertiesBlock.2"));
            this.removeButton = this.createPushButton(parent, AntPreferencesMessages.getString("AntPropertiesBlock.3"));
        } else {
            this.addFileButton = this.createPushButton(parent, AntPreferencesMessages.getString("AntPropertiesBlock.4"));
            this.addExternalFileButton = this.createPushButton(parent, AntPreferencesMessages.getString("AntPropertiesBlock.14"));
            this.removeFileButton = this.createPushButton(parent, AntPreferencesMessages.getString("AntPropertiesBlock.removeFileButton"));
        }
    }

    private Button createPushButton(Composite parent, String label) {
        Button button = this.container.createPushButton(parent, label);
        button.addSelectionListener((SelectionListener)this.buttonListener);
        GridData gridData = new GridData(770);
        button.setLayoutData((Object)gridData);
        return button;
    }

    private void addExternalPropertyFile() {
        String lastUsedPath = this.dialogSettings.get("org.eclipse.ant.ui.lastextfile");
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(this.fileTableViewer.getControl().getShell(), 2);
        dialog.setFilterExtensions(new String[]{"*.properties", "*.*"});
        dialog.setFilterPath(lastUsedPath);
        String result = dialog.open();
        if (result == null) {
            return;
        }
        Path filterPath = new Path(dialog.getFilterPath());
        String[] results = dialog.getFileNames();
        for (int i = 0; i < results.length; ++i) {
            String fileName = results[i];
            IPath path = filterPath.append(fileName).makeAbsolute();
            ((AntContentProvider)this.fileTableViewer.getContentProvider()).add(path.toOSString());
        }
        this.dialogSettings.put("org.eclipse.ant.ui.lastextfile", filterPath.toOSString());
        this.container.update();
    }

    private void remove(TableViewer viewer) {
        AntContentProvider antContentProvider = (AntContentProvider)viewer.getContentProvider();
        IStructuredSelection sel = (IStructuredSelection)viewer.getSelection();
        antContentProvider.remove(sel);
        this.container.update();
    }

    private void addProperty() {
        String title = AntPreferencesMessages.getString("AntPropertiesBlock.Add_Property_2");
        AddPropertyDialog dialog = new AddPropertyDialog(this.propertyTableViewer.getControl().getShell(), title, new String[]{"", ""});
        if (dialog.open() == 1) {
            return;
        }
        String[] pair = dialog.getNameValuePair();
        String name = pair[0];
        if (!this.overwrite(name)) {
            return;
        }
        Property prop = new Property();
        prop.setName(name);
        prop.setValue(pair[1]);
        ((AntContentProvider)this.propertyTableViewer.getContentProvider()).add(prop);
        this.container.update();
    }

    private void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.propertyTableViewer.getSelection();
        Property prop = (Property)selection.getFirstElement();
        String originalName = prop.getName();
        String title = AntPreferencesMessages.getString("AntPropertiesBlock.Edit_User_Property_5");
        AddPropertyDialog dialog = new AddPropertyDialog(this.propertyTableViewer.getControl().getShell(), title, new String[]{prop.getName(), prop.getValue(false)});
        if (dialog.open() == 1) {
            return;
        }
        String[] pair = dialog.getNameValuePair();
        String name = pair[0];
        if (!name.equals(originalName) && !this.overwrite(name)) {
            return;
        }
        prop.setName(name);
        prop.setValue(pair[1]);
        this.propertyTableViewer.refresh();
        this.container.update();
    }

    private boolean overwrite(String name) {
        Object[] properties = this.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            Property property = (Property)properties[i];
            String propertyName = property.getName();
            if (!propertyName.equals(name)) continue;
            if (property.isDefault()) {
                MessageDialog.openError((Shell)this.propertyTableViewer.getControl().getShell(), (String)AntPreferencesMessages.getString("AntPropertiesBlock.17"), (String)MessageFormat.format(AntPreferencesMessages.getString("AntPropertiesBlock.18"), propertyName, property.getPluginLabel()));
                return false;
            }
            boolean overWrite = MessageDialog.openQuestion((Shell)this.propertyTableViewer.getControl().getShell(), (String)AntPreferencesMessages.getString("AntPropertiesBlock.15"), (String)MessageFormat.format(AntPreferencesMessages.getString("AntPropertiesBlock.16"), name));
            if (!overWrite) {
                return false;
            }
            ((AntContentProvider)this.propertyTableViewer.getContentProvider()).remove(property);
            break;
        }
        return true;
    }

    private void fileTableSelectionChanged(IStructuredSelection newSelection) {
        this.removeFileButton.setEnabled(newSelection.size() > 0);
    }

    private void propertyTableSelectionChanged(IStructuredSelection newSelection) {
        int size = newSelection.size();
        boolean enabled = true;
        Iterator itr = newSelection.iterator();
        while (itr.hasNext()) {
            Property property;
            Object element = itr.next();
            if (!(element instanceof Property) || !(property = (Property)element).isDefault()) continue;
            enabled = false;
            break;
        }
        this.editButton.setEnabled(enabled && size == 1);
        this.removeButton.setEnabled(enabled && size > 0);
    }

    public void populatePropertyViewer(Map properties) {
        if (properties == null) {
            this.propertyTableViewer.setInput((Object)new Property[0]);
            return;
        }
        Property[] result = new Property[properties.size()];
        Iterator entries = properties.entrySet().iterator();
        int i = 0;
        while (entries.hasNext()) {
            Map.Entry element = entries.next();
            Property property = new Property();
            property.setName((String)element.getKey());
            property.setValue((String)element.getValue());
            result[i] = property;
            ++i;
        }
        this.propertyTableViewer.setInput((Object)result);
    }

    public void setPropertiesInput(Property[] properties) {
        this.propertyTableViewer.setInput((Object)properties);
    }

    public void setPropertyFilesInput(String[] files) {
        this.fileTableViewer.setInput((Object)files);
    }

    public void update() {
        this.propertyTableSelectionChanged((IStructuredSelection)this.propertyTableViewer.getSelection());
        this.fileTableSelectionChanged((IStructuredSelection)this.fileTableViewer.getSelection());
    }

    public Object[] getProperties() {
        return ((AntContentProvider)this.propertyTableViewer.getContentProvider()).getElements(null);
    }

    public Object[] getPropertyFiles() {
        return ((AntContentProvider)this.fileTableViewer.getContentProvider()).getElements(null);
    }

    public void setEnabled(boolean enable) {
        this.setTablesEnabled(enable);
        this.addButton.setEnabled(enable);
        this.addExternalFileButton.setEnabled(enable);
        this.addFileButton.setEnabled(enable);
        this.editButton.setEnabled(enable);
        this.removeButton.setEnabled(enable);
        this.removeFileButton.setEnabled(enable);
        if (enable) {
            this.propertyTableViewer.setSelection(this.propertyTableViewer.getSelection());
            this.fileTableViewer.setSelection(this.fileTableViewer.getSelection());
        } else {
            AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
            List properties = prefs.getProperties();
            this.propertyTableViewer.setInput((Object)properties);
            this.fileTableViewer.setInput((Object)prefs.getCustomPropertyFiles(false));
        }
    }

    public void setTablesEnabled(boolean tablesEnabled) {
        this.tablesEnabled = tablesEnabled;
    }
}

