/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.core.TargetInfo;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class AntTargetContentProvider
implements IStructuredContentProvider {
    protected List elements = new ArrayList();
    protected TableViewer viewer;
    private boolean fFilterInternalTargets = false;
    private int fNumFilteredTargets = 0;
    private int fNumTotalTargets = 0;

    public void add(Object o) {
        this.elements.add(o);
        this.viewer.add(o);
    }

    public void addAll(List list) {
        this.elements.addAll(list);
        this.viewer.add(list.toArray());
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        this.fNumTotalTargets = this.elements.size();
        this.fNumFilteredTargets = 0;
        if (this.fNumTotalTargets == 0) {
            return new Object[0];
        }
        if (!this.fFilterInternalTargets) {
            return this.elements.toArray(new Object[this.fNumTotalTargets]);
        }
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            if (!this.isInternal((TargetInfo)iter.next())) continue;
            ++this.fNumFilteredTargets;
        }
        Object[] targets = new Object[this.getNumTargets()];
        iter = this.elements.iterator();
        int i = 0;
        while (iter.hasNext()) {
            TargetInfo target = (TargetInfo)iter.next();
            if (this.isInternal(target)) continue;
            targets[i++] = target;
        }
        return targets;
    }

    public boolean isInternal(TargetInfo target) {
        return !target.isDefault() && target.getDescription() == null;
    }

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        this.viewer = (TableViewer)newViewer;
        this.elements.clear();
        if (newInput != null && ((Object[])newInput).length != 0) {
            this.elements.addAll(Arrays.asList((Object[])newInput));
        }
    }

    public void removeTarget(Object target) {
        this.elements.remove(target);
        this.viewer.remove(target);
    }

    public void moveUpTarget(int index) {
        Object target = this.elements.get(index);
        if (index == 0 || target == null) {
            return;
        }
        this.elements.set(index, this.elements.get(index - 1));
        this.elements.set(index - 1, target);
    }

    public void moveDownTarget(int index) {
        Object target = this.elements.get(index);
        if (index == this.elements.size() - 1 || target == null) {
            return;
        }
        this.elements.set(index, this.elements.get(index + 1));
        this.elements.set(index + 1, target);
    }

    public int getNumFiltered() {
        return this.fNumFilteredTargets;
    }

    public int getNumTargets() {
        return this.fNumTotalTargets - this.fNumFilteredTargets;
    }

    public void setFilterInternalTargets(boolean filter) {
        this.fFilterInternalTargets = filter;
    }
}

