/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.search.internal.core.text.IMatchCollector;
import org.eclipse.search.internal.ui.SearchMessages;

public class MatchLocator {
    protected static final int fgLF = 10;
    protected static final int fgCR = 13;
    private Matcher fMatcher;
    protected int fPushbackChar;
    protected boolean fPushback;
    private String fPattern;

    public MatchLocator(String pattern, boolean isCaseSensitive, boolean isRegexSearch) throws PatternSyntaxException {
        this.fPattern = pattern;
        if (!isRegexSearch) {
            pattern = this.asRegEx(pattern);
        }
        Pattern regExPattern = !isCaseSensitive ? Pattern.compile(pattern, 66) : Pattern.compile(pattern);
        this.fMatcher = regExPattern.matcher("");
    }

    public boolean isEmtpy() {
        return this.getPattern().length() == 0;
    }

    public String getPattern() {
        return this.fPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locateMatches(IProgressMonitor monitor, Reader reader, IMatchCollector collector) throws IOException, InvocationTargetException {
        int lineCounter = 1;
        int charCounter = 0;
        boolean eof = false;
        try {
            while (!eof) {
                StringBuffer sb = new StringBuffer(200);
                int eolStrLength = this.readLine(reader, sb);
                int lineLength = sb.length();
                int start = 0;
                eof = eolStrLength == -1;
                String line = sb.toString();
                while (start < lineLength) {
                    this.fMatcher.reset(line);
                    if (this.fMatcher.find(start)) {
                        start = charCounter + this.fMatcher.start();
                        int length = this.fMatcher.end() - this.fMatcher.start();
                        collector.accept(line.trim(), start, length, lineCounter);
                        start = this.fMatcher.end();
                        continue;
                    }
                    start = lineLength;
                }
                charCounter += lineLength + eolStrLength;
                ++lineCounter;
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException(SearchMessages.getString("TextSearchVisitor.canceled"));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private String asRegEx(String pattern) {
        StringBuffer out = new StringBuffer(pattern.length());
        boolean escaped = false;
        boolean quoting = false;
        int i = 0;
        while (i < pattern.length()) {
            char ch;
            if ((ch = pattern.charAt(i++)) == '*' && !escaped) {
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append(".*");
                escaped = false;
                continue;
            }
            if (ch == '?' && !escaped) {
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append(".");
                escaped = false;
                continue;
            }
            if (ch == '\\' && !escaped) {
                escaped = true;
                continue;
            }
            if (ch == '\\' && escaped) {
                escaped = false;
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append("\\\\");
                continue;
            }
            if (!quoting) {
                out.append("\\Q");
                quoting = true;
            }
            if (escaped && ch != '*' && ch != '?' && ch != '\\') {
                out.append('\\');
            }
            out.append(ch);
            escaped = ch == '\\';
        }
        if (quoting) {
            out.append("\\E");
        }
        return out.toString();
    }

    protected int readLine(Reader reader, StringBuffer sb) throws IOException {
        int ch = -1;
        if (this.fPushback) {
            ch = this.fPushbackChar;
            this.fPushback = false;
        } else {
            ch = reader.read();
        }
        while (ch >= 0) {
            if (ch == 10) {
                return 1;
            }
            if (ch == 13) {
                ch = reader.read();
                if (ch == 10) {
                    return 2;
                }
                this.fPushbackChar = ch;
                this.fPushback = true;
                return 1;
            }
            sb.append((char)ch);
            ch = reader.read();
        }
        return -1;
    }
}

