/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.JREResolution;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.launching.JREContainer;
import org.eclipse.jdt.internal.launching.JREContainerInitializer;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class SelectSystemLibraryQuickFix
extends JREResolution {
    private IPath fUnboundPath;
    private IJavaProject fProject;

    public SelectSystemLibraryQuickFix(IPath unboundPath, IJavaProject project) {
        this.fUnboundPath = unboundPath;
        this.fProject = project;
    }

    public void run(IMarker marker) {
        try {
            this.handleContainerResolutionError(this.fUnboundPath, this.fProject);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.errorDialog(LauncherMessages.getString("JREContainerResolution.Unable_to_update_classpath_1"), e.getStatus());
        }
    }

    protected void handleContainerResolutionError(final IPath unboundPath, final IJavaProject project) throws CoreException {
        String title = LauncherMessages.getString("JREResolution.Select_System_Library_1");
        String message = MessageFormat.format(LauncherMessages.getString("JREResolution.Select_a_system_library_to_use_when_building_{0}_2"), project.getElementName());
        final IVMInstall vm = this.chooseVMInstall(title, message);
        if (vm == null) {
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                String vmTypeId = vm.getVMInstallType().getId();
                String vmName = vm.getName();
                String prevId = JREContainerInitializer.getVMTypeId((IPath)unboundPath);
                String prevName = JREContainerInitializer.getVMName((IPath)unboundPath);
                try {
                    IPath newBinding = unboundPath;
                    if (!prevId.equals(vmTypeId) || !prevName.equals(vmName)) {
                        Path newPath = new Path(JavaRuntime.JRE_CONTAINER);
                        if (vmTypeId != null) {
                            newPath = newPath.append(vmTypeId).append(vmName);
                        }
                        IClasspathEntry[] classpath = project.getRawClasspath();
                        block5: for (int i = 0; i < classpath.length; ++i) {
                            switch (classpath[i].getEntryKind()) {
                                case 5: {
                                    if (!classpath[i].getPath().equals(unboundPath)) continue block5;
                                    classpath[i] = JavaCore.newContainerEntry((IPath)newPath, (boolean)classpath[i].isExported());
                                    continue block5;
                                }
                            }
                        }
                        project.setRawClasspath(classpath, monitor);
                        newBinding = newPath;
                    }
                    JavaCore.setClasspathContainer((IPath)unboundPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{new JREContainer(vm, newBinding)}, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                throw (CoreException)e.getTargetException();
            }
            throw new CoreException((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, LauncherMessages.getString("JREContainerResolution.An_exception_occurred_while_updating_the_classpath._1"), e.getTargetException()));
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public String getLabel() {
        return MessageFormat.format(LauncherMessages.getString("JREContainerResolution.Select_a_system_library_to_use_when_building_{0}_2"), this.fProject.getElementName());
    }
}

