/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ArchiveFileFilter
extends ViewerFilter {
    private static final String[] fgArchiveExtensions = new String[]{"jar", "zip"};
    private List fExcludes;

    public ArchiveFileFilter(IFile[] excludedFiles) {
        this.fExcludes = excludedFiles != null ? Arrays.asList(excludedFiles) : null;
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            if (this.fExcludes != null && this.fExcludes.contains(element)) {
                return false;
            }
            return ArchiveFileFilter.isArchivePath(((IFile)element).getFullPath());
        }
        if (element instanceof IContainer) {
            try {
                IResource[] resources = ((IContainer)element).members();
                for (int i = 0; i < resources.length; ++i) {
                    if (!this.select(viewer, parent, resources[i])) continue;
                    return true;
                }
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e.getStatus());
            }
        }
        return false;
    }

    public static boolean isArchivePath(IPath path) {
        String ext = path.getFileExtension();
        if (ext != null && ext.length() != 0) {
            for (int i = 0; i < fgArchiveExtensions.length; ++i) {
                if (!ext.equalsIgnoreCase(fgArchiveExtensions[i])) continue;
                return true;
            }
        }
        return false;
    }
}

