/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ProjectSelectionDialog;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class AddProjectAction
extends RuntimeClasspathAction {
    public AddProjectAction(IClasspathViewer viewer) {
        super(ActionMessages.getString("AddProjectAction.Add_Project_1"), viewer);
    }

    public void run() {
        List projects = this.getPossibleAdditions();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ContentProvider content = new ContentProvider(projects);
        ProjectSelectionDialog dialog = new ProjectSelectionDialog(this.getShell(), projects, content, (ILabelProvider)labelProvider, ActionMessages.getString("AddProjectAction.Choose_&project(s)_to_add__3"));
        dialog.setTitle(ActionMessages.getString("AddProjectAction.Project_Selection_2"));
        MultiStatus status = new MultiStatus(JDIDebugUIPlugin.getUniqueIdentifier(), 150, ActionMessages.getString("AddProjectAction.One_or_more_exceptions_occurred_while_adding_projects._1"), null);
        if (dialog.open() == 0) {
            Object[] selections = dialog.getResult();
            ArrayList<IJavaProject> additions = new ArrayList<IJavaProject>(selections.length);
            try {
                for (int i = 0; i < selections.length; ++i) {
                    IJavaProject jp = (IJavaProject)selections[i];
                    if (dialog.isAddRequiredProjects()) {
                        this.collectRequiredProjects(jp, additions);
                        continue;
                    }
                    additions.add(jp);
                }
            }
            catch (JavaModelException e) {
                status.add(e.getStatus());
            }
            ArrayList<IRuntimeClasspathEntry> runtimeEntries = new ArrayList<IRuntimeClasspathEntry>(additions.size());
            Iterator iter = additions.iterator();
            while (iter.hasNext()) {
                IJavaProject jp = (IJavaProject)iter.next();
                runtimeEntries.add(JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)jp));
                if (!dialog.isAddExportedEntries()) continue;
                try {
                    this.collectExportedEntries(jp, runtimeEntries);
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                }
            }
            IRuntimeClasspathEntry[] entries = runtimeEntries.toArray(new IRuntimeClasspathEntry[runtimeEntries.size()]);
            this.getViewer().addEntries(entries);
        }
        content.dispose();
        labelProvider.dispose();
        if (!status.isOK()) {
            JDIDebugUIPlugin.errorDialog(status.getMessage(), (IStatus)status);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return this.getViewer().updateSelection(this.getActionType(), selection) && !this.getPossibleAdditions().isEmpty();
    }

    protected int getActionType() {
        return 1;
    }

    protected List getPossibleAdditions() {
        IJavaProject[] projects;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            projects = JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
            projects = new IJavaProject[]{};
        }
        ArrayList<IJavaProject> remaining = new ArrayList<IJavaProject>();
        for (int i = 0; i < projects.length; ++i) {
            remaining.add(projects[i]);
        }
        ArrayList<IJavaProject> alreadySelected = new ArrayList<IJavaProject>();
        IRuntimeClasspathEntry[] entries = this.getViewer().getEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].getType() != 1) continue;
            IResource res = root.findMember(entries[i].getPath());
            IJavaProject jp = (IJavaProject)JavaCore.create((IResource)res);
            alreadySelected.add(jp);
        }
        remaining.removeAll(alreadySelected);
        return remaining;
    }

    protected void collectRequiredProjects(IJavaProject proj, List res) throws JavaModelException {
        if (!res.contains(proj)) {
            res.add(proj);
            IJavaModel model = proj.getJavaModel();
            IClasspathEntry[] entries = proj.getRawClasspath();
            for (int i = 0; i < entries.length; ++i) {
                IJavaProject ref;
                IClasspathEntry curr = entries[i];
                if (curr.getEntryKind() != 2 || !(ref = model.getJavaProject(curr.getPath().segment(0))).exists()) continue;
                this.collectRequiredProjects(ref, res);
            }
        }
    }

    protected void collectExportedEntries(IJavaProject proj, List runtimeEntries) throws CoreException {
        IClasspathEntry[] entries = proj.getRawClasspath();
        for (int i = 0; i < entries.length; ++i) {
            IClasspathEntry entry = entries[i];
            if (!entry.isExported()) continue;
            IRuntimeClasspathEntry rte = null;
            switch (entry.getEntryKind()) {
                case 5: {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)proj);
                    int kind = 0;
                    switch (container.getKind()) {
                        case 1: {
                            kind = 3;
                            break;
                        }
                        case 2: {
                            kind = 2;
                            break;
                        }
                        case 3: {
                            kind = 1;
                        }
                    }
                    rte = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)entry.getPath(), (int)kind, (IJavaProject)proj);
                    break;
                }
                case 1: {
                    rte = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)entry.getPath());
                    rte.setSourceAttachmentPath(entry.getSourceAttachmentPath());
                    rte.setSourceAttachmentRootPath(entry.getSourceAttachmentRootPath());
                    break;
                }
                case 2: {
                    IJavaProject jp;
                    String name = entry.getPath().segment(0);
                    IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                    if (!p.exists() || !(jp = JavaCore.create((IProject)p)).exists()) break;
                    rte = JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)jp);
                    break;
                }
                case 4: {
                    rte = JavaRuntime.newVariableRuntimeClasspathEntry((IPath)entry.getPath());
                    break;
                }
            }
            if (rte == null || runtimeEntries.contains(rte)) continue;
            runtimeEntries.add(rte);
        }
    }

    class ContentProvider
    implements IStructuredContentProvider {
        private List fProjects;

        public ContentProvider(List projects) {
            this.fProjects = projects;
        }

        public Object[] getElements(Object inputElement) {
            return this.fProjects.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

