/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.DetailFormatterDialog;
import org.eclipse.jdt.internal.debug.ui.display.DisplayCompletionProcessor;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class DetailFormatterCompletionProcessor
extends DisplayCompletionProcessor {
    private DetailFormatterDialog fDetailFormatDialog;

    public DetailFormatterCompletionProcessor(DetailFormatterDialog detailFormatDialog) {
        this.fDetailFormatDialog = detailFormatDialog;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        IType receivingType = this.fDetailFormatDialog.getType();
        if (receivingType == null) {
            return new ICompletionProposal[0];
        }
        IJavaProject project = receivingType.getJavaProject();
        try {
            ITextSelection textSelection = (ITextSelection)viewer.getSelectionProvider().getSelection();
            this.configureResultCollector(project, textSelection);
            receivingType.codeComplete(viewer.getDocument().get().toCharArray(), -1, documentOffset, (char[][])new char[0][], (char[][])new char[0][], new int[0], false, (ICompletionRequestor)this.getCollector());
            JavaCompletionProposal[] results = this.getCollector().getResults();
            TemplateEngine templateEngine = this.getTemplateEngine();
            if (templateEngine != null) {
                templateEngine.reset();
                templateEngine.complete(viewer, documentOffset, null);
                TemplateProposal[] templateResults = templateEngine.getResults();
                IJavaCompletionProposal[] total = new IJavaCompletionProposal[results.length + templateResults.length];
                System.arraycopy(templateResults, 0, total, 0, templateResults.length);
                System.arraycopy(results, 0, total, templateResults.length, results.length);
                results = total;
            }
            return this.order((IJavaCompletionProposal[])results);
        }
        catch (JavaModelException x) {
            this.handle(viewer, (CoreException)((Object)x));
            return null;
        }
    }
}

