/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.jdt.internal.core.hierarchy.RegionBasedTypeHierarchy;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;

public class RegionBasedHierarchyBuilder
extends HierarchyBuilder {
    public RegionBasedHierarchyBuilder(TypeHierarchy hierarchy) throws JavaModelException {
        super(hierarchy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(boolean computeSubtypes) {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            manager.cacheZipFiles();
            if (this.hierarchy.focusType == null || computeSubtypes) {
                SubProgressMonitor typeInRegionMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, 30);
                ArrayList allOpenablesInRegion = this.determineOpenablesInRegion((IProgressMonitor)typeInRegionMonitor);
                this.hierarchy.initialize(allOpenablesInRegion.size());
                SubProgressMonitor buildMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, 70);
                this.createTypeHierarchyBasedOnRegion(allOpenablesInRegion, (IProgressMonitor)buildMonitor);
                ((RegionBasedTypeHierarchy)this.hierarchy).pruneDeadBranches();
            } else {
                this.hierarchy.initialize(1);
                this.buildSupertypes();
            }
        }
        finally {
            manager.flushZipFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTypeHierarchyBasedOnRegion(ArrayList allOpenablesInRegion, IProgressMonitor monitor) {
        int size = allOpenablesInRegion.size();
        if (size != 0) {
            this.infoToHandle = new HashMap(size);
        }
        Openable[] openables = new Openable[size];
        allOpenablesInRegion.toArray(openables);
        try {
            if (monitor != null) {
                monitor.beginTask("", size * 2);
            }
            if (size > 0) {
                this.hierarchyResolver.resolve(openables, null, monitor);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList determineOpenablesInRegion(IProgressMonitor monitor) {
        try {
            ArrayList<IJavaElement> openables = new ArrayList<IJavaElement>();
            IJavaElement[] roots = ((RegionBasedTypeHierarchy)this.hierarchy).region.getElements();
            int length = roots.length;
            if (monitor != null) {
                monitor.beginTask("", length);
            }
            for (int i = 0; i < length; ++i) {
                IJavaElement root = roots[i];
                switch (root.getElementType()) {
                    case 2: {
                        this.injectAllOpenablesForJavaProject((IJavaProject)root, openables);
                        break;
                    }
                    case 3: {
                        this.injectAllOpenablesForPackageFragmentRoot((IPackageFragmentRoot)root, openables);
                        break;
                    }
                    case 4: {
                        this.injectAllOpenablesForPackageFragment((IPackageFragment)root, openables);
                        break;
                    }
                    case 5: 
                    case 6: {
                        openables.add(root);
                        break;
                    }
                    case 7: {
                        IType type = (IType)root;
                        if (type.isBinary()) {
                            openables.add(type.getClassFile());
                            break;
                        }
                        openables.add(type.getCompilationUnit());
                        break;
                    }
                }
                this.worked(monitor, 1);
            }
            ArrayList<IJavaElement> arrayList = openables;
            return arrayList;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void injectAllOpenablesForJavaProject(IJavaProject project, ArrayList openables) {
        try {
            IPackageFragmentRoot[] devPathRoots = ((JavaProject)project).getPackageFragmentRoots();
            if (devPathRoots == null) {
                return;
            }
            for (int j = 0; j < devPathRoots.length; ++j) {
                IPackageFragmentRoot root = devPathRoots[j];
                this.injectAllOpenablesForPackageFragmentRoot(root, openables);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void injectAllOpenablesForPackageFragment(IPackageFragment packFrag, ArrayList openables) {
        try {
            IPackageFragmentRoot root = (IPackageFragmentRoot)packFrag.getParent();
            int kind = root.getKind();
            if (kind != 0) {
                boolean isSourcePackageFragment;
                boolean bl = isSourcePackageFragment = kind == 1;
                if (isSourcePackageFragment) {
                    ICompilationUnit[] cus = packFrag.getCompilationUnits();
                    int length = cus.length;
                    for (int i = 0; i < length; ++i) {
                        openables.add(cus[i]);
                    }
                } else {
                    IClassFile[] classFiles = packFrag.getClassFiles();
                    int length = classFiles.length;
                    for (int i = 0; i < length; ++i) {
                        openables.add(classFiles[i]);
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void injectAllOpenablesForPackageFragmentRoot(IPackageFragmentRoot root, ArrayList openables) {
        try {
            IJavaElement[] packFrags = root.getChildren();
            for (int k = 0; k < packFrags.length; ++k) {
                IPackageFragment packFrag = (IPackageFragment)packFrags[k];
                this.injectAllOpenablesForPackageFragment(packFrag, openables);
            }
        }
        catch (JavaModelException e) {
            return;
        }
    }
}

