/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.DeltaProcessor;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.util.Util;

public class DeltaProcessingState
implements IResourceChangeListener {
    public IElementChangedListener[] elementChangedListeners = new IElementChangedListener[5];
    public int[] elementChangedListenerMasks = new int[5];
    public int elementChangedListenerCount = 0;
    public IResourceChangeListener[] preResourceChangeListeners = new IResourceChangeListener[1];
    public int preResourceChangeListenerCount = 0;
    private ThreadLocal deltaProcessors = new ThreadLocal();
    public HashMap roots = new HashMap();
    public HashMap otherRoots = new HashMap();
    public HashMap oldRoots = new HashMap();
    public HashMap oldOtherRoots = new HashMap();
    public HashMap sourceAttachments = new HashMap();
    public boolean rootsAreStale = true;
    private Set initializingThreads = Collections.synchronizedSet(new HashSet());
    public Hashtable externalTimeStamps = new Hashtable();
    public HashMap projectUpdates = new HashMap();
    public IJavaProject[] modelProjectsCache;

    public void addElementChangedListener(IElementChangedListener listener, int eventMask) {
        for (int i = 0; i < this.elementChangedListenerCount; ++i) {
            if (!this.elementChangedListeners[i].equals(listener)) continue;
            int cloneLength = this.elementChangedListenerMasks.length;
            this.elementChangedListenerMasks = new int[cloneLength];
            System.arraycopy(this.elementChangedListenerMasks, 0, this.elementChangedListenerMasks, 0, cloneLength);
            this.elementChangedListenerMasks[i] = eventMask;
            return;
        }
        int length = this.elementChangedListeners.length;
        if (length == this.elementChangedListenerCount) {
            this.elementChangedListeners = new IElementChangedListener[length * 2];
            System.arraycopy(this.elementChangedListeners, 0, this.elementChangedListeners, 0, length);
            this.elementChangedListenerMasks = new int[length * 2];
            System.arraycopy(this.elementChangedListenerMasks, 0, this.elementChangedListenerMasks, 0, length);
        }
        this.elementChangedListeners[this.elementChangedListenerCount] = listener;
        this.elementChangedListenerMasks[this.elementChangedListenerCount] = eventMask;
        ++this.elementChangedListenerCount;
    }

    public void addPreResourceChangedListener(IResourceChangeListener listener) {
        for (int i = 0; i < this.preResourceChangeListenerCount; ++i) {
            if (!this.preResourceChangeListeners[i].equals(listener)) continue;
            return;
        }
        int length = this.preResourceChangeListeners.length;
        if (length == this.preResourceChangeListenerCount) {
            this.preResourceChangeListeners = new IResourceChangeListener[length * 2];
            System.arraycopy(this.preResourceChangeListeners, 0, this.preResourceChangeListeners, 0, length);
        }
        this.preResourceChangeListeners[this.preResourceChangeListenerCount] = listener;
        ++this.preResourceChangeListenerCount;
    }

    public DeltaProcessor getDeltaProcessor() {
        DeltaProcessor deltaProcessor = (DeltaProcessor)this.deltaProcessors.get();
        if (deltaProcessor != null) {
            return deltaProcessor;
        }
        deltaProcessor = new DeltaProcessor(this, JavaModelManager.getJavaModelManager());
        this.deltaProcessors.set(deltaProcessor);
        return deltaProcessor;
    }

    public void performClasspathResourceChange(JavaProject project, IClasspathEntry[] oldResolvedPath, IClasspathEntry[] newResolvedPath, IClasspathEntry[] newRawPath, boolean canChangeResources) throws JavaModelException {
        ProjectUpdateInfo info = new ProjectUpdateInfo();
        info.project = project;
        info.oldResolvedPath = oldResolvedPath;
        info.newResolvedPath = newResolvedPath;
        info.newRawPath = newRawPath;
        if (canChangeResources) {
            this.projectUpdates.remove(project);
            info.updateProjectReferencesIfNecessary();
            return;
        }
        this.recordProjectUpdate(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeRoots() {
        HashMap<IPath, DeltaProcessor.RootInfo> newRoots = null;
        HashMap<IPath, ArrayList<DeltaProcessor.RootInfo>> newOtherRoots = null;
        HashMap<IPath, IPath> newSourceAttachments = null;
        if (this.rootsAreStale) {
            Thread currentThread = Thread.currentThread();
            boolean addedCurrentThread = false;
            try {
                IJavaProject[] projects;
                if (!this.initializingThreads.add(currentThread)) {
                    return;
                }
                addedCurrentThread = true;
                newRoots = new HashMap<IPath, DeltaProcessor.RootInfo>();
                newOtherRoots = new HashMap<IPath, ArrayList<DeltaProcessor.RootInfo>>();
                newSourceAttachments = new HashMap<IPath, IPath>();
                JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
                try {
                    projects = model.getJavaProjects();
                }
                catch (JavaModelException e) {
                    if (addedCurrentThread) {
                        this.initializingThreads.remove(currentThread);
                    }
                    return;
                }
                int length = projects.length;
                for (int i = 0; i < length; ++i) {
                    IClasspathEntry[] classpath;
                    JavaProject project = (JavaProject)projects[i];
                    try {
                        classpath = project.getResolvedClasspath(true, false, false);
                    }
                    catch (JavaModelException e) {
                        continue;
                    }
                    int classpathLength = classpath.length;
                    for (int j = 0; j < classpathLength; ++j) {
                        int index;
                        IClasspathEntry entry = classpath[j];
                        if (entry.getEntryKind() == 2) continue;
                        IPath path = entry.getPath();
                        if (newRoots.get(path) == null) {
                            newRoots.put(path, new DeltaProcessor.RootInfo(project, path, ((ClasspathEntry)entry).fullInclusionPatternChars(), ((ClasspathEntry)entry).fullExclusionPatternChars(), entry.getEntryKind()));
                        } else {
                            ArrayList<DeltaProcessor.RootInfo> rootList = (ArrayList<DeltaProcessor.RootInfo>)newOtherRoots.get(path);
                            if (rootList == null) {
                                rootList = new ArrayList<DeltaProcessor.RootInfo>();
                                newOtherRoots.put(path, rootList);
                            }
                            rootList.add(new DeltaProcessor.RootInfo(project, path, ((ClasspathEntry)entry).fullInclusionPatternChars(), ((ClasspathEntry)entry).fullExclusionPatternChars(), entry.getEntryKind()));
                        }
                        if (entry.getEntryKind() != 1) continue;
                        QualifiedName qName = new QualifiedName("org.eclipse.jdt.core", "sourceattachment: " + path.toOSString());
                        String propertyString = null;
                        try {
                            propertyString = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(qName);
                        }
                        catch (CoreException e) {
                            continue;
                        }
                        Object sourceAttachmentPath = propertyString != null ? ((index = propertyString.lastIndexOf(42)) < 0 ? new Path(propertyString) : new Path(propertyString.substring(0, index))) : entry.getSourceAttachmentPath();
                        if (sourceAttachmentPath == null) continue;
                        newSourceAttachments.put((IPath)sourceAttachmentPath, path);
                    }
                }
            }
            finally {
                if (addedCurrentThread) {
                    this.initializingThreads.remove(currentThread);
                }
            }
        }
        DeltaProcessingState deltaProcessingState = this;
        synchronized (deltaProcessingState) {
            this.oldRoots = this.roots;
            this.oldOtherRoots = this.otherRoots;
            if (this.rootsAreStale && newRoots != null) {
                this.roots = newRoots;
                this.otherRoots = newOtherRoots;
                this.sourceAttachments = newSourceAttachments;
                this.rootsAreStale = false;
            }
        }
    }

    public synchronized void recordProjectUpdate(ProjectUpdateInfo newInfo) {
        JavaProject project = newInfo.project;
        ProjectUpdateInfo oldInfo = (ProjectUpdateInfo)this.projectUpdates.get(project);
        if (oldInfo != null) {
            oldInfo.newRawPath = newInfo.newRawPath;
            oldInfo.newResolvedPath = newInfo.newResolvedPath;
        } else {
            this.projectUpdates.put(project, newInfo);
        }
    }

    public synchronized ProjectUpdateInfo[] removeAllProjectUpdates() {
        int length = this.projectUpdates.size();
        if (length == 0) {
            return null;
        }
        ProjectUpdateInfo[] updates = new ProjectUpdateInfo[length];
        this.projectUpdates.values().toArray(updates);
        this.projectUpdates.clear();
        return updates;
    }

    public void removeElementChangedListener(IElementChangedListener listener) {
        for (int i = 0; i < this.elementChangedListenerCount; ++i) {
            if (!this.elementChangedListeners[i].equals(listener)) continue;
            int length = this.elementChangedListeners.length;
            IElementChangedListener[] newListeners = new IElementChangedListener[length];
            System.arraycopy(this.elementChangedListeners, 0, newListeners, 0, i);
            int[] newMasks = new int[length];
            System.arraycopy(this.elementChangedListenerMasks, 0, newMasks, 0, i);
            int trailingLength = this.elementChangedListenerCount - i - 1;
            if (trailingLength > 0) {
                System.arraycopy(this.elementChangedListeners, i + 1, newListeners, i, trailingLength);
                System.arraycopy(this.elementChangedListenerMasks, i + 1, newMasks, i, trailingLength);
            }
            this.elementChangedListeners = newListeners;
            this.elementChangedListenerMasks = newMasks;
            --this.elementChangedListenerCount;
            return;
        }
    }

    public void removePreResourceChangedListener(IResourceChangeListener listener) {
        for (int i = 0; i < this.preResourceChangeListenerCount; ++i) {
            if (!this.preResourceChangeListeners[i].equals(listener)) continue;
            int length = this.preResourceChangeListeners.length;
            IResourceChangeListener[] newListeners = new IResourceChangeListener[length];
            System.arraycopy(this.preResourceChangeListeners, 0, newListeners, 0, i);
            int trailingLength = this.preResourceChangeListenerCount - i - 1;
            if (trailingLength > 0) {
                System.arraycopy(this.preResourceChangeListeners, i + 1, newListeners, i, trailingLength);
            }
            this.preResourceChangeListeners = newListeners;
            --this.preResourceChangeListenerCount;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(final IResourceChangeEvent event) {
        boolean isPostChange;
        boolean bl = isPostChange = event.getType() == 1;
        if (isPostChange) {
            for (int i = 0; i < this.preResourceChangeListenerCount; ++i) {
                final IResourceChangeListener listener = this.preResourceChangeListeners[i];
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in listener of pre Java resource change notification");
                    }

                    public void run() throws Exception {
                        listener.resourceChanged(event);
                    }
                });
            }
        }
        try {
            this.getDeltaProcessor().resourceChanged(event);
        }
        finally {
            if (isPostChange) {
                this.deltaProcessors.set(null);
            }
        }
    }

    public synchronized void updateRoots(IPath containerPath, IResourceDelta containerDelta, DeltaProcessor deltaProcessor) {
        HashMap otherUpdatedRoots;
        HashMap updatedRoots;
        if (containerDelta.getKind() == 2) {
            updatedRoots = this.oldRoots;
            otherUpdatedRoots = this.oldOtherRoots;
        } else {
            updatedRoots = this.roots;
            otherUpdatedRoots = this.otherRoots;
        }
        Iterator iterator = updatedRoots.keySet().iterator();
        while (iterator.hasNext()) {
            ArrayList rootList;
            IResourceDelta rootDelta;
            IPath path = (IPath)iterator.next();
            if (!containerPath.isPrefixOf(path) || containerPath.equals(path) || (rootDelta = containerDelta.findMember(path.removeFirstSegments(1))) == null) continue;
            DeltaProcessor.RootInfo rootInfo = (DeltaProcessor.RootInfo)updatedRoots.get(path);
            if (!rootInfo.project.getPath().isPrefixOf(path)) {
                deltaProcessor.updateCurrentDeltaAndIndex(rootDelta, 3, rootInfo);
            }
            if ((rootList = (ArrayList)otherUpdatedRoots.get(path)) == null) continue;
            Iterator otherProjects = rootList.iterator();
            while (otherProjects.hasNext()) {
                rootInfo = (DeltaProcessor.RootInfo)otherProjects.next();
                if (rootInfo.project.getPath().isPrefixOf(path)) continue;
                deltaProcessor.updateCurrentDeltaAndIndex(rootDelta, 3, rootInfo);
            }
        }
    }

    public static class ProjectUpdateInfo {
        JavaProject project;
        IClasspathEntry[] oldResolvedPath;
        IClasspathEntry[] newResolvedPath;
        IClasspathEntry[] newRawPath;

        public void updateProjectReferencesIfNecessary() throws JavaModelException {
            String[] oldRequired = this.project.projectPrerequisites(this.oldResolvedPath);
            if (this.newResolvedPath == null) {
                this.newResolvedPath = this.project.getResolvedClasspath(this.newRawPath, null, true, true, null);
            }
            String[] newRequired = this.project.projectPrerequisites(this.newResolvedPath);
            try {
                int newSize;
                HashSet newReferences;
                IProjectDescription description;
                IProject projectResource;
                block10: {
                    String projectName;
                    int i;
                    projectResource = this.project.getProject();
                    description = projectResource.getDescription();
                    IProject[] projectReferences = description.getDynamicReferences();
                    HashSet<String> oldReferences = new HashSet<String>(projectReferences.length);
                    for (int i2 = 0; i2 < projectReferences.length; ++i2) {
                        String projectName2 = projectReferences[i2].getName();
                        oldReferences.add(projectName2);
                    }
                    newReferences = (HashSet)oldReferences.clone();
                    for (i = 0; i < oldRequired.length; ++i) {
                        projectName = oldRequired[i];
                        newReferences.remove(projectName);
                    }
                    for (i = 0; i < newRequired.length; ++i) {
                        projectName = newRequired[i];
                        newReferences.add(projectName);
                    }
                    newSize = newReferences.size();
                    if (oldReferences.size() == newSize) {
                        Iterator iter = newReferences.iterator();
                        while (iter.hasNext()) {
                            if (oldReferences.contains(iter.next())) continue;
                            break block10;
                        }
                        return;
                    }
                }
                String[] requiredProjectNames = new String[newSize];
                int index = 0;
                Iterator iter = newReferences.iterator();
                while (iter.hasNext()) {
                    requiredProjectNames[index++] = (String)iter.next();
                }
                Util.sort(requiredProjectNames);
                IProject[] requiredProjectArray = new IProject[newSize];
                IWorkspaceRoot wksRoot = projectResource.getWorkspace().getRoot();
                for (int i = 0; i < newSize; ++i) {
                    requiredProjectArray[i] = wksRoot.getProject(requiredProjectNames[i]);
                }
                description.setDynamicReferences(requiredProjectArray);
                projectResource.setDescription(description, null);
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
    }
}

