/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.internal.core.DebugCoreMessages;

public abstract class LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate2 {
    protected static final IStatus promptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
    protected static final IStatus switchToDebugPromptStatus = new Status(1, "org.eclipse.debug.core", 201, "", null);
    protected static final IStatus complileErrorPromptStatus = new Status(1, "org.eclipse.debug.core", 202, "", null);

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return null;
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IProject[] projects = this.getBuildOrder(configuration, mode);
        if (projects == null) {
            return true;
        }
        this.buildProjects(projects, monitor);
        return false;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return null;
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return null;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IProject[] projects = this.getProjectsForProblemSearch(configuration, mode);
        if (projects == null) {
            return true;
        }
        boolean continueLaunch = true;
        monitor.subTask(DebugCoreMessages.getString("LaunchConfigurationDelegate.6"));
        for (int i = 0; i < projects.length; ++i) {
            IStatusHandler prompter;
            monitor.subTask(DebugCoreMessages.getString("LaunchConfigurationDelegate.7") + projects[i].getName());
            if (!this.existsProblems(projects[i]) || (prompter = DebugPlugin.getDefault().getStatusHandler(promptStatus)) == null) continue;
            continueLaunch = (Boolean)prompter.handleStatus(complileErrorPromptStatus, configuration);
            break;
        }
        return continueLaunch;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (mode.equals("run") && configuration.supportsMode("debug")) {
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            if (!breakpointManager.isEnabled()) {
                return true;
            }
            IBreakpoint[] breakpoints = breakpointManager.getBreakpoints();
            for (int i = 0; i < breakpoints.length; ++i) {
                boolean lauchInDebugModeInstead;
                if (!breakpoints[i].isEnabled()) continue;
                IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler(promptStatus);
                return prompter == null || !(lauchInDebugModeInstead = ((Boolean)prompter.handleStatus(switchToDebugPromptStatus, configuration)).booleanValue());
            }
        }
        return true;
    }

    protected IProject[] computeReferencedBuildOrder(IProject[] baseProjects) throws CoreException {
        HashSet<IProject> unorderedProjects = new HashSet<IProject>();
        for (int i = 0; i < baseProjects.length; ++i) {
            unorderedProjects.add(baseProjects[i]);
            this.addReferencedProjects(baseProjects[i], unorderedProjects);
        }
        IProject[] projectSet = unorderedProjects.toArray(new IProject[unorderedProjects.size()]);
        return this.computeBuildOrder(projectSet);
    }

    protected void addReferencedProjects(IProject project, Set references) throws CoreException {
        if (project.isOpen()) {
            IProject[] projects = project.getReferencedProjects();
            for (int i = 0; i < projects.length; ++i) {
                IProject refProject = projects[i];
                if (!refProject.exists() || references.contains(refProject)) continue;
                references.add(refProject);
                this.addReferencedProjects(refProject, references);
            }
        }
    }

    protected IProject[] computeBuildOrder(IProject[] projects) {
        String[] orderedNames = ResourcesPlugin.getWorkspace().getDescription().getBuildOrder();
        if (orderedNames != null) {
            int i;
            ArrayList<Object> orderedProjects = new ArrayList<Object>(projects.length);
            ArrayList<IProject> unorderedProjects = new ArrayList<IProject>(projects.length);
            for (i = 0; i < projects.length; ++i) {
                unorderedProjects.add(projects[i]);
            }
            block1: for (i = 0; i < orderedNames.length; ++i) {
                String projectName = orderedNames[i];
                Iterator iterator = unorderedProjects.iterator();
                while (iterator.hasNext()) {
                    IProject project = (IProject)iterator.next();
                    if (!project.getName().equals(projectName)) continue;
                    orderedProjects.add(project);
                    iterator.remove();
                    continue block1;
                }
            }
            orderedProjects.addAll(unorderedProjects);
            return orderedProjects.toArray(new IProject[orderedProjects.size()]);
        }
        IWorkspace.ProjectOrder po = ResourcesPlugin.getWorkspace().computeProjectOrder(projects);
        return po.projects;
    }

    protected boolean existsProblems(IProject proj) throws CoreException {
        IMarker[] markers = proj.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        if (markers.length > 0) {
            for (int i = 0; i < markers.length; ++i) {
                if (!this.isLaunchProblem(markers[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isLaunchProblem(IMarker problemMarker) throws CoreException {
        Integer severity = (Integer)problemMarker.getAttribute("severity");
        if (severity != null) {
            return severity >= 2;
        }
        return false;
    }

    protected void buildProjects(IProject[] projects, IProgressMonitor monitor) throws CoreException {
        for (int i = 0; i < projects.length; ++i) {
            projects[i].build(10, monitor);
        }
    }
}

