/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.ui.subscriber.ChangeLogDiffNode;
import org.eclipse.team.internal.ccvs.ui.subscriber.ChangeLogModelProvider;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;

public class ChangeLogModelSorter
extends ViewerSorter {
    private int commentCriteria;
    private int resourceCriteria;
    public static final int DATE = 1;
    public static final int COMMENT = 2;
    public static final int USER = 3;
    public static final int NAME = 1;
    public static final int PATH = 2;
    public static final int PARENT_NAME = 3;

    public ChangeLogModelSorter(int commentCriteria, int resourceCriteria) {
        this.commentCriteria = commentCriteria;
        this.resourceCriteria = resourceCriteria;
    }

    protected int classComparison(Object element) {
        if (element instanceof ChangeLogDiffNode) {
            return 0;
        }
        return 1;
    }

    protected int compareClass(Object element1, Object element2) {
        return this.classComparison(element1) - this.classComparison(element2);
    }

    protected int compareNames(String s1, String s2) {
        return this.collator.compare(s1, s2);
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        if (o1 instanceof ChangeLogDiffNode && o2 instanceof ChangeLogDiffNode) {
            ILogEntry r1 = ((ChangeLogDiffNode)((Object)o1)).getComment();
            ILogEntry r2 = ((ChangeLogDiffNode)((Object)o2)).getComment();
            if (this.commentCriteria == 1) {
                return r1.getDate().compareTo(r2.getDate());
            }
            if (this.commentCriteria == 2) {
                return this.compareNames(r1.getComment(), r2.getComment());
            }
            if (this.commentCriteria == 3) {
                return this.compareNames(r1.getAuthor(), r2.getAuthor());
            }
            return 0;
        }
        if (o1 instanceof ChangeLogModelProvider.FullPathSyncInfoElement && o2 instanceof ChangeLogModelProvider.FullPathSyncInfoElement) {
            IResource r1 = ((ISynchronizeModelElement)o1).getResource();
            IResource r2 = ((ISynchronizeModelElement)o2).getResource();
            if (this.resourceCriteria == 1) {
                return this.compareNames(r1.getName(), r2.getName());
            }
            if (this.resourceCriteria == 2) {
                return this.compareNames(r1.getFullPath().toString(), r2.getFullPath().toString());
            }
            if (this.resourceCriteria == 3) {
                return this.compareNames(r1.getParent().getName(), r2.getParent().getName());
            }
            return 0;
        }
        if (o1 instanceof ISynchronizeModelElement) {
            return 1;
        }
        if (o2 instanceof ISynchronizeModelElement) {
            return -1;
        }
        return 0;
    }

    public int getCommentCriteria() {
        return this.commentCriteria;
    }

    public int getResourceCriteria() {
        return this.resourceCriteria;
    }
}

