/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.console;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ConsolePreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ColorFieldEditor commandColorEditor;
    private ColorFieldEditor messageColorEditor;
    private ColorFieldEditor errorColorEditor;
    private BooleanFieldEditor showOnMessage;

    public ConsolePreferencesPage() {
        super(1);
        this.setPreferenceStore(CVSUIPlugin.getPlugin().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        this.createLabel(composite, Policy.bind("ConsolePreferencePage.consoleColorSettings"));
        this.commandColorEditor = this.createColorFieldEditor("pref_console_command_color", Policy.bind("ConsolePreferencePage.commandColor"), composite);
        this.addField((FieldEditor)this.commandColorEditor);
        this.messageColorEditor = this.createColorFieldEditor("pref_console_message_color", Policy.bind("ConsolePreferencePage.messageColor"), composite);
        this.addField((FieldEditor)this.messageColorEditor);
        this.errorColorEditor = this.createColorFieldEditor("pref_console_error_color", Policy.bind("ConsolePreferencePage.errorColor"), composite);
        this.addField((FieldEditor)this.errorColorEditor);
        this.showOnMessage = new BooleanFieldEditor("pref_console_show_on_error", Policy.bind("ConsolePreferencesPage.4"), composite);
        this.addField((FieldEditor)this.showOnMessage);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.cvs.ui.console_preference_page_context");
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private ColorFieldEditor createColorFieldEditor(String preferenceName, String label, Composite parent) {
        ColorFieldEditor editor = new ColorFieldEditor(preferenceName, label, parent);
        editor.setPreferencePage((PreferencePage)this);
        editor.setPreferenceStore(this.getPreferenceStore());
        return editor;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        CVSUIPlugin.getPlugin().savePluginPreferences();
        return super.performOk();
    }
}

