/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ResourceBundle;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class InsertLineAction
extends TextEditorAction {
    protected boolean fAbove;

    public InsertLineAction(ResourceBundle bundle, String prefix, ITextEditor textEditor, boolean above) {
        super(bundle, prefix, textEditor);
        this.fAbove = above;
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            this.setEnabled(this.canModifyEditor());
        }
    }

    public void run() {
        ITextEditor ed = this.getTextEditor();
        if (!(ed instanceof AbstractTextEditor)) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        AbstractTextEditor editor = (AbstractTextEditor)ed;
        ISourceViewer sv = editor.getSourceViewer();
        if (sv == null) {
            return;
        }
        StyledText st = sv.getTextWidget();
        if (st == null || st.isDisposed()) {
            return;
        }
        int caretOffset = st.getCaretOffset();
        int lineNumber = st.getLineAtOffset(caretOffset);
        int lineOffset = st.getOffsetAtLine(lineNumber);
        int lineLength = this.getLineLength(st, lineNumber, lineOffset);
        String line = st.getTextRange(lineOffset, lineLength);
        boolean whiteSpace = this.isWhitespace(line);
        String delimiter = st.getLineDelimiter();
        int insertionPoint = this.fAbove ? (whiteSpace ? caretOffset : lineOffset + this.getIndentationLength(line)) : lineOffset + lineLength;
        st.replaceTextRange(insertionPoint, 0, delimiter);
        int newCaretOffset = -1;
        if (this.fAbove && !whiteSpace) {
            newCaretOffset = st.getOffsetAtLine(lineNumber) + this.getLineLength(st, lineNumber, lineOffset);
        } else if (this.fAbove || !whiteSpace) {
            int nextLine = lineNumber + 1;
            int nextLineOffset = st.getOffsetAtLine(nextLine);
            int nextLineLength = this.getLineLength(st, nextLine, nextLineOffset);
            newCaretOffset = nextLineOffset + nextLineLength;
        }
        if (newCaretOffset != -1) {
            st.setCaretOffset(newCaretOffset);
            st.showSelection();
        }
    }

    private int getLineLength(StyledText st, int lineNumber, int lineOffset) {
        int lineLength;
        if (st.getLineCount() == lineNumber + 1) {
            lineLength = st.getCharCount() - lineOffset;
        } else {
            lineLength = st.getOffsetAtLine(lineNumber + 1);
            lineLength -= lineOffset;
            lineLength -= st.getLineDelimiter().length();
        }
        return lineLength;
    }

    private int getIndentationLength(String line) {
        int pos;
        Assert.isNotNull((Object)line);
        for (pos = 0; pos < line.length() && Character.isWhitespace(line.charAt(pos)); ++pos) {
        }
        return pos;
    }

    private boolean isWhitespace(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() == 0;
    }
}

