/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contentassist.ContentAssistHandler;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.texteditor.EditorMessages;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.IFindReplaceTargetExtension2;
import org.eclipse.ui.texteditor.RegExContentAssistProcessor;

class FindReplaceDialog
extends Dialog {
    private static final int HISTORY_SIZE = 5;
    private Point fLocation;
    private Point fIncrementalBaseLocation;
    private boolean fWrapInit = false;
    private boolean fCaseInit = false;
    private boolean fWholeWordInit = false;
    private boolean fForwardInit = true;
    private boolean fGlobalInit = true;
    private boolean fIncrementalInit = false;
    private boolean fNeedsInitialFindBeforeReplace;
    boolean fIsRegExInit = false;
    private List fFindHistory;
    private List fReplaceHistory;
    private IRegion fOldScope;
    private boolean fIsTargetEditable;
    private IFindReplaceTarget fTarget = null;
    private Shell fParentShell = null;
    private Shell fActiveShell;
    private final ActivationListener fActivationListener = new ActivationListener();
    private final ModifyListener fFindModifyListener = new FindModifyListener();
    private Label fReplaceLabel;
    private Label fStatusLabel;
    private Button fForwardRadioButton;
    private Button fGlobalRadioButton;
    private Button fSelectedRangeRadioButton;
    private Button fCaseCheckBox;
    private Button fWrapCheckBox;
    private Button fWholeWordCheckBox;
    private Button fIncrementalCheckBox;
    private Button fIsRegExCheckBox;
    private Button fReplaceSelectionButton;
    private Button fReplaceFindButton;
    private Button fFindNextButton;
    private Button fReplaceAllButton;
    Combo fFindField;
    Combo fReplaceField;
    private Rectangle fDialogPositionInit = null;
    private IDialogSettings fDialogSettings;
    private boolean fIsTargetSupportingRegEx;
    private boolean fUseSelectedLines;
    private ContentAssistHandler fFindContentAssistHandler;
    private ContentAssistHandler fReplaceContentAssistHandler;
    private Color fProposalPopupBackgroundColor;
    private Color fProposalPopupForegroundColor;
    private boolean fGiveFocusToFindField = true;
    static /* synthetic */ Class class$org$eclipse$ui$texteditor$IEditorStatusLine;

    public FindReplaceDialog(Shell parentShell) {
        super(parentShell);
        this.fFindHistory = new ArrayList(4);
        this.fReplaceHistory = new ArrayList(4);
        this.readConfiguration();
        this.setShellStyle(2144);
        this.setBlockOnOpen(false);
    }

    public Shell getParentShell() {
        return super.getParentShell();
    }

    private boolean okToUse(Control control) {
        return control != null && !control.isDisposed();
    }

    public void create() {
        super.create();
        Shell shell = this.getShell();
        shell.addShellListener((ShellListener)this.fActivationListener);
        if (this.fLocation != null) {
            shell.setLocation(this.fLocation);
        }
        WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.ui.find_replace_dialog_context");
        this.fFindField.removeModifyListener(this.fFindModifyListener);
        this.updateCombo(this.fFindField, this.fFindHistory);
        this.fFindField.addModifyListener(this.fFindModifyListener);
        this.updateCombo(this.fReplaceField, this.fReplaceHistory);
        this.initFindStringFromSelection();
        if (this.fDialogPositionInit != null) {
            shell.setBounds(this.fDialogPositionInit);
        }
        shell.setText(EditorMessages.getString("FindReplace.title"));
    }

    private Composite createButtonSection(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = -2;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        this.fFindNextButton = this.makeButton(panel, "FindReplace.FindNextButton.label", 102, true, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.isIncrementalSearch() && !FindReplaceDialog.this.isRegExSearchAvailableAndChecked()) {
                    FindReplaceDialog.this.initIncrementalBaseLocation();
                }
                FindReplaceDialog.this.fNeedsInitialFindBeforeReplace = false;
                FindReplaceDialog.this.performSearch();
                FindReplaceDialog.this.updateFindHistory();
                FindReplaceDialog.this.fFindNextButton.setFocus();
            }
        });
        this.setGridData((Control)this.fFindNextButton, 4, true, 4, false);
        this.fReplaceFindButton = this.makeButton(panel, "FindReplace.ReplaceFindButton.label", 103, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.fNeedsInitialFindBeforeReplace) {
                    FindReplaceDialog.this.performSearch();
                }
                if (FindReplaceDialog.this.performReplaceSelection()) {
                    FindReplaceDialog.this.performSearch();
                }
                FindReplaceDialog.this.updateFindAndReplaceHistory();
                FindReplaceDialog.this.fReplaceFindButton.setFocus();
            }
        });
        this.setGridData((Control)this.fReplaceFindButton, 4, true, 4, false);
        this.fReplaceSelectionButton = this.makeButton(panel, "FindReplace.ReplaceSelectionButton.label", 104, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.fNeedsInitialFindBeforeReplace) {
                    FindReplaceDialog.this.performSearch();
                }
                FindReplaceDialog.this.performReplaceSelection();
                FindReplaceDialog.this.updateFindAndReplaceHistory();
                FindReplaceDialog.this.fFindNextButton.setFocus();
            }
        });
        this.setGridData((Control)this.fReplaceSelectionButton, 4, true, 4, false);
        this.fReplaceAllButton = this.makeButton(panel, "FindReplace.ReplaceAllButton.label", 105, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.performReplaceAll();
                FindReplaceDialog.this.updateFindAndReplaceHistory();
                FindReplaceDialog.this.fFindNextButton.setFocus();
            }
        });
        this.setGridData((Control)this.fReplaceAllButton, 4, true, 4, false);
        this.fReplaceAllButton.setEnabled(this.isEditable());
        return panel;
    }

    private Composite createConfigPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        Composite directionGroup = this.createDirectionGroup(panel);
        this.setGridData((Control)directionGroup, 4, true, 4, false);
        Composite scopeGroup = this.createScopeGroup(panel);
        this.setGridData((Control)scopeGroup, 4, true, 4, false);
        Composite optionsGroup = this.createOptionsGroup(panel);
        this.setGridData((Control)optionsGroup, 4, true, 4, false);
        GridData data = (GridData)optionsGroup.getLayoutData();
        data.horizontalSpan = 2;
        optionsGroup.setLayoutData((Object)data);
        return panel;
    }

    protected Control createContents(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        Composite inputPanel = this.createInputPanel(panel);
        this.setGridData((Control)inputPanel, 4, true, 2, false);
        Composite configPanel = this.createConfigPanel(panel);
        this.setGridData((Control)configPanel, 4, true, 2, true);
        Composite buttonPanelB = this.createButtonSection(panel);
        this.setGridData((Control)buttonPanelB, 4, true, 2, false);
        Composite statusBar = this.createStatusAndCloseButton(panel);
        this.setGridData((Control)statusBar, 4, true, 2, false);
        this.updateButtonState();
        FindReplaceDialog.applyDialogFont((Control)panel);
        this.fProposalPopupBackgroundColor = new Color((Device)this.getShell().getDisplay(), new RGB(254, 241, 233));
        this.fProposalPopupForegroundColor = new Color((Device)this.getShell().getDisplay(), new RGB(0, 0, 0));
        return panel;
    }

    private void setContentAssistsEnablement(boolean enable) {
        if (enable) {
            if (this.fFindContentAssistHandler == null) {
                this.fFindContentAssistHandler = ContentAssistHandler.createHandlerForCombo(this.fFindField, this.createContentAssistant());
                this.fReplaceContentAssistHandler = ContentAssistHandler.createHandlerForCombo(this.fReplaceField, this.createContentAssistant());
            }
            this.fFindContentAssistHandler.setEnabled(true);
            this.fReplaceContentAssistHandler.setEnabled(true);
        } else {
            if (this.fFindContentAssistHandler == null) {
                return;
            }
            this.fFindContentAssistHandler.setEnabled(false);
            this.fReplaceContentAssistHandler.setEnabled(false);
        }
    }

    private Composite createDirectionGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 16);
        group.setText(EditorMessages.getString("FindReplace.Direction"));
        GridLayout groupLayout = new GridLayout();
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(1808));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.isIncrementalSearch() && !FindReplaceDialog.this.isRegExSearchAvailableAndChecked()) {
                    FindReplaceDialog.this.initIncrementalBaseLocation();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fForwardRadioButton = new Button((Composite)group, 16400);
        this.fForwardRadioButton.setText(EditorMessages.getString("FindReplace.ForwardRadioButton.label"));
        this.setGridData((Control)this.fForwardRadioButton, 1, false, 2, false);
        this.fForwardRadioButton.addSelectionListener(selectionListener);
        Button backwardRadioButton = new Button((Composite)group, 16400);
        backwardRadioButton.setText(EditorMessages.getString("FindReplace.BackwardRadioButton.label"));
        this.setGridData((Control)backwardRadioButton, 1, false, 2, false);
        backwardRadioButton.addSelectionListener(selectionListener);
        backwardRadioButton.setSelection(!this.fForwardInit);
        this.fForwardRadioButton.setSelection(this.fForwardInit);
        return panel;
    }

    private Composite createScopeGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 16);
        group.setText(EditorMessages.getString("FindReplace.Scope"));
        GridLayout groupLayout = new GridLayout();
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(1808));
        this.fGlobalRadioButton = new Button((Composite)group, 16400);
        this.fGlobalRadioButton.setText(EditorMessages.getString("FindReplace.GlobalRadioButton.label"));
        this.setGridData((Control)this.fGlobalRadioButton, 1, false, 2, false);
        this.fGlobalRadioButton.setSelection(this.fGlobalInit);
        this.fGlobalRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!FindReplaceDialog.this.fGlobalRadioButton.getSelection() || !FindReplaceDialog.this.fUseSelectedLines) {
                    return;
                }
                FindReplaceDialog.this.fUseSelectedLines = false;
                FindReplaceDialog.this.useSelectedLines(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fSelectedRangeRadioButton = new Button((Composite)group, 16400);
        this.fSelectedRangeRadioButton.setText(EditorMessages.getString("FindReplace.SelectedRangeRadioButton.label"));
        this.setGridData((Control)this.fSelectedRangeRadioButton, 1, false, 2, false);
        this.fSelectedRangeRadioButton.setSelection(!this.fGlobalInit);
        this.fUseSelectedLines = !this.fGlobalInit;
        this.fSelectedRangeRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!FindReplaceDialog.this.fSelectedRangeRadioButton.getSelection() || FindReplaceDialog.this.fUseSelectedLines) {
                    return;
                }
                FindReplaceDialog.this.fUseSelectedLines = true;
                FindReplaceDialog.this.useSelectedLines(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return panel;
    }

    private void useSelectedLines(boolean selectedLines) {
        if (this.isIncrementalSearch() && !this.isRegExSearchAvailableAndChecked()) {
            this.initIncrementalBaseLocation();
        }
        if (this.fTarget == null || !(this.fTarget instanceof IFindReplaceTargetExtension)) {
            return;
        }
        IFindReplaceTargetExtension extensionTarget = (IFindReplaceTargetExtension)this.fTarget;
        if (selectedLines) {
            IRegion scope;
            if (this.fOldScope == null) {
                Point lineSelection = extensionTarget.getLineSelection();
                scope = new Region(lineSelection.x, lineSelection.y);
            } else {
                scope = this.fOldScope;
                this.fOldScope = null;
            }
            int offset = this.isForwardSearch() ? scope.getOffset() : scope.getOffset() + scope.getLength();
            extensionTarget.setSelection(offset, 0);
            extensionTarget.setScope(scope);
        } else {
            this.fOldScope = extensionTarget.getScope();
            extensionTarget.setScope(null);
        }
    }

    private Composite createInputPanel(Composite parent) {
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FindReplaceDialog.this.updateButtonState();
            }
        };
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        Label findLabel = new Label(panel, 16384);
        findLabel.setText(EditorMessages.getString("FindReplace.Find.label"));
        this.setGridData((Control)findLabel, 1, false, 2, false);
        this.fFindField = new Combo(panel, 2052);
        this.setGridData((Control)this.fFindField, 4, true, 2, false);
        this.fFindField.addModifyListener(this.fFindModifyListener);
        this.fReplaceLabel = new Label(panel, 16384);
        this.fReplaceLabel.setText(EditorMessages.getString("FindReplace.Replace.label"));
        this.setGridData((Control)this.fReplaceLabel, 1, false, 2, false);
        this.fReplaceField = new Combo(panel, 2052);
        this.setGridData((Control)this.fReplaceField, 4, true, 2, false);
        this.fReplaceField.addModifyListener(listener);
        return panel;
    }

    private Composite createOptionsGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 32);
        group.setText(EditorMessages.getString("FindReplace.Options"));
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        groupLayout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(1808));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.storeSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fCaseCheckBox = new Button((Composite)group, 16416);
        this.fCaseCheckBox.setText(EditorMessages.getString("FindReplace.CaseCheckBox.label"));
        this.setGridData((Control)this.fCaseCheckBox, 1, false, 2, false);
        this.fCaseCheckBox.setSelection(this.fCaseInit);
        this.fCaseCheckBox.addSelectionListener(selectionListener);
        this.fWrapCheckBox = new Button((Composite)group, 16416);
        this.fWrapCheckBox.setText(EditorMessages.getString("FindReplace.WrapCheckBox.label"));
        this.setGridData((Control)this.fWrapCheckBox, 1, false, 2, false);
        this.fWrapCheckBox.setSelection(this.fWrapInit);
        this.fWrapCheckBox.addSelectionListener(selectionListener);
        this.fWholeWordCheckBox = new Button((Composite)group, 16416);
        this.fWholeWordCheckBox.setText(EditorMessages.getString("FindReplace.WholeWordCheckBox.label"));
        this.setGridData((Control)this.fWholeWordCheckBox, 1, false, 2, false);
        this.fWholeWordCheckBox.setSelection(this.fWholeWordInit);
        this.fWholeWordCheckBox.addSelectionListener(selectionListener);
        this.fIncrementalCheckBox = new Button((Composite)group, 16416);
        this.fIncrementalCheckBox.setText(EditorMessages.getString("FindReplace.IncrementalCheckBox.label"));
        this.setGridData((Control)this.fIncrementalCheckBox, 1, false, 2, false);
        this.fIncrementalCheckBox.setSelection(this.fIncrementalInit);
        this.fIncrementalCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.isIncrementalSearch() && !FindReplaceDialog.this.isRegExSearch()) {
                    FindReplaceDialog.this.initIncrementalBaseLocation();
                }
                FindReplaceDialog.this.storeSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fIsRegExCheckBox = new Button((Composite)group, 16416);
        this.fIsRegExCheckBox.setText(EditorMessages.getString("FindReplace.RegExCheckbox.label"));
        this.setGridData((Control)this.fIsRegExCheckBox, 1, false, 2, false);
        ((GridData)this.fIsRegExCheckBox.getLayoutData()).horizontalSpan = 2;
        this.fIsRegExCheckBox.setSelection(this.fIsRegExInit);
        this.fIsRegExCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean newState = FindReplaceDialog.this.fIsRegExCheckBox.getSelection();
                FindReplaceDialog.this.fIncrementalCheckBox.setEnabled(!newState);
                FindReplaceDialog.this.updateButtonState();
                FindReplaceDialog.this.storeSettings();
                FindReplaceDialog.this.setContentAssistsEnablement(newState);
            }
        });
        this.fWholeWordCheckBox.setEnabled(!this.isRegExSearchAvailableAndChecked());
        this.fWholeWordCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.updateButtonState();
            }
        });
        this.fIncrementalCheckBox.setEnabled(!this.isRegExSearchAvailableAndChecked());
        return panel;
    }

    private Composite createStatusAndCloseButton(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        this.fStatusLabel = new Label(panel, 16384);
        this.setGridData((Control)this.fStatusLabel, 4, true, 2, false);
        String label = EditorMessages.getString("FindReplace.CloseButton.label");
        Button closeButton = this.createButton(panel, 101, label, false);
        this.setGridData((Control)closeButton, 3, false, 3, false);
        return panel;
    }

    protected void buttonPressed(int buttonID) {
        if (buttonID == 101) {
            this.close();
        }
    }

    private int findIndex(String findString, int startPosition, boolean forwardSearch, boolean caseSensitive, boolean wrapSearch, boolean wholeWord, boolean regExSearch) {
        if (forwardSearch) {
            if (wrapSearch) {
                int index = this.findAndSelect(startPosition, findString, true, caseSensitive, wholeWord, regExSearch);
                if (index == -1) {
                    if (this.okToUse((Control)this.getShell()) && !this.isIncrementalSearch()) {
                        this.getShell().getDisplay().beep();
                    }
                    index = this.findAndSelect(-1, findString, true, caseSensitive, wholeWord, regExSearch);
                }
                return index;
            }
            return this.findAndSelect(startPosition, findString, true, caseSensitive, wholeWord, regExSearch);
        }
        if (wrapSearch) {
            int index = this.findAndSelect(startPosition - 1, findString, false, caseSensitive, wholeWord, regExSearch);
            if (index == -1) {
                if (this.okToUse((Control)this.getShell()) && !this.isIncrementalSearch()) {
                    this.getShell().getDisplay().beep();
                }
                index = this.findAndSelect(-1, findString, false, caseSensitive, wholeWord, regExSearch);
            }
            return index;
        }
        return this.findAndSelect(startPosition - 1, findString, false, caseSensitive, wholeWord, regExSearch);
    }

    private int findAndSelect(int offset, String findString, boolean forwardSearch, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        if (this.fTarget instanceof IFindReplaceTargetExtension3) {
            return ((IFindReplaceTargetExtension3)this.fTarget).findAndSelect(offset, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
        }
        return this.fTarget.findAndSelect(offset, findString, forwardSearch, caseSensitive, wholeWord);
    }

    Point replaceSelection(String replaceString, boolean regExReplace) {
        if (this.fTarget instanceof IFindReplaceTargetExtension3) {
            ((IFindReplaceTargetExtension3)this.fTarget).replaceSelection(replaceString, regExReplace);
        } else {
            this.fTarget.replaceSelection(replaceString);
        }
        return this.fTarget.getSelection();
    }

    private boolean findNext(String findString, boolean forwardSearch, boolean caseSensitive, boolean wrapSearch, boolean wholeWord, boolean incremental, boolean regExSearch) {
        if (this.fTarget == null) {
            return false;
        }
        Point r = null;
        r = incremental ? this.fIncrementalBaseLocation : this.fTarget.getSelection();
        int findReplacePosition = r.x;
        if (forwardSearch && !this.fNeedsInitialFindBeforeReplace || !forwardSearch && this.fNeedsInitialFindBeforeReplace) {
            findReplacePosition += r.y;
        }
        this.fNeedsInitialFindBeforeReplace = false;
        int index = this.findIndex(findString, findReplacePosition, forwardSearch, caseSensitive, wrapSearch, wholeWord, regExSearch);
        return index != -1;
    }

    private Rectangle getDialogBoundaries() {
        if (this.okToUse((Control)this.getShell())) {
            return this.getShell().getBounds();
        }
        return this.fDialogPositionInit;
    }

    private List getFindHistory() {
        return this.fFindHistory;
    }

    private String getFindString() {
        if (this.okToUse((Control)this.fFindField)) {
            return this.fFindField.getText();
        }
        return "";
    }

    private List getReplaceHistory() {
        return this.fReplaceHistory;
    }

    private String getReplaceString() {
        if (this.okToUse((Control)this.fReplaceField)) {
            return this.fReplaceField.getText();
        }
        return "";
    }

    private String getSelectionString() {
        String selection = this.fTarget.getSelectionText();
        if (selection != null && selection.length() > 0) {
            int[] info = TextUtilities.indexOf((String[])TextUtilities.DELIMITERS, (String)selection, (int)0);
            if (info[0] > 0) {
                return selection.substring(0, info[0]);
            }
            if (info[0] == -1) {
                return selection;
            }
        }
        return null;
    }

    public boolean close() {
        this.handleDialogClose();
        return super.close();
    }

    private void handleDialogClose() {
        if (this.okToUse((Control)this.fFindField)) {
            this.fFindField.removeModifyListener(this.fFindModifyListener);
        }
        if (this.fParentShell != null) {
            this.fParentShell.removeShellListener((ShellListener)this.fActivationListener);
            this.fParentShell = null;
        }
        this.getShell().removeShellListener((ShellListener)this.fActivationListener);
        this.storeSettings();
        if (this.fTarget != null && this.fTarget instanceof IFindReplaceTargetExtension) {
            ((IFindReplaceTargetExtension)this.fTarget).endSession();
        }
        this.setContentAssistsEnablement(false);
        this.fFindContentAssistHandler = null;
        this.fReplaceContentAssistHandler = null;
        this.fProposalPopupBackgroundColor.dispose();
        this.fProposalPopupForegroundColor.dispose();
        this.fActiveShell = null;
        this.fTarget = null;
    }

    private void writeSelection() {
        if (this.fTarget == null) {
            return;
        }
        String selection = this.fTarget.getSelectionText();
        if (selection == null) {
            selection = "";
        }
        IDialogSettings s = this.getDialogSettings();
        s.put("selection", selection);
    }

    private void storeSettings() {
        this.fDialogPositionInit = this.getDialogBoundaries();
        this.fWrapInit = this.isWrapSearch();
        this.fWholeWordInit = this.isWholeWordSetting();
        this.fCaseInit = this.isCaseSensitiveSearch();
        this.fIsRegExInit = this.isRegExSearch();
        this.fIncrementalInit = this.isIncrementalSearch();
        this.fForwardInit = this.isForwardSearch();
        this.writeConfiguration();
    }

    private void initFindStringFromSelection() {
        if (this.fTarget != null && this.okToUse((Control)this.fFindField)) {
            String selection = this.getSelectionString();
            this.fFindField.removeModifyListener(this.fFindModifyListener);
            if (selection != null) {
                this.fFindField.setText(selection);
                if (!selection.equals(this.fTarget.getSelectionText())) {
                    this.useSelectedLines(true);
                    this.fGlobalRadioButton.setSelection(false);
                    this.fSelectedRangeRadioButton.setSelection(true);
                    this.fUseSelectedLines = true;
                }
            } else if ("".equals(this.fFindField.getText())) {
                if (this.fFindHistory.size() > 0) {
                    this.fFindField.setText((String)this.fFindHistory.get(0));
                } else {
                    this.fFindField.setText("");
                }
            }
            this.fFindField.setSelection(new Point(0, this.fFindField.getText().length()));
            this.fFindField.addModifyListener(this.fFindModifyListener);
        }
    }

    private void initIncrementalBaseLocation() {
        this.fIncrementalBaseLocation = this.fTarget != null && this.isIncrementalSearch() && !this.isRegExSearchAvailableAndChecked() ? this.fTarget.getSelection() : new Point(0, 0);
    }

    private boolean isCaseSensitiveSearch() {
        if (this.okToUse((Control)this.fCaseCheckBox)) {
            return this.fCaseCheckBox.getSelection();
        }
        return this.fCaseInit;
    }

    private boolean isRegExSearch() {
        if (this.okToUse((Control)this.fIsRegExCheckBox)) {
            return this.fIsRegExCheckBox.getSelection();
        }
        return this.fIsRegExInit;
    }

    private boolean isRegExSearchAvailableAndChecked() {
        if (this.okToUse((Control)this.fIsRegExCheckBox)) {
            return this.fIsTargetSupportingRegEx && this.fIsRegExCheckBox.getSelection();
        }
        return this.fIsRegExInit;
    }

    private boolean isForwardSearch() {
        if (this.okToUse((Control)this.fForwardRadioButton)) {
            return this.fForwardRadioButton.getSelection();
        }
        return this.fForwardInit;
    }

    private boolean isWholeWordSetting() {
        if (this.okToUse((Control)this.fWholeWordCheckBox)) {
            return this.fWholeWordCheckBox.getSelection();
        }
        return this.fWholeWordInit;
    }

    private boolean isWholeWordSearch() {
        return this.isWholeWordSetting() && !this.isRegExSearchAvailableAndChecked() && (!this.okToUse((Control)this.fWholeWordCheckBox) || this.fWholeWordCheckBox.isEnabled());
    }

    private boolean isWrapSearch() {
        if (this.okToUse((Control)this.fWrapCheckBox)) {
            return this.fWrapCheckBox.getSelection();
        }
        return this.fWrapInit;
    }

    private boolean isIncrementalSearch() {
        if (this.okToUse((Control)this.fIncrementalCheckBox)) {
            return this.fIncrementalCheckBox.getSelection();
        }
        return this.fIncrementalInit;
    }

    private Button makeButton(Composite parent, String key, int id, boolean dfltButton, SelectionListener listener) {
        String label = EditorMessages.getString(key);
        Button b = this.createButton(parent, id, label, dfltButton);
        b.addSelectionListener(listener);
        return b;
    }

    private IEditorStatusLine getStatusLineManager() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        return (IEditorStatusLine)editor.getAdapter(class$org$eclipse$ui$texteditor$IEditorStatusLine == null ? (class$org$eclipse$ui$texteditor$IEditorStatusLine = FindReplaceDialog.class$("org.eclipse.ui.texteditor.IEditorStatusLine")) : class$org$eclipse$ui$texteditor$IEditorStatusLine);
    }

    private void statusMessage(boolean error, String message) {
        this.fStatusLabel.setText(message);
        if (error) {
            this.fStatusLabel.setForeground(JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
        } else {
            this.fStatusLabel.setForeground(null);
        }
        IEditorStatusLine statusLine = this.getStatusLineManager();
        if (statusLine != null) {
            statusLine.setMessage(error, message, null);
        }
        if (error) {
            this.getShell().getDisplay().beep();
        }
    }

    private void statusError(String message) {
        this.statusMessage(true, message);
    }

    private void statusMessage(String message) {
        this.statusMessage(false, message);
    }

    private void performReplaceAll() {
        int replaceCount = 0;
        String replaceString = this.getReplaceString();
        String findString = this.getFindString();
        if (findString != null && findString.length() > 0) {
            try {
                class ReplaceAllRunnable
                implements Runnable {
                    public int numberOfOccurrences;
                    private final /* synthetic */ String val$findString;
                    private final /* synthetic */ String val$replaceString;

                    ReplaceAllRunnable(String val$findString, String val$replaceString) {
                        this.val$findString = val$findString;
                        this.val$replaceString = val$replaceString;
                    }

                    public void run() {
                        this.numberOfOccurrences = FindReplaceDialog.this.replaceAll(this.val$findString, this.val$replaceString == null ? "" : this.val$replaceString, FindReplaceDialog.this.isForwardSearch(), FindReplaceDialog.this.isCaseSensitiveSearch(), FindReplaceDialog.this.isWrapSearch(), FindReplaceDialog.this.isWholeWordSearch(), FindReplaceDialog.this.isRegExSearchAvailableAndChecked());
                    }
                }
                ReplaceAllRunnable runnable = new ReplaceAllRunnable(findString, replaceString);
                BusyIndicator.showWhile((Display)this.fActiveShell.getDisplay(), (Runnable)runnable);
                replaceCount = runnable.numberOfOccurrences;
                if (replaceCount != 0) {
                    if (replaceCount == 1) {
                        this.statusMessage(EditorMessages.getString("FindReplace.Status.replacement.label"));
                    } else {
                        String msg = EditorMessages.getString("FindReplace.Status.replacements.label");
                        msg = MessageFormat.format(msg, String.valueOf(replaceCount));
                        this.statusMessage(msg);
                    }
                } else {
                    this.statusMessage(EditorMessages.getString("FindReplace.Status.noMatch.label"));
                }
            }
            catch (PatternSyntaxException ex) {
                this.statusError(ex.getLocalizedMessage());
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
        }
        this.writeSelection();
        this.updateButtonState();
    }

    private boolean validateTargetState() {
        IFindReplaceTargetExtension2 extension;
        if (this.fTarget instanceof IFindReplaceTargetExtension2 && !(extension = (IFindReplaceTargetExtension2)this.fTarget).validateTargetState()) {
            this.statusError(EditorMessages.getString("FindReplaceDialog.read_only"));
            this.updateButtonState();
            return false;
        }
        return this.isEditable();
    }

    private boolean performReplaceSelection() {
        boolean replaced;
        if (!this.validateTargetState()) {
            return false;
        }
        String replaceString = this.getReplaceString();
        if (replaceString == null) {
            replaceString = "";
        }
        try {
            this.replaceSelection(replaceString, this.isRegExSearchAvailableAndChecked());
            replaced = true;
            this.writeSelection();
        }
        catch (PatternSyntaxException ex) {
            this.statusError(ex.getLocalizedMessage());
            replaced = false;
        }
        catch (IllegalStateException ex) {
            replaced = false;
        }
        this.updateButtonState();
        return replaced;
    }

    private void performSearch() {
        this.performSearch(this.isIncrementalSearch() && !this.isRegExSearchAvailableAndChecked());
    }

    private void performSearch(boolean mustInitIncrementalBaseLocation) {
        String findString;
        if (mustInitIncrementalBaseLocation) {
            this.initIncrementalBaseLocation();
        }
        if ((findString = this.getFindString()) != null && findString.length() > 0) {
            try {
                boolean somethingFound = this.findNext(findString, this.isForwardSearch(), this.isCaseSensitiveSearch(), this.isWrapSearch(), this.isWholeWordSearch(), this.isIncrementalSearch() && !this.isRegExSearchAvailableAndChecked(), this.isRegExSearchAvailableAndChecked());
                if (somethingFound) {
                    this.statusMessage("");
                } else {
                    this.statusMessage(EditorMessages.getString("FindReplace.Status.noMatch.label"));
                }
            }
            catch (PatternSyntaxException ex) {
                this.statusError(ex.getLocalizedMessage());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.writeSelection();
        this.updateButtonState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int replaceAll(String findString, String replaceString, boolean forwardSearch, boolean caseSensitive, boolean wrapSearch, boolean wholeWord, boolean regExSearch) {
        int replaceCount = 0;
        int findReplacePosition = 0;
        if (wrapSearch) {
            findReplacePosition = 0;
            forwardSearch = true;
        } else if (this.fTarget.getSelectionText() != null) {
            Point selection = this.fTarget.getSelection();
            findReplacePosition = selection.x;
        }
        if (!this.validateTargetState()) {
            return replaceCount;
        }
        if (this.fTarget instanceof IFindReplaceTargetExtension) {
            ((IFindReplaceTargetExtension)this.fTarget).setReplaceAllMode(true);
        }
        try {
            int index = 0;
            while (index != -1) {
                index = this.findAndSelect(findReplacePosition, findString, forwardSearch, caseSensitive, wholeWord, regExSearch);
                if (index == -1) continue;
                Point selection = this.replaceSelection(replaceString, regExSearch);
                ++replaceCount;
                if (forwardSearch) {
                    findReplacePosition = selection.x + selection.y;
                    continue;
                }
                findReplacePosition = selection.x - 1;
                if (findReplacePosition != -1) continue;
                break;
            }
        }
        finally {
            if (this.fTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)this.fTarget).setReplaceAllMode(false);
            }
        }
        return replaceCount;
    }

    private void setGridData(Control component, int horizontalAlignment, boolean grabExcessHorizontalSpace, int verticalAlignment, boolean grabExcessVerticalSpace) {
        GridData gd = new GridData();
        gd.horizontalAlignment = horizontalAlignment;
        gd.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        gd.verticalAlignment = verticalAlignment;
        gd.grabExcessVerticalSpace = grabExcessVerticalSpace;
        component.setLayoutData((Object)gd);
    }

    private void updateButtonState() {
        this.updateButtonState(false);
    }

    private void updateButtonState(boolean disableReplace) {
        if (this.okToUse((Control)this.getShell()) && this.okToUse((Control)this.fFindNextButton)) {
            String selectedText = null;
            if (this.fTarget != null) {
                selectedText = this.fTarget.getSelectionText();
            }
            boolean selection = selectedText != null && selectedText.length() > 0;
            boolean enable = this.fTarget != null && (this.fActiveShell == this.fParentShell || this.fActiveShell == this.getShell());
            String str = this.getFindString();
            boolean findString = str != null && str.length() > 0;
            boolean wholeWord = this.isWord(str) && !this.isRegExSearchAvailableAndChecked();
            this.fWholeWordCheckBox.setEnabled(wholeWord);
            this.fFindNextButton.setEnabled(enable && findString);
            this.fReplaceSelectionButton.setEnabled(!disableReplace && enable && this.isEditable() && selection && (!this.fNeedsInitialFindBeforeReplace || !this.isRegExSearchAvailableAndChecked()));
            this.fReplaceFindButton.setEnabled(!disableReplace && enable && this.isEditable() && findString && selection && (!this.fNeedsInitialFindBeforeReplace || !this.isRegExSearchAvailableAndChecked()));
            this.fReplaceAllButton.setEnabled(enable && this.isEditable() && findString);
        }
    }

    private boolean isWord(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isJavaIdentifierPart(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void updateCombo(Combo combo, List content) {
        combo.removeAll();
        for (int i = 0; i < content.size(); ++i) {
            combo.add(content.get(i).toString());
        }
    }

    private void updateFindAndReplaceHistory() {
        this.updateFindHistory();
        if (this.okToUse((Control)this.fReplaceField)) {
            this.updateHistory(this.fReplaceField, this.fReplaceHistory);
        }
    }

    private void updateFindHistory() {
        if (this.okToUse((Control)this.fFindField)) {
            this.fFindField.removeModifyListener(this.fFindModifyListener);
            this.updateHistory(this.fFindField, this.fFindHistory);
            this.fFindField.addModifyListener(this.fFindModifyListener);
        }
    }

    private void updateHistory(Combo combo, List history) {
        String findString = combo.getText();
        int index = history.indexOf(findString);
        if (index != 0) {
            if (index != -1) {
                history.remove(index);
            }
            history.add(0, findString);
            this.updateCombo(combo, history);
            combo.setText(findString);
        }
    }

    private boolean isEditable() {
        boolean isEditable = this.fTarget == null ? false : this.fTarget.isEditable();
        return this.fIsTargetEditable && isEditable;
    }

    public void updateTarget(IFindReplaceTarget target, boolean isTargetEditable) {
        this.fIsTargetEditable = isTargetEditable;
        this.fNeedsInitialFindBeforeReplace = true;
        if (target != this.fTarget) {
            if (this.fTarget != null && this.fTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)this.fTarget).endSession();
            }
            this.fTarget = target;
            if (target != null) {
                this.fIsTargetSupportingRegEx = target instanceof IFindReplaceTargetExtension3;
            }
            if (this.fTarget != null && this.fTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)this.fTarget).beginSession();
                this.fGlobalInit = true;
                this.fGlobalRadioButton.setSelection(this.fGlobalInit);
                this.fSelectedRangeRadioButton.setSelection(!this.fGlobalInit);
                boolean bl = this.fUseSelectedLines = !this.fGlobalInit;
            }
        }
        if (this.okToUse((Control)this.fIsRegExCheckBox)) {
            this.fIsRegExCheckBox.setEnabled(this.fIsTargetSupportingRegEx);
        }
        if (this.okToUse((Control)this.fWholeWordCheckBox)) {
            this.fWholeWordCheckBox.setEnabled(!this.isRegExSearchAvailableAndChecked());
        }
        if (this.okToUse((Control)this.fIncrementalCheckBox)) {
            this.fIncrementalCheckBox.setEnabled(!this.isRegExSearchAvailableAndChecked());
        }
        if (this.okToUse((Control)this.fReplaceLabel)) {
            this.fReplaceLabel.setEnabled(this.isEditable());
            this.fReplaceField.setEnabled(this.isEditable());
            this.initFindStringFromSelection();
            this.initIncrementalBaseLocation();
            this.updateButtonState();
        }
        this.fGiveFocusToFindField = true;
        this.setContentAssistsEnablement(this.isRegExSearchAvailableAndChecked());
    }

    public void setParentShell(Shell shell) {
        if (shell != this.fParentShell) {
            if (this.fParentShell != null) {
                this.fParentShell.removeShellListener((ShellListener)this.fActivationListener);
            }
            this.fParentShell = shell;
            this.fParentShell.addShellListener((ShellListener)this.fActivationListener);
        }
        this.fActiveShell = shell;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = TextEditorPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        String[] replaceHistory;
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.fLocation = new Point(x, y);
        }
        catch (NumberFormatException e) {
            this.fLocation = null;
        }
        this.fWrapInit = s.getBoolean("wrap");
        this.fCaseInit = s.getBoolean("casesensitive");
        this.fWholeWordInit = s.getBoolean("wholeword");
        this.fIncrementalInit = s.getBoolean("incremental");
        this.fIsRegExInit = s.getBoolean("isRegEx");
        String[] findHistory = s.getArray("findhistory");
        if (findHistory != null) {
            List history = this.getFindHistory();
            history.clear();
            for (int i = 0; i < findHistory.length; ++i) {
                history.add(findHistory[i]);
            }
        }
        if ((replaceHistory = s.getArray("replacehistory")) != null) {
            List history = this.getReplaceHistory();
            history.clear();
            for (int i = 0; i < replaceHistory.length; ++i) {
                history.add(replaceHistory[i]);
            }
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        s.put("wrap", this.fWrapInit);
        s.put("casesensitive", this.fCaseInit);
        s.put("wholeword", this.fWholeWordInit);
        s.put("incremental", this.fIncrementalInit);
        s.put("isRegEx", this.fIsRegExInit);
        List history = this.getFindHistory();
        while (history.size() > 8) {
            history.remove(8);
        }
        String[] names = new String[history.size()];
        history.toArray(names);
        s.put("findhistory", names);
        history = this.getReplaceHistory();
        while (history.size() > 8) {
            history.remove(8);
        }
        names = new String[history.size()];
        history.toArray(names);
        s.put("replacehistory", names);
    }

    private SubjectControlContentAssistant createContentAssistant() {
        SubjectControlContentAssistant contentAssistant = new SubjectControlContentAssistant();
        contentAssistant.setRestoreCompletionProposalSize(this.getSettings("FindReplaceDialog.completion_proposal_size"));
        RegExContentAssistProcessor processor = new RegExContentAssistProcessor();
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        contentAssistant.enableAutoActivation(this.isRegExSearchAvailableAndChecked());
        contentAssistant.setProposalSelectorBackground(this.fProposalPopupBackgroundColor);
        contentAssistant.setProposalSelectorForeground(this.fProposalPopupForegroundColor);
        contentAssistant.setContextInformationPopupOrientation(20);
        contentAssistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        return contentAssistant;
    }

    private IDialogSettings getSettings(String sectionName) {
        IDialogSettings pluginDialogSettings = TextEditorPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = pluginDialogSettings.getSection(sectionName);
        if (settings == null) {
            settings = pluginDialogSettings.addNewSection(sectionName);
        }
        return settings;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FindModifyListener
    implements ModifyListener {
        private FindModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (FindReplaceDialog.this.isIncrementalSearch() && !FindReplaceDialog.this.isRegExSearchAvailableAndChecked()) {
                if (FindReplaceDialog.this.fFindField.getText().equals("") && FindReplaceDialog.this.fTarget != null) {
                    int offset = ((FindReplaceDialog)FindReplaceDialog.this).fIncrementalBaseLocation.x;
                    if (FindReplaceDialog.this.isForwardSearch() && !FindReplaceDialog.this.fNeedsInitialFindBeforeReplace || !FindReplaceDialog.this.isForwardSearch() && FindReplaceDialog.this.fNeedsInitialFindBeforeReplace) {
                        offset += ((FindReplaceDialog)FindReplaceDialog.this).fIncrementalBaseLocation.y;
                    }
                    FindReplaceDialog.this.fNeedsInitialFindBeforeReplace = false;
                    FindReplaceDialog.this.findAndSelect(offset, "", FindReplaceDialog.this.isForwardSearch(), FindReplaceDialog.this.isCaseSensitiveSearch(), FindReplaceDialog.this.isWholeWordSearch(), FindReplaceDialog.this.isRegExSearchAvailableAndChecked());
                } else {
                    FindReplaceDialog.this.performSearch(false);
                }
            }
            FindReplaceDialog.this.updateButtonState(!FindReplaceDialog.this.isIncrementalSearch());
        }
    }

    class ActivationListener
    extends ShellAdapter {
        ActivationListener() {
        }

        public void shellActivated(ShellEvent e) {
            String oldText = FindReplaceDialog.this.fFindField.getText();
            ArrayList oldList = new ArrayList();
            oldList.addAll(FindReplaceDialog.this.fFindHistory);
            FindReplaceDialog.this.readConfiguration();
            FindReplaceDialog.this.fFindField.removeModifyListener(FindReplaceDialog.this.fFindModifyListener);
            FindReplaceDialog.this.updateCombo(FindReplaceDialog.this.fFindField, FindReplaceDialog.this.fFindHistory);
            if (!((Object)FindReplaceDialog.this.fFindHistory).equals(oldList) && !FindReplaceDialog.this.fFindHistory.isEmpty()) {
                FindReplaceDialog.this.fFindField.setText((String)FindReplaceDialog.this.fFindHistory.get(0));
            } else {
                FindReplaceDialog.this.fFindField.setText(oldText);
            }
            if (this.findFieldHadFocus()) {
                FindReplaceDialog.this.fFindField.setSelection(new Point(0, FindReplaceDialog.this.fFindField.getText().length()));
            }
            FindReplaceDialog.this.fFindField.addModifyListener(FindReplaceDialog.this.fFindModifyListener);
            FindReplaceDialog.this.fActiveShell = (Shell)e.widget;
            FindReplaceDialog.this.updateButtonState();
            if (this.findFieldHadFocus() && FindReplaceDialog.this.getShell() == FindReplaceDialog.this.fActiveShell && !FindReplaceDialog.this.fFindField.isDisposed()) {
                FindReplaceDialog.this.fFindField.setFocus();
            }
        }

        private boolean findFieldHadFocus() {
            return FindReplaceDialog.this.fGiveFocusToFindField || FindReplaceDialog.this.okToUse((Control)FindReplaceDialog.this.fFindField) && FindReplaceDialog.this.fFindField.isFocusControl();
        }

        public void shellDeactivated(ShellEvent e) {
            FindReplaceDialog.this.fGiveFocusToFindField = FindReplaceDialog.this.fFindField.isFocusControl();
            FindReplaceDialog.this.storeSettings();
            FindReplaceDialog.this.fGlobalRadioButton.setSelection(true);
            FindReplaceDialog.this.fSelectedRangeRadioButton.setSelection(false);
            FindReplaceDialog.this.fUseSelectedLines = false;
            if (FindReplaceDialog.this.fTarget != null && FindReplaceDialog.this.fTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)FindReplaceDialog.this.fTarget).setScope(null);
            }
            FindReplaceDialog.this.fOldScope = null;
            FindReplaceDialog.this.fActiveShell = null;
            FindReplaceDialog.this.updateButtonState();
        }
    }
}

