/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.internal.runtime.Assert;

public class URLTool {
    public static URL appendTrailingSlash(String url) throws MalformedURLException {
        return URLTool.appendTrailingSlash(new URL(url));
    }

    public static URL appendTrailingSlash(URL url) {
        String file = url.getFile();
        if (file.endsWith("/")) {
            return url;
        }
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), file + "/");
        }
        catch (MalformedURLException e) {
            Assert.isTrue(false, "internal error");
            return null;
        }
    }

    public static URL getChild(String parent, String member) throws MalformedURLException {
        return URLTool.getChild(new URL(parent), member);
    }

    public static URL getChild(URL parent, String member) {
        String file = parent.getFile();
        if (!file.endsWith("/")) {
            file = file + "/";
        }
        try {
            return new URL(parent.getProtocol(), parent.getHost(), parent.getPort(), file + member);
        }
        catch (MalformedURLException e) {
            Assert.isTrue(false, "internal error");
            return null;
        }
    }

    public static Vector getElements(String url) throws MalformedURLException {
        return URLTool.getElements(new URL(url));
    }

    public static Vector getElements(URL url) {
        Vector<String> result = new Vector<String>(5);
        String lastElement = null;
        while ((lastElement = URLTool.getLastElement(url)) != null) {
            result.insertElementAt(lastElement, 0);
            url = URLTool.getParent(url);
        }
        return result;
    }

    public static String getLastElement(String url) throws MalformedURLException {
        return URLTool.getLastElement(new URL(url));
    }

    public static String getLastElement(URL url) {
        boolean isDirectory;
        String file = url.getFile();
        int len = file.length();
        if (len == 0 || len == 1 && file.charAt(0) == '/') {
            return null;
        }
        int lastSlashIndex = -1;
        for (int i = len - 2; lastSlashIndex == -1 && i >= 0; --i) {
            if (file.charAt(i) != '/') continue;
            lastSlashIndex = i;
        }
        boolean bl = isDirectory = file.charAt(len - 1) == '/';
        if (lastSlashIndex == -1) {
            if (isDirectory) {
                return file.substring(0, len - 1);
            }
            return file;
        }
        if (isDirectory) {
            return file.substring(lastSlashIndex + 1, len - 1);
        }
        return file.substring(lastSlashIndex + 1, len);
    }

    public static URL getParent(String url) throws MalformedURLException {
        return URLTool.getParent(new URL(url));
    }

    public static URL getParent(URL url) {
        String file = url.getFile();
        int len = file.length();
        if (len == 0 || len == 1 && file.charAt(0) == '/') {
            return null;
        }
        int lastSlashIndex = -1;
        for (int i = len - 2; lastSlashIndex == -1 && i >= 0; --i) {
            if (file.charAt(i) != '/') continue;
            lastSlashIndex = i;
        }
        file = lastSlashIndex == -1 ? "" : file.substring(0, lastSlashIndex + 1);
        try {
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
        }
        catch (MalformedURLException e) {
            Assert.isTrue(false, e.getMessage());
        }
        return url;
    }

    public static URL getRoot(String urlString) throws MalformedURLException {
        return URLTool.getRoot(new URL(urlString));
    }

    public static URL getRoot(URL url) {
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), "/");
        }
        catch (MalformedURLException e) {
            Assert.isTrue(false, "internal error");
            return null;
        }
    }

    public static URL removeTrailingSlash(String url) throws MalformedURLException {
        return URLTool.removeTrailingSlash(new URL(url));
    }

    public static URL removeTrailingSlash(URL url) {
        String file = url.getFile();
        if (file.endsWith("/")) {
            file = file.substring(0, file.length() - 1);
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
            }
            catch (MalformedURLException e) {
                Assert.isTrue(false, e.getMessage());
            }
        } else {
            return url;
        }
        return null;
    }

    public static boolean urlsOverlap(String url1, String url2) throws MalformedURLException {
        return URLTool.urlsOverlap(new URL(url1), new URL(url2));
    }

    public static boolean urlsOverlap(URL url1, URL url2) {
        if (!URLTool.getRoot(url1).equals(URLTool.getRoot(url2))) {
            return false;
        }
        Vector elements1 = URLTool.getElements(url1);
        Vector elements2 = URLTool.getElements(url2);
        for (int i = 0; i < elements1.size() && i < elements2.size(); ++i) {
            String element2;
            String element1 = (String)elements1.elementAt(i);
            if (element1.equals(element2 = (String)elements2.elementAt(i))) continue;
            return false;
        }
        return true;
    }
}

