/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.variants;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;

public abstract class ResourceVariantByteStore {
    public abstract void dispose();

    public abstract byte[] getBytes(IResource var1) throws TeamException;

    public abstract boolean setBytes(IResource var1, byte[] var2) throws TeamException;

    public abstract boolean flushBytes(IResource var1, int var2) throws TeamException;

    public abstract boolean deleteBytes(IResource var1) throws TeamException;

    public abstract IResource[] members(IResource var1) throws TeamException;

    protected boolean equals(byte[] syncBytes1, byte[] syncBytes2) {
        if (syncBytes1 == null) {
            return syncBytes2 == null;
        }
        if (syncBytes2 == null) {
            return false;
        }
        if (syncBytes1.length != syncBytes2.length) {
            return false;
        }
        for (int i = 0; i < syncBytes1.length; ++i) {
            if (syncBytes1[i] == syncBytes2[i]) continue;
            return false;
        }
        return true;
    }

    public void run(IResource root, IWorkspaceRunnable runnable, IProgressMonitor monitor) throws TeamException {
        try {
            runnable.run(monitor);
        }
        catch (CoreException e) {
            throw TeamException.asTeamException(e);
        }
    }
}

