/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.registers;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewContentProvider;
import org.eclipse.debug.ui.IDebugView;

public class RegistersViewContentProvider
extends VariablesViewContentProvider {
    public RegistersViewContentProvider(IDebugView view) {
        super(view);
    }

    public Object[] getChildren(Object parent) {
        Object[] children = null;
        try {
            if (parent instanceof IStackFrame) {
                children = ((IStackFrame)parent).getRegisterGroups();
            } else if (parent instanceof IRegisterGroup) {
                children = ((IRegisterGroup)parent).getRegisters();
            } else if (parent instanceof IVariable) {
                children = super.getChildren(parent);
            }
            if (children != null) {
                this.cache(parent, children);
                return children;
            }
        }
        catch (DebugException de) {
            if (this.getExceptionHandler() != null) {
                this.getExceptionHandler().handleException(de);
            }
            DebugUIPlugin.log(de);
        }
        return new Object[0];
    }

    public boolean hasChildren(Object element) {
        try {
            if (element instanceof IStackFrame) {
                return ((IStackFrame)element).hasRegisterGroups();
            }
            if (element instanceof IRegisterGroup) {
                return ((IRegisterGroup)element).hasRegisters();
            }
        }
        catch (DebugException de) {
            DebugUIPlugin.log(de);
            return false;
        }
        return super.hasChildren(element);
    }

    protected void setExceptionHandler(IDebugExceptionHandler handler) {
        super.setExceptionHandler(handler);
    }
}

