#ifndef _ISO_88591_18_H_
#define _ISO_88591_18_H_
#include <devfont.h>

#define GAPS_BETWEEN_CHARACTER	3
#define TOTAL_CHARACTER_NUM 95

static const FONTINDEX ISO_88591_18_font_map[TOTAL_CHARACTER_NUM] = {
{0x0020,0x02,0x0000},
{0x0021,0x04,0x0005},
{0x0022,0x06,0x000E},
{0x0023,0x07,0x001C},
{0x0024,0x06,0x002C},
{0x0025,0x08,0x003A},
{0x0026,0x07,0x004C},
{0x0027,0x02,0x005C},
{0x0028,0x04,0x0061},
{0x0029,0x04,0x006A},
{0x002A,0x07,0x0073},
{0x002B,0x06,0x0083},
{0x002C,0x03,0x0091},
{0x002D,0x06,0x0098},
{0x002E,0x03,0x00A6},
{0x002F,0x06,0x00AD},
{0x0030,0x06,0x00BB},
{0x0031,0x05,0x00C9},
{0x0032,0x06,0x00D5},
{0x0033,0x06,0x00E3},
{0x0034,0x07,0x00F1},
{0x0035,0x06,0x0101},
{0x0036,0x06,0x010F},
{0x0037,0x06,0x011D},
{0x0038,0x06,0x012B},
{0x0039,0x06,0x0139},
{0x003A,0x03,0x0147},
{0x003B,0x03,0x014E},
{0x003C,0x06,0x0155},
{0x003D,0x06,0x0163},
{0x003E,0x06,0x0171},
{0x003F,0x06,0x017F},
{0x0040,0x08,0x018D},
{0x0041,0x06,0x019F},
{0x0042,0x06,0x01AD},
{0x0043,0x06,0x01BB},
{0x0044,0x06,0x01C9},
{0x0045,0x06,0x01D7},
{0x0046,0x06,0x01E5},
{0x0047,0x06,0x01F3},
{0x0048,0x06,0x0201},
{0x0049,0x04,0x020F},
{0x004A,0x06,0x0218},
{0x004B,0x06,0x0226},
{0x004C,0x06,0x0234},
{0x004D,0x07,0x0242},
{0x004E,0x07,0x0252},
{0x004F,0x06,0x0262},
{0x0050,0x06,0x0270},
{0x0051,0x06,0x027E},
{0x0052,0x06,0x028C},
{0x0053,0x06,0x029A},
{0x0054,0x06,0x02A8},
{0x0055,0x06,0x02B6},
{0x0056,0x06,0x02C4},
{0x0057,0x07,0x02D2},
{0x0058,0x06,0x02E2},
{0x0059,0x06,0x02F0},
{0x005A,0x06,0x02FE},
{0x005B,0x04,0x030C},
{0x005C,0x06,0x0315},
{0x005D,0x04,0x0323},
{0x005E,0x06,0x032C},
{0x005F,0x08,0x033A},
{0x0060,0x04,0x034C},
{0x0061,0x06,0x0355},
{0x0062,0x06,0x0363},
{0x0063,0x06,0x0371},
{0x0064,0x06,0x037F},
{0x0065,0x06,0x038D},
{0x0066,0x06,0x039B},
{0x0067,0x06,0x03A9},
{0x0068,0x06,0x03B7},
{0x0069,0x06,0x03C5},
{0x006A,0x05,0x03D3},
{0x006B,0x06,0x03DF},
{0x006C,0x06,0x03ED},
{0x006D,0x07,0x03FB},
{0x006E,0x06,0x040B},
{0x006F,0x06,0x0419},
{0x0070,0x06,0x0427},
{0x0071,0x06,0x0435},
{0x0072,0x06,0x0443},
{0x0073,0x06,0x0451},
{0x0074,0x06,0x045F},
{0x0075,0x06,0x046D},
{0x0076,0x06,0x047B},
{0x0077,0x07,0x0489},
{0x0078,0x06,0x0499},
{0x0079,0x07,0x04A7},
{0x007A,0x06,0x04B7},
{0x007B,0x05,0x04C5},
{0x007C,0x02,0x04D1},
{0x007D,0x05,0x04D6},
{0x007E,0x08,0x04E2},
};

static unsigned char ISO_88591_18_osdfont_dat[] = {
// 0x0020 2x18 --  
0x00,0x00,0x00,0x00,0x00,
// 0x0021 4x18 --  !
0x00,0x00,0x6F,0xFF,0x66,0x06,0x60,0x00,0x00,
// 0x0022 6x18 --  "
0x00,0x00,0x00,0xCF,0x3C,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0023 7x18 --  #
0x00,0x00,0x00,0x06,0xCD,0xBF,0xB6,0x6C,0xDB,0xFB,0x66,0xC0,0x00,0x00,0x00,0x00,
// 0x0024 6x18 --  $
0x00,0x03,0x0C,0x7B,0x3C,0x18,0x30,0x60,0xF3,0x78,0xC3,0x00,0x00,0x00,
// 0x0025 8x18 --  %
0x00,0x00,0x00,0x70,0xD8,0xDA,0x76,0x0C,0x18,0x30,0x6E,0x5B,0x1B,0x0E,0x00,0x00,
0x00,0x00,
// 0x0026 7x18 --  &
0x00,0x00,0x00,0x07,0x1B,0x36,0x38,0xC1,0xBF,0x36,0x67,0x60,0x00,0x00,0x00,0x00,
// 0x0027 2x18 --  '
0x00,0xFC,0x00,0x00,0x00,
// 0x0028 4x18 --  (
0x00,0x00,0x36,0x6C,0xCC,0xCC,0x66,0x30,0x00,
// 0x0029 4x18 --  )
0x00,0x00,0xC6,0x63,0x33,0x33,0x66,0xC0,0x00,
// 0x002A 7x18 --  *
0x00,0x00,0x00,0x00,0x00,0x1B,0x1C,0xFE,0x71,0xB0,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x002B 6x18 --  +
0x00,0x00,0x00,0x00,0x03,0x0C,0xFC,0xC3,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x002C 3x18 --  ,
0x00,0x00,0x00,0x00,0x7E,0xF0,0x00,
// 0x002D 6x18 --  -
0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x002E 3x18 --  .
0x00,0x00,0x00,0x00,0x7E,0x00,0x00,
// 0x002F 6x18 --  /
0x00,0x00,0x00,0x0C,0x31,0x86,0x30,0xC6,0x18,0xC3,0x00,0x00,0x00,0x00,
// 0x0030 6x18 --  0
0x00,0x00,0x00,0x7B,0x3D,0xF7,0xCF,0xBE,0xF3,0x78,0x00,0x00,0x00,0x00,
// 0x0031 5x18 --  1
0x00,0x00,0x01,0x9F,0xE3,0x18,0xC6,0x31,0x80,0x00,0x00,0x00,
// 0x0032 6x18 --  2
0x00,0x00,0x00,0x7B,0x3C,0xC3,0x18,0xC6,0x30,0xFC,0x00,0x00,0x00,0x00,
// 0x0033 6x18 --  3
0x00,0x00,0x00,0x7B,0x3C,0xC3,0x38,0x3C,0xF3,0x78,0x00,0x00,0x00,0x00,
// 0x0034 7x18 --  4
0x00,0x00,0x00,0x06,0x0C,0x1B,0x36,0x6D,0x9B,0xF8,0x60,0xC0,0x00,0x00,0x00,0x00,
// 0x0035 6x18 --  5
0x00,0x00,0x00,0xFF,0x0C,0x30,0xF8,0x30,0xC6,0xF0,0x00,0x00,0x00,0x00,
// 0x0036 6x18 --  6
0x00,0x00,0x00,0x38,0xC6,0x3E,0xCF,0x3C,0xF3,0x78,0x00,0x00,0x00,0x00,
// 0x0037 6x18 --  7
0x00,0x00,0x00,0xFC,0x31,0x86,0x30,0xC6,0x18,0x60,0x00,0x00,0x00,0x00,
// 0x0038 6x18 --  8
0x00,0x00,0x00,0x7B,0x3C,0xFB,0x7B,0x7C,0xF3,0x78,0x00,0x00,0x00,0x00,
// 0x0039 6x18 --  9
0x00,0x00,0x00,0x7B,0x3C,0xF3,0xCD,0xF1,0x8C,0x70,0x00,0x00,0x00,0x00,
// 0x003A 3x18 --  :
0x00,0x00,0x3F,0x00,0x7E,0x00,0x00,
// 0x003B 3x18 --  ;
0x00,0x00,0x3F,0x00,0x7E,0xF0,0x00,
// 0x003C 6x18 --  <
0x00,0x00,0x00,0x0C,0x63,0x18,0xC1,0x83,0x06,0x0C,0x00,0x00,0x00,0x00,
// 0x003D 6x18 --  =
0x00,0x00,0x00,0x00,0x00,0x3F,0x03,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x003E 6x18 --  >
0x00,0x00,0x00,0xC1,0x83,0x06,0x0C,0x63,0x18,0xC0,0x00,0x00,0x00,0x00,
// 0x003F 6x18 --  ?
0x00,0x00,0x00,0x7B,0x3C,0xC6,0x30,0xC0,0x0C,0x30,0x00,0x00,0x00,0x00,
// 0x0040 8x18 --  @
0x00,0x00,0x00,0x00,0x7E,0xC3,0xC3,0xCF,0xDB,0xDB,0xCF,0xC0,0x7F,0x00,0x00,0x00,
0x00,0x00,
// 0x0041 6x18 --  A
0x00,0x00,0x00,0x31,0xEC,0xF3,0xCF,0xFC,0xF3,0xCC,0x00,0x00,0x00,0x00,
// 0x0042 6x18 --  B
0x00,0x00,0x00,0xFB,0x3C,0xF3,0xFB,0x3C,0xF3,0xF8,0x00,0x00,0x00,0x00,
// 0x0043 6x18 --  C
0x00,0x00,0x00,0x7B,0x3C,0xF0,0xC3,0x0C,0xF3,0x78,0x00,0x00,0x00,0x00,
// 0x0044 6x18 --  D
0x00,0x00,0x00,0xF3,0x6C,0xF3,0xCF,0x3C,0xF6,0xF0,0x00,0x00,0x00,0x00,
// 0x0045 6x18 --  E
0x00,0x00,0x00,0xFF,0x0C,0x30,0xFB,0x0C,0x30,0xFC,0x00,0x00,0x00,0x00,
// 0x0046 6x18 --  F
0x00,0x00,0x00,0xFF,0x0C,0x30,0xFB,0x0C,0x30,0xC0,0x00,0x00,0x00,0x00,
// 0x0047 6x18 --  G
0x00,0x00,0x00,0x7B,0x3C,0xF0,0xC3,0x7C,0xF3,0x7C,0x00,0x00,0x00,0x00,
// 0x0048 6x18 --  H
0x00,0x00,0x00,0xCF,0x3C,0xF3,0xFF,0x3C,0xF3,0xCC,0x00,0x00,0x00,0x00,
// 0x0049 4x18 --  I
0x00,0x00,0xF6,0x66,0x66,0x66,0xF0,0x00,0x00,
// 0x004A 6x18 --  J
0x00,0x00,0x00,0x0C,0x30,0xC3,0x0C,0x3C,0xF3,0x78,0x00,0x00,0x00,0x00,
// 0x004B 6x18 --  K
0x00,0x00,0x00,0xCF,0x3D,0xB6,0xF3,0x6D,0xB3,0xCC,0x00,0x00,0x00,0x00,
// 0x004C 6x18 --  L
0x00,0x00,0x00,0xC3,0x0C,0x30,0xC3,0x0C,0x30,0xFC,0x00,0x00,0x00,0x00,
// 0x004D 7x18 --  M
0x00,0x00,0x00,0x0C,0x78,0xFB,0xEB,0xD7,0xAF,0x1E,0x3C,0x60,0x00,0x00,0x00,0x00,
// 0x004E 7x18 --  N
0x00,0x00,0x00,0x0C,0x78,0xF9,0xFB,0xDF,0x9F,0x1E,0x3C,0x60,0x00,0x00,0x00,0x00,
// 0x004F 6x18 --  O
0x00,0x00,0x00,0x7B,0x3C,0xF3,0xCF,0x3C,0xF3,0x78,0x00,0x00,0x00,0x00,
// 0x0050 6x18 --  P
0x00,0x00,0x00,0xFB,0x3C,0xF3,0xFB,0x0C,0x30,0xC0,0x00,0x00,0x00,0x00,
// 0x0051 6x18 --  Q
0x00,0x00,0x00,0x7B,0x3C,0xF3,0xCF,0x3C,0xF3,0x78,0x60,0xC0,0x00,0x00,
// 0x0052 6x18 --  R
0x00,0x00,0x00,0xFB,0x3C,0xF3,0xFB,0x6C,0xF3,0xCC,0x00,0x00,0x00,0x00,
// 0x0053 6x18 --  S
0x00,0x00,0x00,0x7B,0x3C,0x18,0x30,0x60,0xF3,0x78,0x00,0x00,0x00,0x00,
// 0x0054 6x18 --  T
0x00,0x00,0x00,0xFC,0xC3,0x0C,0x30,0xC3,0x0C,0x30,0x00,0x00,0x00,0x00,
// 0x0055 6x18 --  U
0x00,0x00,0x00,0xCF,0x3C,0xF3,0xCF,0x3C,0xF3,0x78,0x00,0x00,0x00,0x00,
// 0x0056 6x18 --  V
0x00,0x00,0x00,0xCF,0x3C,0xF3,0xCF,0x3C,0xDE,0x30,0x00,0x00,0x00,0x00,
// 0x0057 7x18 --  W
0x00,0x00,0x00,0x0C,0x78,0xF1,0xEB,0xD7,0xAD,0xB3,0x66,0xC0,0x00,0x00,0x00,0x00,
// 0x0058 6x18 --  X
0x00,0x00,0x00,0xCF,0x36,0x8C,0x31,0x6C,0xF3,0xCC,0x00,0x00,0x00,0x00,
// 0x0059 6x18 --  Y
0x00,0x00,0x00,0xCF,0x3C,0xF3,0x78,0xC3,0x0C,0x30,0x00,0x00,0x00,0x00,
// 0x005A 6x18 --  Z
0x00,0x00,0x00,0xFC,0x30,0xC6,0x31,0x8C,0x30,0xFC,0x00,0x00,0x00,0x00,
// 0x005B 4x18 --  [
0x00,0x00,0xFC,0xCC,0xCC,0xCC,0xCC,0xCF,0x00,
// 0x005C 6x18 --  "\"
0x00,0x00,0x00,0xC3,0x06,0x18,0x30,0xC1,0x86,0x0C,0x30,0x00,0x00,0x00,
// 0x005D 4x18 --  ]
0x00,0x00,0xF3,0x33,0x33,0x33,0x33,0x3F,0x00,
// 0x005E 6x18 --  ^
0x00,0x03,0x1E,0xCC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x005F 8x18 --  _
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0x00,0x00,
// 0x0060 4x18 --  `
0x00,0xE6,0x30,0x00,0x00,0x00,0x00,0x00,0x00,
// 0x0061 6x18 --  a
0x00,0x00,0x00,0x00,0x07,0x83,0x0D,0xFC,0xF3,0x7C,0x00,0x00,0x00,0x00,
// 0x0062 6x18 --  b
0x00,0x00,0x00,0xC3,0x0F,0xB3,0xCF,0x3C,0xF3,0xF8,0x00,0x00,0x00,0x00,
// 0x0063 6x18 --  c
0x00,0x00,0x00,0x00,0x07,0xB3,0xC3,0x0C,0x33,0x78,0x00,0x00,0x00,0x00,
// 0x0064 6x18 --  d
0x00,0x00,0x00,0x0C,0x37,0xF3,0xCF,0x3C,0xF3,0x7C,0x00,0x00,0x00,0x00,
// 0x0065 6x18 --  e
0x00,0x00,0x00,0x00,0x07,0xB3,0xCF,0xFC,0x30,0x78,0x00,0x00,0x00,0x00,
// 0x0066 6x18 --  f
0x00,0x00,0x00,0x3D,0x86,0x18,0xFD,0x86,0x18,0x60,0x00,0x00,0x00,0x00,
// 0x0067 6x18 --  g
0x00,0x00,0x00,0x00,0x07,0xF3,0xCF,0x3C,0xF3,0x7C,0x30,0xFE,0x00,0x00,
// 0x0068 6x18 --  h
0x00,0x00,0x00,0xC3,0x0F,0xB3,0xCF,0x3C,0xF3,0xCC,0x00,0x00,0x00,0x00,
// 0x0069 6x18 --  i
0x00,0x00,0x0C,0x30,0x0F,0x0C,0x30,0xC3,0x0C,0xFC,0x00,0x00,0x00,0x00,
// 0x006A 5x18 --  j
0x00,0x00,0x31,0x81,0xE3,0x18,0xC6,0x31,0x8C,0x7E,0x00,0x00,
// 0x006B 6x18 --  k
0x00,0x00,0x00,0xC3,0x0C,0xF3,0xDB,0xCD,0xB3,0xCC,0x00,0x00,0x00,0x00,
// 0x006C 6x18 --  l
0x00,0x00,0x00,0xF0,0xC3,0x0C,0x30,0xC3,0x0C,0xFC,0x00,0x00,0x00,0x00,
// 0x006D 7x18 --  m
0x00,0x00,0x00,0x00,0x00,0x3F,0x6B,0xD7,0xAF,0x5E,0xBC,0x60,0x00,0x00,0x00,0x00,
// 0x006E 6x18 --  n
0x00,0x00,0x00,0x00,0x0F,0xB3,0xCF,0x3C,0xF3,0xCC,0x00,0x00,0x00,0x00,
// 0x006F 6x18 --  o
0x00,0x00,0x00,0x00,0x07,0xB3,0xCF,0x3C,0xF3,0x78,0x00,0x00,0x00,0x00,
// 0x0070 6x18 --  p
0x00,0x00,0x00,0x00,0x0F,0xB3,0xCF,0x3C,0xF3,0xFB,0x0C,0x30,0x00,0x00,
// 0x0071 6x18 --  q
0x00,0x00,0x00,0x00,0x07,0xF3,0xCF,0x3C,0xF3,0x7C,0x30,0xC3,0x00,0x00,
// 0x0072 6x18 --  r
0x00,0x00,0x00,0x00,0x0C,0xF7,0xE3,0x0C,0x30,0xC0,0x00,0x00,0x00,0x00,
// 0x0073 6x18 --  s
0x00,0x00,0x00,0x00,0x07,0xF0,0xC1,0xE0,0xC3,0xF8,0x00,0x00,0x00,0x00,
// 0x0074 6x18 --  t
0x00,0x00,0x00,0x61,0x8F,0xD8,0x61,0x86,0x18,0x3C,0x00,0x00,0x00,0x00,
// 0x0075 6x18 --  u
0x00,0x00,0x00,0x00,0x0C,0xF3,0xCF,0x3C,0xF3,0x7C,0x00,0x00,0x00,0x00,
// 0x0076 6x18 --  v
0x00,0x00,0x00,0x00,0x0C,0xF3,0xCF,0x3C,0xDE,0x30,0x00,0x00,0x00,0x00,
// 0x0077 7x18 --  w
0x00,0x00,0x00,0x00,0x00,0x31,0xEB,0xD7,0xAF,0x5B,0x66,0xC0,0x00,0x00,0x00,0x00,
// 0x0078 6x18 --  x
0x00,0x00,0x00,0x00,0x0C,0xF3,0x78,0xC7,0xB3,0xCC,0x00,0x00,0x00,0x00,
// 0x0079 7x18 --  y
0x00,0x00,0x00,0x00,0x00,0x19,0xB3,0x66,0xCD,0x9B,0x33,0xC1,0x86,0x78,0x00,0x00,
// 0x007A 6x18 --  z
0x00,0x00,0x00,0x00,0x0F,0xC3,0x18,0xC6,0x30,0xFC,0x00,0x00,0x00,0x00,
// 0x007B 5x18 --  {
0x00,0x00,0x01,0x98,0xC6,0x66,0x18,0x63,0x18,0x60,0x00,0x00,
// 0x007C 2x18 --  |
0x00,0xFF,0xFF,0xFF,0x00,
// 0x007D 5x18 --  }
0x00,0x00,0x0C,0x31,0x8C,0x30,0xCC,0xC6,0x33,0x00,0x00,0x00,
// 0x007E 8x18 --  ~
0x00,0x00,0x00,0x00,0x71,0xDB,0x8E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,
};

static unsigned char * ISO_88591_18GetCharacterFontBit(unsigned short ch, unsigned short *font_width)
{
    int iIndex, iUpPos = 0, iDownPos = TOTAL_CHARACTER_NUM;
    //unsigned char *font_dat = NULL;
    
    while(iUpPos <= iDownPos){
        iIndex = (iUpPos + iDownPos) >> 1 ;
        if(ISO_88591_18_font_map[iIndex].character == ch) //found this character
            break ;
        else if(ISO_88591_18_font_map[iIndex].character > ch)
            iDownPos = iIndex - 1;
        else
            iUpPos = iIndex + 1;
    }
    if(iUpPos > iDownPos)//don't found character font data
        iIndex = 0 ;//use first character font data
    *font_width = ISO_88591_18_font_map[iIndex].width ;
    return &ISO_88591_18_osdfont_dat[ISO_88591_18_font_map[iIndex].offset] ;
}

FONT ISO_88591_18Font = {
	"ISO_88591_18",
	18,
	0,
	18,
	0,
	GAPS_BETWEEN_CHARACTER,
	TOTAL_CHARACTER_NUM,
	ISO_88591_18GetCharacterFontBit
} ;

#undef GAPS_BETWEEN_CHARACTER
#undef TOTAL_CHARACTER_NUM
#endif